/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state;

import org.aesh.command.CommandDefinition;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.cmd.state.NoStateCommandActivator;
import org.jboss.galleon.cli.model.state.State;

@CommandDefinition(name="new", description="New provisioning state", activator=NoStateCommandActivator.class)
public class StateNewCommand
extends PmSessionCommand {
    @Override
    protected void runCommand(PmCommandInvocation invoc) throws CommandExecutionException {
        State session;
        if (invoc.getPmSession().getState() != null) {
            throw new CommandExecutionException("Provisioning session already set");
        }
        try {
            session = new State(invoc.getPmSession());
        }
        catch (Exception ex) {
            throw new CommandExecutionException(ex);
        }
        invoc.getPmSession().setState(session);
        invoc.setPrompt(PmSession.buildPrompt(invoc.getPmSession().getState().getPath()));
        invoc.println("Entering provisioning composition mode. Use 'feature-pack add' command to add content. Call 'leave' to leave this mode.");
    }
}

