/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aesh.command.CommandDefinition;
import org.aesh.command.activator.OptionActivator;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.impl.internal.ParsedOption;
import org.aesh.command.option.Option;
import org.aesh.utils.Config;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.cmd.AbstractPathCompleter;
import org.jboss.galleon.cli.cmd.state.StateCommandActivator;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.cli.model.FeatureInfo;
import org.jboss.galleon.cli.model.FeatureSpecInfo;
import org.jboss.galleon.cli.model.Group;
import org.jboss.galleon.cli.model.Identity;
import org.jboss.galleon.cli.model.PackageInfo;
import org.jboss.galleon.cli.model.state.State;
import org.jboss.galleon.cli.path.FeatureContainerPathConsumer;
import org.jboss.galleon.cli.path.PathConsumerException;
import org.jboss.galleon.cli.path.PathParser;
import org.jboss.galleon.cli.path.PathParserException;
import org.jboss.galleon.runtime.ResolvedSpecId;

@CommandDefinition(name="search", description="search the state for the provided content", activator=StateCommandActivator.class)
public class StateSearchCommand
extends PmSessionCommand {
    @Option(required=false, activator=QueryActivator.class)
    private String query;
    @Option(required=false, name="package", completer=PackagesCompleter.class, activator=PackageActivator.class)
    private String pkg;

    @Override
    protected void runCommand(PmCommandInvocation invoc) throws CommandExecutionException {
        try {
            FeatureContainer container = invoc.getPmSession().getContainer();
            if (this.pkg != null) {
                PackageInfo spec = this.getPackage(invoc.getPmSession().getState(), this.pkg);
                Set<ResolvedSpecId> fspecs = this.findFeatures(spec, container);
                invoc.println("Reachable from features:");
                for (ResolvedSpecId id : fspecs) {
                    List<FeatureInfo> features = container.getAllFeatures().get(id);
                    if (features != null) {
                        for (FeatureInfo fi : features) {
                            invoc.println("  " + fi.getPath());
                        }
                        continue;
                    }
                    invoc.println("      [spec only] " + this.toPath(id));
                }
                return;
            }
            invoc.println("In packages:");
            StringBuilder pBuilder = new StringBuilder();
            for (Map.Entry<String, Group> entry : container.getPackages().entrySet()) {
                Group root = entry.getValue();
                for (Group g : root.getGroups()) {
                    PackageInfo p = g.getPackage();
                    if (!p.getIdentity().toString().contains(this.query)) continue;
                    pBuilder.append("  /packages/" + p.getIdentity()).append(Config.getLineSeparator());
                    pBuilder.append("    Reachable from features:").append(Config.getLineSeparator());
                    Set<ResolvedSpecId> fspecs = this.findFeatures(p, container);
                    for (ResolvedSpecId id : fspecs) {
                        List<FeatureInfo> features = container.getAllFeatures().get(id);
                        if (features != null) {
                            for (FeatureInfo fi : features) {
                                pBuilder.append("      " + fi.getPath()).append(Config.getLineSeparator());
                            }
                            continue;
                        }
                        pBuilder.append("      [spec only] " + this.toPath(id)).append(Config.getLineSeparator());
                    }
                }
            }
            if (pBuilder.length() != 0) {
                invoc.println(pBuilder.toString());
            } else {
                invoc.println("Not found in any packages.");
            }
            pBuilder = new StringBuilder();
            invoc.println("In features:");
            for (Map.Entry<Object, Object> entry : container.getAllFeatures().entrySet()) {
                ResolvedSpecId id = (ResolvedSpecId)entry.getKey();
                List fs = (List)entry.getValue();
                if (fs == null) {
                    if (!id.getName().contains(this.query)) continue;
                    pBuilder.append("  [spec only] " + this.toPath(id)).append(Config.getLineSeparator());
                    continue;
                }
                for (FeatureInfo fi : fs) {
                    if (!fi.getPath().contains(this.query)) continue;
                    pBuilder.append("  " + fi.getPath()).append(Config.getLineSeparator());
                }
            }
            if (pBuilder.length() != 0) {
                invoc.println(pBuilder.toString());
            } else {
                invoc.println("Not found in any feature or feature-spec names.");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CommandExecutionException(ex);
        }
    }

    private String toPath(ResolvedSpecId id) {
        return "/feature-specs/" + Identity.buildOrigin(id.getGav()) + '/' + id.getName().replaceAll("\\.", "/");
    }

    private Set<ResolvedSpecId> findFeatures(PackageInfo spec, FeatureContainer container) {
        HashSet<ResolvedSpecId> fspecs = new HashSet<ResolvedSpecId>();
        block0: for (Map.Entry<ResolvedSpecId, FeatureSpecInfo> features : container.getAllSpecs().entrySet()) {
            for (PackageInfo info : features.getValue().getModules()) {
                Group grp = container.getAllPackages().get(info.getIdentity());
                HashSet<Identity> identities = new HashSet<Identity>();
                this.visitPkg(grp, identities);
                if (!identities.contains(spec.getIdentity())) continue;
                fspecs.add(features.getKey());
                continue block0;
            }
        }
        return fspecs;
    }

    private PackageInfo getPackage(State state, String id) throws PathParserException, PathConsumerException, ProvisioningException {
        String path = "/packages/" + id;
        FeatureContainerPathConsumer consumer = new FeatureContainerPathConsumer(state.getContainer(), false);
        PathParser.parse(path, consumer);
        Group grp = consumer.getCurrentNode(path);
        if (grp == null) {
            throw new ProvisioningException("Invalid path");
        }
        if (grp.getPackage() == null) {
            throw new ProvisioningException("Path is not a package");
        }
        return grp.getPackage();
    }

    private void visitPkg(Group pkg, Set<Identity> identities) {
        if (!identities.contains(pkg.getIdentity())) {
            identities.add(pkg.getIdentity());
            for (Group dep : pkg.getGroups()) {
                this.visitPkg(dep, identities);
            }
        }
    }

    public static class PackagesCompleter
    extends AbstractPathCompleter {
        @Override
        protected String getCurrentPath(PmCompleterInvocation session) throws Exception {
            return "/packages/";
        }

        @Override
        protected void filterCandidates(FeatureContainerPathConsumer consumer, List<String> candidates) {
        }

        @Override
        protected FeatureContainer getContainer(PmCompleterInvocation completerInvocation) throws Exception {
            return completerInvocation.getPmSession().getContainer();
        }
    }

    public static class PackageActivator
    implements OptionActivator {
        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            ParsedOption opt = parsedCommand.findLongOptionNoActivatorCheck("query");
            return opt == null || opt.value() == null;
        }
    }

    public static class QueryActivator
    implements OptionActivator {
        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            ParsedOption opt = parsedCommand.findLongOptionNoActivatorCheck("package");
            return opt == null || opt.value() == null;
        }
    }
}

