/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state.fp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Argument;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.AbstractCompleter;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.cmd.state.AbstractStateCommand;
import org.jboss.galleon.cli.cmd.state.fp.RemoveFeaturePackCommandActivator;
import org.jboss.galleon.cli.model.state.State;
import org.jboss.galleon.config.FeaturePackConfig;

@CommandDefinition(name="remove", description="Remove a feature-pack", activator=RemoveFeaturePackCommandActivator.class)
public class StateRemoveFeaturePackCommand
extends AbstractStateCommand {
    @Argument(completer=ProvisionedFPCompleter.class)
    protected String coords;

    @Override
    protected void runCommand(PmCommandInvocation invoc, State session) throws IOException, ProvisioningException, CommandExecutionException {
        session.removeDependency(invoc.getPmSession(), ArtifactCoords.newGav(this.coords));
    }

    public static class ProvisionedFPCompleter
    extends AbstractCompleter {
        @Override
        protected List<String> getItems(PmCompleterInvocation completerInvocation) {
            State session = completerInvocation.getPmSession().getState();
            ArrayList<String> lst = new ArrayList<String>();
            if (session != null) {
                for (FeaturePackConfig fp : session.getConfig().getFeaturePackDeps()) {
                    lst.add(fp.getGav().toString());
                }
            }
            return lst;
        }
    }
}

