/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.repomanager.fs;

import difflib.DiffUtils;
import difflib.Patch;
import difflib.PatchFailedException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.jboss.galleon.repomanager.fs.FsTaskContext;
import org.jboss.galleon.repomanager.fs.RelativeTargetTask;

public class ApplyPatchTask
extends RelativeTargetTask {
    private final List<String> diff;

    public ApplyPatchTask(String relativeTarget, List<String> diff) {
        super(relativeTarget);
        this.diff = diff;
    }

    @Override
    public void execute(FsTaskContext ctx) throws IOException {
        Path target = this.resolveTarget(ctx);
        try {
            Patch<String> patch = DiffUtils.parseUnifiedDiff(this.diff);
            List<String> updatedLines = DiffUtils.patch(Files.readAllLines(target, StandardCharsets.UTF_8), patch);
            Files.write(target, updatedLines, new OpenOption[0]);
        }
        catch (PatchFailedException ex) {
            throw new IOException("Couldn't apply patch on " + target, ex);
        }
    }
}

