/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.repomanager.fs;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import org.jboss.galleon.repomanager.fs.FsTaskContext;
import org.jboss.galleon.repomanager.fs.SrcPathTask;
import org.jboss.galleon.util.IoUtils;

class DirCopy
extends SrcPathTask {
    private final boolean contentOnly;

    DirCopy(Path src, String relativeTarget, boolean contentOnly, boolean isContent) {
        super(src, relativeTarget, isContent);
        this.contentOnly = contentOnly;
    }

    DirCopy(Path src, String relativeTarget, boolean contentOnly) {
        this(src, relativeTarget, contentOnly, true);
    }

    @Override
    public void execute(FsTaskContext ctx) throws IOException {
        Path target = this.resolveTarget(ctx);
        if (this.contentOnly) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.src);){
                for (Path p : stream) {
                    IoUtils.copy(p, target);
                }
            }
        } else {
            IoUtils.copy(this.src, target);
        }
    }
}

