/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.config.FeatureConfig;
import org.jboss.galleon.config.FeatureGroupSupport;
import org.jboss.galleon.runtime.ConfigModelStack;
import org.jboss.galleon.runtime.ResolvedFeatureId;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.util.CollectionUtils;

public class ResolvedFeatureGroupConfig {
    final ConfigModelStack configStack;
    final ArtifactCoords.Gav gav;
    final FeatureGroupSupport fg;
    boolean inheritFeatures = true;
    Set<ResolvedSpecId> includedSpecs = Collections.emptySet();
    Map<ResolvedFeatureId, FeatureConfig> includedFeatures = Collections.emptyMap();
    Set<ResolvedSpecId> excludedSpecs = Collections.emptySet();
    Set<ResolvedFeatureId> excludedFeatures = Collections.emptySet();

    ResolvedFeatureGroupConfig(ConfigModelStack configStack, FeatureGroupSupport fg, ArtifactCoords.Gav gav) {
        this.configStack = configStack;
        this.gav = gav;
        this.fg = fg;
    }

    ResolvedFeatureGroupConfig setInheritFeatures(boolean inheritFeatures) {
        this.inheritFeatures = inheritFeatures;
        return this;
    }

    void includeSpec(ResolvedSpecId specId) {
        this.includedSpecs = CollectionUtils.add(this.includedSpecs, specId);
    }

    void excludeSpec(ResolvedSpecId specId) {
        this.excludedSpecs = CollectionUtils.add(this.excludedSpecs, specId);
    }

    void includeFeature(ResolvedFeatureId id, FeatureConfig fc) {
        this.includedFeatures = CollectionUtils.putLinked(this.includedFeatures, id, fc);
    }

    void excludeFeature(ResolvedFeatureId id) {
        this.excludedFeatures = CollectionUtils.add(this.excludedFeatures, id);
    }

    public boolean hasExcludedSpecs() {
        return !this.excludedSpecs.isEmpty();
    }

    public boolean hasExcludedFeatures() {
        return !this.excludedFeatures.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isSubsetOf(ResolvedFeatureGroupConfig other) {
        if (this.fg.getId() == null || other.fg.getId() == null) {
            throw new IllegalArgumentException("Can't compare group anonymous groups");
        }
        if (this.inheritFeatures) {
            if (!other.inheritFeatures) return false;
            if (!this.excludedSpecs.containsAll(other.excludedSpecs)) {
                return false;
            }
            if (!this.excludedFeatures.containsAll(other.excludedFeatures)) {
                return false;
            }
            if (this.includedFeatures.isEmpty()) return true;
            if (other.includedFeatures.isEmpty()) {
                return false;
            }
            for (Map.Entry<ResolvedFeatureId, FeatureConfig> entry : this.includedFeatures.entrySet()) {
                FeatureConfig otherFc = other.includedFeatures.get(entry.getKey());
                if (otherFc == null) {
                    return false;
                }
                if (otherFc.equals(entry.getValue())) continue;
                return false;
            }
            return true;
        } else if (other.inheritFeatures) {
            if (!this.includedSpecs.isEmpty() && !other.excludedSpecs.isEmpty()) {
                for (ResolvedSpecId resolvedSpecId : this.includedSpecs) {
                    if (!this.excludedSpecs.contains(resolvedSpecId)) continue;
                    return false;
                }
            }
            if (this.includedFeatures.isEmpty() || other.excludedFeatures.isEmpty()) return true;
            for (Map.Entry entry : this.includedFeatures.entrySet()) {
                if (!other.excludedFeatures.contains(entry.getKey())) continue;
                return false;
            }
            return true;
        } else {
            if (!other.includedSpecs.containsAll(this.includedSpecs)) {
                return false;
            }
            if (!this.includedFeatures.isEmpty()) {
                if (other.includedFeatures.isEmpty()) {
                    return false;
                }
                for (Map.Entry<ResolvedFeatureId, FeatureConfig> entry : this.includedFeatures.entrySet()) {
                    FeatureConfig otherFc = other.includedFeatures.get(entry.getKey());
                    if (otherFc == null) {
                        return false;
                    }
                    if (otherFc.equals(entry.getValue())) continue;
                    return false;
                }
            }
            if (this.excludedFeatures.containsAll(other.excludedFeatures)) return true;
            return false;
        }
    }
}

