/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.jboss.galleon.util.HashUtils;
import org.jboss.galleon.util.PathFilter;
import org.jboss.galleon.util.PropertyUtils;

public class IoUtils {
    private static final Path TMP_DIR = Paths.get(PropertyUtils.getSystemProperty("java.io.tmpdir"), new String[0]);

    public static Path createTmpDir(String name) {
        Path dir = TMP_DIR.resolve(name);
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create " + dir.toAbsolutePath());
        }
        return dir;
    }

    public static Path createRandomTmpDir() {
        return IoUtils.createTmpDir(UUID.randomUUID().toString());
    }

    public static void recursiveDelete(Path root) {
        if (root == null || !Files.exists(root, new LinkOption[0])) {
            return;
        }
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    if (e == null) {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                    throw e;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void copy(final Path source, final Path target) throws IOException {
        if (Files.isDirectory(source, new LinkOption[0])) {
            Files.createDirectories(target, new FileAttribute[0]);
        } else {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
        }
        Files.walkFileTree(source, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                block2: {
                    Path targetDir = target.resolve(source.relativize(dir));
                    try {
                        Files.copy(dir, targetDir, new CopyOption[0]);
                    }
                    catch (FileAlreadyExistsException e) {
                        if (Files.isDirectory(targetDir, new LinkOption[0])) break block2;
                        throw e;
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, target.resolve(source.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static String readFile(Path file) throws IOException {
        StringWriter buf = new StringWriter();
        try (final BufferedWriter bw = new BufferedWriter(buf);){
            Files.readAllLines(file).forEach(new Consumer<String>(){

                @Override
                public void accept(String line) {
                    try {
                        bw.newLine();
                        bw.append(line);
                    }
                    catch (IOException ioex) {
                        throw new RuntimeException(ioex);
                    }
                }
            });
        }
        return buf.toString();
    }

    public static void writeFile(Path file, String content) throws IOException {
        Files.write(file, content.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
    }

    public static Map<Path, String> listContents(final Path root, final PathFilter filter) throws IOException {
        if (root == null || !Files.exists(root, new LinkOption[0])) {
            return Collections.emptyMap();
        }
        if (Files.isRegularFile(root, new LinkOption[0])) {
            return Collections.singletonMap(root.relativize(root), HashUtils.hashFile(root));
        }
        final HashMap<Path, String> contents = new HashMap<Path, String>();
        Files.walkFileTree(root, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (filter.accept(root.relativize(dir))) {
                    String[] files = dir.toFile().list();
                    if (files == null || files.length == 0) {
                        contents.put(root.relativize(dir), HashUtils.hash(root.relativize(dir).toString()));
                    }
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (filter.accept(root.relativize(file))) {
                    contents.put(root.relativize(file), HashUtils.hashFile(file));
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
        return contents;
    }
}

