/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Collection;
import org.jboss.galleon.spec.PackageDependencySpec;
import org.jboss.galleon.spec.PackageDepsSpec;
import org.jboss.galleon.spec.PackageSpec;
import org.jboss.galleon.xml.BaseXmlWriter;
import org.jboss.galleon.xml.PackageDepsSpecXmlParser;
import org.jboss.galleon.xml.PackageXmlParser10;
import org.jboss.galleon.xml.util.ElementNode;

public class PackageXmlWriter
extends BaseXmlWriter<PackageSpec> {
    private static final String TRUE = "true";
    private static final PackageXmlWriter INSTANCE = new PackageXmlWriter();

    public static PackageXmlWriter getInstance() {
        return INSTANCE;
    }

    private PackageXmlWriter() {
    }

    @Override
    protected ElementNode toElement(PackageSpec pkgSpec) {
        ElementNode pkg = PackageXmlWriter.addElement(null, PackageXmlParser10.Element.PACKAGE_SPEC);
        PackageXmlWriter.addAttribute(pkg, PackageXmlParser10.Attribute.NAME, pkgSpec.getName());
        if (pkgSpec.hasPackageDeps()) {
            PackageXmlWriter.writePackageDeps(pkgSpec, PackageXmlWriter.addElement(pkg, PackageXmlParser10.Element.DEPENDENCIES.getLocalName(), PackageXmlParser10.Element.DEPENDENCIES.getNamespace()));
        }
        return pkg;
    }

    static void writePackageDeps(PackageDepsSpec pkgDeps, ElementNode deps) {
        if (pkgDeps.hasLocalPackageDeps()) {
            for (PackageDependencySpec depSpec : pkgDeps.getLocalPackageDeps()) {
                PackageXmlWriter.writePackageDependency(deps, depSpec, deps.getNamespace());
            }
        }
        if (pkgDeps.hasExternalPackageDeps()) {
            for (String origin : pkgDeps.getPackageOrigins()) {
                PackageXmlWriter.writeOrigin(deps, origin, pkgDeps.getExternalPackageDeps(origin), deps.getNamespace());
            }
        }
    }

    private static void writeOrigin(ElementNode deps, String origin, Collection<PackageDependencySpec> depGroup, String ns) {
        ElementNode fpElement = PackageXmlWriter.addElement(deps, PackageDepsSpecXmlParser.Element.ORIGIN.getLocalName(), ns);
        PackageXmlWriter.addAttribute(fpElement, PackageXmlParser10.Attribute.NAME, origin);
        for (PackageDependencySpec depSpec : depGroup) {
            PackageXmlWriter.writePackageDependency(fpElement, depSpec, ns);
        }
    }

    private static void writePackageDependency(ElementNode deps, PackageDependencySpec depSpec, String ns) {
        ElementNode depElement = PackageXmlWriter.addElement(deps, PackageDepsSpecXmlParser.Element.PACKAGE.getLocalName(), ns);
        PackageXmlWriter.addAttribute(depElement, PackageXmlParser10.Attribute.NAME, depSpec.getName());
        if (depSpec.isOptional()) {
            PackageXmlWriter.addAttribute(depElement, PackageDepsSpecXmlParser.Attribute.OPTIONAL, TRUE);
        }
    }
}

