/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state.feature;

import java.io.IOException;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Argument;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.cmd.StateFullPathCompleter;
import org.jboss.galleon.cli.cmd.state.AbstractStateCommand;
import org.jboss.galleon.cli.cmd.state.StateEditCommandActivator;
import org.jboss.galleon.cli.model.ConfigInfo;
import org.jboss.galleon.cli.model.FeatureInfo;
import org.jboss.galleon.cli.model.Group;
import org.jboss.galleon.cli.model.state.State;
import org.jboss.galleon.cli.path.FeatureContainerPathConsumer;
import org.jboss.galleon.cli.path.PathParser;

@CommandDefinition(name="remove", description="Remove a feature", activator=StateEditCommandActivator.class)
public class StateRemoveFeatureCommand
extends AbstractStateCommand {
    @Argument(required=true, completer=FeatureCompleter.class)
    private String feature;

    @Override
    protected void runCommand(PmCommandInvocation invoc, State session) throws IOException, ProvisioningException, CommandExecutionException {
        try {
            String path = "/configs/final/" + (this.feature.endsWith("/") ? this.feature : this.feature + '/');
            FeatureContainerPathConsumer consumer = new FeatureContainerPathConsumer(session.getContainer(), false);
            PathParser.parse(path, consumer);
            ConfigInfo ci = consumer.getConfig();
            if (ci == null) {
                throw new ProvisioningException("Not a valid configuration " + this.feature);
            }
            Group grp = consumer.getCurrentNode(path);
            if (grp == null) {
                throw new ProvisioningException("Not a valid feature " + this.feature);
            }
            FeatureInfo fi = grp.getFeature();
            if (fi == null) {
                throw new ProvisioningException("Not a valid feature " + this.feature);
            }
            session.removeFeature(invoc.getPmSession(), ci, fi);
        }
        catch (Exception ex) {
            throw new CommandExecutionException(ex);
        }
    }

    public static class FeatureCompleter
    extends StateFullPathCompleter {
        @Override
        protected String getCurrentPath(PmCompleterInvocation session) {
            return "/configs/final/";
        }
    }
}

