/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.runtime.CapabilityProviders;
import org.jboss.galleon.runtime.CapabilityResolver;
import org.jboss.galleon.runtime.CircularRefInfo;
import org.jboss.galleon.runtime.ConfigFeatureBranch;
import org.jboss.galleon.runtime.ConfigModelStack;
import org.jboss.galleon.runtime.ProvisioningRuntimeBuilder;
import org.jboss.galleon.runtime.ResolvedFeature;
import org.jboss.galleon.runtime.ResolvedFeatureId;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.runtime.SpecFeatures;
import org.jboss.galleon.spec.CapabilitySpec;
import org.jboss.galleon.util.CollectionUtils;

class DefaultBranchedConfigArranger {
    private final ConfigModelStack configStack;
    private final Map<ResolvedSpecId, SpecFeatures> specFeatures;
    private final Map<ResolvedFeatureId, ResolvedFeature> features;
    private final boolean branchPerSpec;
    private boolean orderReferencedSpec;
    private final boolean branchIsBatch;
    private final boolean isolateCircularDeps;
    private CapabilityResolver capResolver = new CapabilityResolver();
    private Map<String, CapabilityProviders> capProviders = Collections.emptyMap();
    private List<ConfigFeatureBranch> featureBranches = Collections.emptyList();
    private Map<Object, ConfigFeatureBranch> branchesWithId = Collections.emptyMap();
    private ConfigFeatureBranch currentBranch;
    private boolean onParentChildrenBranch;
    private boolean circularDeps;

    private static boolean getBooleanProp(Map<String, String> props, String name, boolean defaultValue) {
        String value = props.get(name);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    DefaultBranchedConfigArranger(ConfigModelStack configStack) {
        this.configStack = configStack;
        this.specFeatures = configStack.specFeatures;
        this.features = configStack.features;
        this.orderReferencedSpec = this.branchPerSpec = DefaultBranchedConfigArranger.getBooleanProp(configStack.props, "config.branch-per-spec", true);
        this.branchIsBatch = DefaultBranchedConfigArranger.getBooleanProp(configStack.props, "config.branch-is-batch", false);
        this.isolateCircularDeps = DefaultBranchedConfigArranger.getBooleanProp(configStack.props, "config.isolate-circular-deps", false);
    }

    List<ResolvedFeature> orderFeatures() throws ProvisioningException {
        try {
            this.doOrder(this.configStack.rt);
        }
        catch (ProvisioningException e) {
            throw new ProvisioningException(Errors.failedToBuildConfigSpec(this.configStack.id.getModel(), this.configStack.id.getName()), e);
        }
        ArrayList<ResolvedFeature> orderedFeatures = new ArrayList<ResolvedFeature>(this.features.size());
        for (ConfigFeatureBranch branch : this.featureBranches) {
            this.orderBranches(branch, orderedFeatures);
        }
        return orderedFeatures;
    }

    private void orderBranches(ConfigFeatureBranch branch, List<ResolvedFeature> features) {
        if (branch.isOrdered()) {
            return;
        }
        if (branch.hasDeps()) {
            for (ConfigFeatureBranch dep : branch.getDeps()) {
                this.orderBranches(dep, features);
            }
        }
        features.addAll(branch.getFeatures());
        branch.ordered();
    }

    private void doOrder(ProvisioningRuntimeBuilder rt) throws ProvisioningException {
        for (SpecFeatures specFeatures : this.specFeatures.values()) {
            specFeatures.spec.resolveRefMappings(rt);
            if (!specFeatures.spec.xmlSpec.providesCapabilities()) continue;
            for (CapabilitySpec cap : specFeatures.spec.xmlSpec.getProvidedCapabilities()) {
                if (cap.isStatic()) {
                    this.getProviders(cap.toString(), true).add(specFeatures);
                    continue;
                }
                for (ResolvedFeature feature : specFeatures.getFeatures()) {
                    List<String> resolvedCaps = this.capResolver.resolve(cap, feature);
                    if (resolvedCaps.isEmpty()) continue;
                    for (String resolvedCap : resolvedCaps) {
                        this.getProviders(resolvedCap, true).add(feature);
                    }
                }
            }
        }
        this.currentBranch = new ConfigFeatureBranch(0, this.branchIsBatch);
        this.featureBranches = new ArrayList<ConfigFeatureBranch>();
        this.featureBranches.add(this.currentBranch);
        if (this.branchPerSpec) {
            for (SpecFeatures features : this.specFeatures.values()) {
                this.orderFeaturesInSpec(features, false);
            }
        } else {
            for (ResolvedFeature feature : this.features.values()) {
                this.orderFeature(feature);
            }
        }
    }

    private CapabilityProviders getProviders(String cap, boolean add) throws ProvisioningException {
        CapabilityProviders providers = this.capProviders.get(cap);
        if (providers != null) {
            return providers;
        }
        if (!add) {
            throw new ProvisioningException(Errors.noCapabilityProvider(cap));
        }
        providers = new CapabilityProviders();
        this.capProviders = CollectionUtils.put(this.capProviders, cap, providers);
        return providers;
    }

    private List<CircularRefInfo> orderFeaturesInSpec(SpecFeatures specFeatures, boolean force) throws ProvisioningException {
        if (!force) {
            if (!specFeatures.isFree()) {
                return null;
            }
            specFeatures.schedule();
        }
        List<CircularRefInfo> allCircularRefs = null;
        int i = 0;
        List<ResolvedFeature> features = specFeatures.getFeatures();
        while (i < features.size() && allCircularRefs == null) {
            if (this.onParentChildrenBranch) {
                this.onParentChildrenBranch = false;
                this.startNewBranch(null, this.branchIsBatch);
            }
            allCircularRefs = this.orderFeature(features.get(i++));
        }
        if (!force) {
            specFeatures.free();
        }
        return allCircularRefs;
    }

    /*
     * WARNING - void declaration
     */
    private List<CircularRefInfo> orderFeature(ResolvedFeature feature) throws ProvisioningException {
        List<ResolvedFeatureId> refIds;
        if (feature.isOrdered()) {
            return null;
        }
        if (!feature.isFree()) {
            return Collections.singletonList(new CircularRefInfo(feature));
        }
        feature.schedule();
        List<CircularRefInfo> circularRefs = Collections.emptyList();
        if (feature.spec.xmlSpec.requiresCapabilities()) {
            circularRefs = this.orderCapabilityProviders(feature, circularRefs);
        }
        if (!feature.deps.isEmpty()) {
            circularRefs = this.orderReferencedFeatures(feature, feature.deps.keySet(), false, circularRefs);
        }
        if (!(refIds = feature.resolveRefs()).isEmpty()) {
            circularRefs = this.orderReferencedFeatures(feature, refIds, true, circularRefs);
        }
        List<Object> initiatedCircularRefs = Collections.emptyList();
        if (!circularRefs.isEmpty()) {
            if (circularRefs.size() == 1) {
                CircularRefInfo next = circularRefs.get(0);
                if (next.loopedOn.id.equals(feature.id)) {
                    circularRefs = Collections.emptyList();
                    initiatedCircularRefs = Collections.singletonList(next);
                } else {
                    next.setNext(feature);
                    feature.free();
                }
            } else {
                Iterator<CircularRefInfo> i = circularRefs.iterator();
                while (i.hasNext()) {
                    CircularRefInfo next = i.next();
                    if (next.loopedOn.id.equals(feature.id)) {
                        i.remove();
                        initiatedCircularRefs = CollectionUtils.add(initiatedCircularRefs, next);
                        continue;
                    }
                    next.setNext(feature);
                    feature.free();
                }
            }
            if (!circularRefs.isEmpty()) {
                return circularRefs;
            }
        }
        if (!initiatedCircularRefs.isEmpty()) {
            boolean prevOrderRefSpec = this.orderReferencedSpec;
            this.orderReferencedSpec = false;
            initiatedCircularRefs.sort(CircularRefInfo.getFirstInConfigComparator());
            if (((CircularRefInfo)initiatedCircularRefs.get((int)0)).firstInConfig.includeNo < feature.includeNo) {
                feature.free();
                for (CircularRefInfo circularRefInfo : initiatedCircularRefs) {
                    if (this.orderFeature(circularRefInfo.firstInConfig) == null) continue;
                    throw new IllegalStateException();
                }
            } else {
                void var7_15;
                boolean originalCircularDeps = this.circularDeps;
                this.circularDeps = true;
                boolean bl = false;
                if (!originalCircularDeps) {
                    String isolateBranchId = null;
                    if (this.isolateCircularDeps) {
                        boolean bl2 = true;
                    } else if (this.currentBranch.defaultId) {
                        if (feature.spec.branchId != null) {
                            boolean bl3 = true;
                            isolateBranchId = feature.spec.branchId;
                        } else {
                            boolean bl4 = !this.currentBranch.isBatch();
                        }
                    } else if (!this.currentBranch.id.equals(feature.spec.branchId)) {
                        boolean bl5 = true;
                        isolateBranchId = feature.spec.branchId;
                    }
                    if (var7_15 != false) {
                        this.startNewBranch(isolateBranchId, true);
                    }
                }
                this.ordered(feature);
                initiatedCircularRefs.sort(CircularRefInfo.getNextOnPathComparator());
                for (CircularRefInfo circularRefInfo : initiatedCircularRefs) {
                    if (this.orderFeature(circularRefInfo.nextOnPath) == null) continue;
                    throw new IllegalStateException();
                }
                if (var7_15 != false) {
                    this.startNewBranch(null, this.branchIsBatch);
                }
                this.circularDeps = originalCircularDeps;
            }
            this.orderReferencedSpec = prevOrderRefSpec;
        } else {
            this.ordered(feature);
        }
        return null;
    }

    private void ordered(ResolvedFeature feature) throws ProvisioningException {
        ConfigFeatureBranch branch = this.currentBranch;
        if (this.circularDeps) {
            if (feature.spec.parentChildrenBranch) {
                branch.setFkBranch();
            }
        } else {
            branch = this.determineBranch(feature);
        }
        branch.add(feature);
        feature.ordered();
    }

    private ConfigFeatureBranch determineBranch(ResolvedFeature feature) throws ProvisioningException {
        if (!feature.branchDeps.isEmpty()) {
            Map.Entry<ConfigFeatureBranch, Boolean> next;
            Iterator<Map.Entry<ConfigFeatureBranch, Boolean>> branchDepIter = feature.branchDeps.entrySet().iterator();
            if (feature.branchDeps.size() == 1 && (next = branchDepIter.next()).getValue().booleanValue() && next.getKey().isFkBranch()) {
                return next.getKey();
            }
            while (branchDepIter.hasNext()) {
                ConfigFeatureBranch candidate;
                next = branchDepIter.next();
                if (!next.getValue().booleanValue() || !next.getKey().isFkBranch() || this.createsDepCircle(candidate = next.getKey(), feature)) continue;
                return candidate;
            }
        }
        ConfigFeatureBranch branch = null;
        if (feature.spec.isSpecBranch(this.branchPerSpec)) {
            SpecFeatures spec = feature.getSpecFeatures();
            ConfigFeatureBranch configFeatureBranch = spec.isBranchSet() ? spec.getBranch() : (branch = spec.spec.branchId == null ? null : this.branchesWithId.get(spec.spec.branchId));
            if (branch == null) {
                branch = this.startNewBranch(spec.spec.branchId, feature.spec.isBatchBranch(this.branchIsBatch));
                spec.setBranch(branch);
            } else if (this.createsDepCircle(branch, feature)) {
                branch = this.startNewBranch(null, this.branchIsBatch);
            } else if (!spec.isBranchSet()) {
                spec.setBranch(branch);
            }
        }
        if (feature.spec.parentChildrenBranch) {
            if (branch == null) {
                branch = this.startNewBranch(null, feature.spec.isBatchBranch(this.branchIsBatch));
            }
            branch.setFkBranch();
            this.onParentChildrenBranch = true;
            return branch;
        }
        if (branch != null) {
            return branch;
        }
        if (this.currentBranch.isSpecBranch() || this.currentBranch.isFkBranch()) {
            return this.startNewBranch(null, feature.spec.isBatchBranch(this.branchIsBatch));
        }
        if (this.createsDepCircle(this.currentBranch, feature)) {
            return this.startNewBranch(null, this.branchIsBatch);
        }
        return this.currentBranch;
    }

    private boolean createsDepCircle(ConfigFeatureBranch branch, ResolvedFeature feature) {
        if (branch.isEmpty() || feature.branchDeps.isEmpty()) {
            return false;
        }
        HashSet<ConfigFeatureBranch> visitedBranches = null;
        for (ConfigFeatureBranch newDep : feature.branchDeps.keySet()) {
            if (newDep.id.equals(branch.id) || branch.dependsOn(newDep)) continue;
            if (newDep.dependsOn(branch)) {
                return true;
            }
            if (visitedBranches == null) {
                visitedBranches = new HashSet<ConfigFeatureBranch>();
                visitedBranches.add(branch);
            }
            if (!this.createsDepCircle(newDep, visitedBranches)) continue;
            return true;
        }
        return false;
    }

    private boolean createsDepCircle(ConfigFeatureBranch next, Set<ConfigFeatureBranch> visitedBranches) {
        if (!next.hasDeps()) {
            return false;
        }
        visitedBranches.add(next);
        for (ConfigFeatureBranch newDep : next.getDeps()) {
            if (visitedBranches.contains(newDep)) {
                return true;
            }
            if (!this.createsDepCircle(newDep, visitedBranches)) continue;
            return true;
        }
        visitedBranches.remove(next);
        return false;
    }

    private ConfigFeatureBranch startNewBranch(Object id, boolean batch) throws ProvisioningException {
        if (this.currentBranch.isEmpty() && (this.currentBranch.defaultId && id == null || id != null && id.equals(this.currentBranch.id))) {
            if (this.currentBranch.isBatch() == batch) {
                return this.currentBranch;
            }
            this.currentBranch.setBatch(batch);
            return this.currentBranch;
        }
        if (id == null) {
            this.currentBranch = new ConfigFeatureBranch(this.featureBranches.size(), batch);
        } else if (this.branchesWithId.isEmpty()) {
            this.branchesWithId = new HashMap<Object, ConfigFeatureBranch>();
            this.currentBranch = new ConfigFeatureBranch(id, batch);
            this.branchesWithId.put(id, this.currentBranch);
        } else {
            this.currentBranch = this.branchesWithId.get(id);
            if (this.currentBranch == null) {
                this.currentBranch = new ConfigFeatureBranch(id, batch);
                this.branchesWithId.put(id, this.currentBranch);
            } else {
                return this.currentBranch;
            }
        }
        this.featureBranches.add(this.currentBranch);
        return this.currentBranch;
    }

    private List<CircularRefInfo> orderCapabilityProviders(ResolvedFeature feature, List<CircularRefInfo> circularRefs) throws ProvisioningException {
        for (CapabilitySpec capSpec : feature.spec.xmlSpec.getRequiredCapabilities()) {
            List<String> resolvedCaps = this.capResolver.resolve(capSpec, feature);
            if (resolvedCaps.isEmpty()) continue;
            for (String resolvedCap : resolvedCaps) {
                CapabilityProviders providers;
                try {
                    providers = this.getProviders(resolvedCap, false);
                }
                catch (ProvisioningException e) {
                    throw new ProvisioningException(Errors.noCapabilityProvider(feature, capSpec, resolvedCap));
                }
                circularRefs = CollectionUtils.addAll(circularRefs, this.orderProviders(providers));
                if (!providers.isProvided()) continue;
                feature.addBranchDep(providers.branches.iterator().next(), false);
            }
        }
        return circularRefs;
    }

    private List<CircularRefInfo> orderProviders(CapabilityProviders providers) throws ProvisioningException {
        List<CircularRefInfo> loop;
        if (providers.isProvided()) {
            return Collections.emptyList();
        }
        List<CircularRefInfo> firstLoop = null;
        if (!providers.specs.isEmpty()) {
            Iterator<Object> iterator = providers.specs.iterator();
            while (iterator.hasNext()) {
                SpecFeatures specFeatures;
                loop = this.orderFeaturesInSpec(specFeatures, !(specFeatures = iterator.next()).isFree());
                if (providers.isProvided()) {
                    return Collections.emptyList();
                }
                if (firstLoop != null) continue;
                firstLoop = loop;
            }
        }
        if (!providers.features.isEmpty()) {
            for (ResolvedFeature provider : providers.features) {
                loop = this.orderFeature(provider);
                if (providers.isProvided()) {
                    return Collections.emptyList();
                }
                if (firstLoop != null) continue;
                firstLoop = loop;
            }
        }
        return firstLoop == null ? Collections.emptyList() : firstLoop;
    }

    private List<CircularRefInfo> orderReferencedFeatures(ResolvedFeature feature, Collection<ResolvedFeatureId> refIds, boolean specRefs, List<CircularRefInfo> circularRefs) throws ProvisioningException {
        for (ResolvedFeatureId refId : refIds) {
            List<CircularRefInfo> newCircularRefs = this.orderReferencedFeature(feature, refId, specRefs);
            if (newCircularRefs == null) continue;
            circularRefs = CollectionUtils.addAll(circularRefs, newCircularRefs);
        }
        return circularRefs;
    }

    private List<CircularRefInfo> orderReferencedFeature(ResolvedFeature feature, ResolvedFeatureId refId, boolean specRef) throws ProvisioningException {
        ResolvedFeature dep;
        if (this.orderReferencedSpec && specRef && !feature.spec.id.equals(refId.specId)) {
            SpecFeatures targetSpecFeatures = this.specFeatures.get(refId.specId);
            if (targetSpecFeatures == null) {
                throw new ProvisioningDescriptionException(Errors.unresolvedFeatureDep(feature, refId));
            }
            List<CircularRefInfo> specLoops = this.orderFeaturesInSpec(targetSpecFeatures, false);
            if (specLoops != null) {
                List<CircularRefInfo> featureLoops = null;
                for (int i = 0; i < specLoops.size(); ++i) {
                    CircularRefInfo specLoop = specLoops.get(i);
                    if (!specLoop.nextOnPath.id.equals(refId)) continue;
                    if (featureLoops == null) {
                        featureLoops = Collections.singletonList(specLoop);
                        continue;
                    }
                    if (featureLoops.size() == 1) {
                        CircularRefInfo first = featureLoops.get(0);
                        featureLoops = new ArrayList<CircularRefInfo>(2);
                        featureLoops.add(first);
                    }
                    featureLoops.add(specLoop);
                }
                if (featureLoops != null) {
                    return featureLoops;
                }
            }
        }
        if ((dep = this.features.get(refId)) == null) {
            throw new ProvisioningDescriptionException(Errors.unresolvedFeatureDep(feature, refId));
        }
        List<CircularRefInfo> circularRefs = this.orderFeature(dep);
        if (dep.branch != null) {
            feature.addBranchDep(dep.branch, refId.isChildRef());
        }
        return circularRefs;
    }
}

