/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ArtifactRepositoryManager;
import org.jboss.galleon.DefaultMessageWriter;
import org.jboss.galleon.Errors;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigItem;
import org.jboss.galleon.config.ConfigItemContainer;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeatureConfig;
import org.jboss.galleon.config.FeatureGroup;
import org.jboss.galleon.config.FeatureGroupSupport;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.FeaturePackDepsConfig;
import org.jboss.galleon.config.PackageConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.runtime.ConfigModelStack;
import org.jboss.galleon.runtime.FeaturePackRuntime;
import org.jboss.galleon.runtime.FeaturePackRuntimeBuilder;
import org.jboss.galleon.runtime.FpStack;
import org.jboss.galleon.runtime.FpVersionsResolver;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.runtime.ResolvedConfig;
import org.jboss.galleon.runtime.ResolvedFeature;
import org.jboss.galleon.runtime.ResolvedFeatureGroupConfig;
import org.jboss.galleon.runtime.ResolvedFeatureId;
import org.jboss.galleon.runtime.ResolvedFeatureSpec;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.spec.FeatureDependencySpec;
import org.jboss.galleon.spec.FeatureId;
import org.jboss.galleon.spec.FeatureReferenceSpec;
import org.jboss.galleon.spec.PackageDependencySpec;
import org.jboss.galleon.spec.PackageDepsSpec;
import org.jboss.galleon.spec.SpecId;
import org.jboss.galleon.state.ProvisionedConfig;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.LayoutUtils;
import org.jboss.galleon.util.ZipUtils;
import org.jboss.galleon.xml.FeaturePackXmlParser;

public class ProvisioningRuntimeBuilder {
    final long startTime;
    String encoding;
    String operation;
    ArtifactRepositoryManager artifactResolver;
    ProvisioningConfig config;
    private Map<ArtifactCoords.Ga, ArtifactCoords.Gav> uninstallFps = Collections.emptyMap();
    Path installDir;
    final Path workDir;
    final Path layoutDir;
    Path pluginsDir = null;
    Map<String, String> options = Collections.emptyMap();
    private final MessageWriter messageWriter;
    private final Map<ArtifactCoords.Ga, FeaturePackRuntimeBuilder> fpRtBuilders = new HashMap<ArtifactCoords.Ga, FeaturePackRuntimeBuilder>();
    private List<FeaturePackRuntimeBuilder> fpRtBuildersOrdered = new ArrayList<FeaturePackRuntimeBuilder>();
    List<ConfigModelStack> anonymousConfigs = Collections.emptyList();
    Map<String, ConfigModelStack> nameOnlyConfigs = Collections.emptyMap();
    Map<String, ConfigModelStack> modelOnlyConfigs = Collections.emptyMap();
    Map<String, Map<String, ConfigModelStack>> namedModelConfigs = Collections.emptyMap();
    private List<ConfigModel> modelOnlyConfigSpecs = Collections.emptyList();
    private List<ArtifactCoords.Gav> modelOnlyGavs = Collections.emptyList();
    private FeaturePackRuntimeBuilder thisOrigin;
    private FeaturePackRuntimeBuilder currentOrigin;
    private ConfigModelStack configStack;
    private FpStack fpConfigStack;
    private ResolvedFeature parentFeature;

    public static ProvisioningRuntimeBuilder newInstance() {
        return ProvisioningRuntimeBuilder.newInstance(DefaultMessageWriter.getDefaultInstance());
    }

    public static ProvisioningRuntimeBuilder newInstance(MessageWriter messageWriter) {
        return new ProvisioningRuntimeBuilder(messageWriter);
    }

    private static void mkdirs(Path path) throws ProvisioningException {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.mkdirs(path));
        }
    }

    private ProvisioningRuntimeBuilder(MessageWriter messageWriter) {
        this.startTime = System.currentTimeMillis();
        this.workDir = IoUtils.createRandomTmpDir();
        this.layoutDir = this.workDir.resolve("layout");
        this.messageWriter = messageWriter;
    }

    public ProvisioningRuntimeBuilder setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public ProvisioningRuntimeBuilder setArtifactResolver(ArtifactRepositoryManager artifactResolver) {
        this.artifactResolver = artifactResolver;
        return this;
    }

    public ProvisioningRuntimeBuilder setConfig(ProvisioningConfig config) {
        this.config = config;
        return this;
    }

    public ProvisioningRuntimeBuilder setInstallDir(Path installDir) {
        this.installDir = installDir;
        return this;
    }

    public ProvisioningRuntimeBuilder uninstall(ArtifactCoords.Ga ga) {
        this.uninstallFps = CollectionUtils.put(this.uninstallFps, ga, ga.toGav());
        return this;
    }

    public ProvisioningRuntimeBuilder setOperation(String operation) {
        this.operation = operation;
        return this;
    }

    public ProvisioningRuntime build() throws ProvisioningException {
        try {
            return this.doBuild();
        }
        catch (Error | RuntimeException | ProvisioningException e) {
            IoUtils.recursiveDelete(this.workDir);
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    private ProvisioningRuntime doBuild() throws ProvisioningException {
        void var4_24;
        int n;
        if (!this.uninstallFps.isEmpty()) {
            Map<ArtifactCoords.Ga, ArtifactCoords.Gav> depsOfUninstalled = Collections.emptyMap();
            for (ArtifactCoords.Ga ga : this.uninstallFps.keySet()) {
                if (!this.config.hasFeaturePackDep(ga)) {
                    throw new ProvisioningException(Errors.unknownFeaturePack(ga.toGav()));
                }
                FeaturePackRuntimeBuilder featurePackRuntimeBuilder = this.getOrLoadFpBuilder(ga.toGav());
                depsOfUninstalled = FpVersionsResolver.resolveDeps(this, featurePackRuntimeBuilder.spec, depsOfUninstalled);
            }
            if (!depsOfUninstalled.isEmpty()) {
                Map<ArtifactCoords.Ga, ArtifactCoords.Gav> depsOfRemaining = Collections.emptyMap();
                for (FeaturePackConfig featurePackConfig : this.config.getFeaturePackDeps()) {
                    if (featurePackConfig.getGav().getVersion() == null) continue;
                    ArtifactCoords.Gav uninstallGav = this.uninstallFps.get(featurePackConfig.getGav().toGa());
                    if (uninstallGav != null) {
                        if (uninstallGav.equals(featurePackConfig.getGav())) continue;
                        throw new ProvisioningException(Errors.unknownFeaturePack(featurePackConfig.getGav()));
                    }
                    if (depsOfRemaining == null) continue;
                    depsOfRemaining = FpVersionsResolver.resolveDeps(this, this.getOrLoadFpBuilder((ArtifactCoords.Gav)featurePackConfig.getGav()).spec, depsOfRemaining);
                }
                if (!depsOfRemaining.isEmpty()) {
                    if (depsOfUninstalled.size() == 1) {
                        ArtifactCoords.Gav gav = (ArtifactCoords.Gav)depsOfRemaining.get(depsOfUninstalled.keySet().iterator().next());
                        if (gav != null) {
                            depsOfUninstalled = Collections.emptyMap();
                        }
                    } else {
                        ArtifactCoords.Ga ga;
                        Iterator iterator = depsOfRemaining.keySet().iterator();
                        while (iterator.hasNext() && (depsOfUninstalled.remove(ga = (ArtifactCoords.Ga)iterator.next()) == null || !depsOfUninstalled.isEmpty())) {
                        }
                    }
                }
            }
            ProvisioningConfig.Builder configBuilder = ProvisioningConfig.builder();
            for (FeaturePackConfig featurePackConfig : this.config.getFeaturePackDeps()) {
                ArtifactCoords.Ga fpGa = featurePackConfig.getGav().toGa();
                if (this.uninstallFps.containsKey(fpGa) || fpGa.toGav().getVersion() == null && depsOfUninstalled.containsKey(fpGa)) continue;
                String origin = this.config.originOf(fpGa);
                configBuilder.addFeaturePackDep(origin, featurePackConfig);
            }
            this.config = configBuilder.build();
            if (!this.config.hasFeaturePackDeps()) {
                this.emptyHomeDir();
                IoUtils.recursiveDelete(this.workDir);
                return null;
            }
        }
        FpVersionsResolver.resolveFpVersions(this);
        this.fpConfigStack = new FpStack(this.config);
        List<Object> fpConfigResolvers = Collections.emptyList();
        for (int i = this.config.getDefinedConfigs().size() - 1; i >= 0; --i) {
            ConfigModel configModel = this.config.getDefinedConfigs().get(i);
            if (this.fpConfigStack.isFilteredOut(configModel.getId(), true)) continue;
            this.configStack = this.getConfigStack(configModel.getId());
            this.configStack.pushConfig(configModel);
            fpConfigResolvers = CollectionUtils.add(fpConfigResolvers, this.configStack);
        }
        Collection<FeaturePackConfig> fpConfigs = this.config.getFeaturePackDeps();
        boolean bl = false;
        for (FeaturePackConfig fpConfig : fpConfigs) {
            n |= this.fpConfigStack.push(fpConfig, n != 0);
        }
        while (this.fpConfigStack.hasNext()) {
            this.processFpConfig(this.fpConfigStack.next());
        }
        if (n != 0) {
            this.fpConfigStack.popLevel();
        }
        int n2 = fpConfigResolvers.size() - 1;
        while (var4_24 >= 0) {
            ConfigModelStack configResolver = (ConfigModelStack)fpConfigResolvers.get((int)var4_24);
            ConfigModel config = configResolver.popConfig();
            if (config.getId().isModelOnly()) {
                this.recordModelOnlyConfig(null, config);
            } else {
                this.processConfig(configResolver, config);
            }
            --var4_24;
        }
        this.mergeModelOnlyConfigs();
        return new ProvisioningRuntime(this, this.messageWriter);
    }

    Map<ArtifactCoords.Ga, FeaturePackRuntime> getFpRuntimes(ProvisioningRuntime runtime) throws ProvisioningException {
        if (this.fpRtBuildersOrdered.isEmpty()) {
            return Collections.emptyMap();
        }
        if (this.fpRtBuildersOrdered.size() == 1) {
            FeaturePackRuntimeBuilder builder = this.fpRtBuildersOrdered.get(0);
            this.copyResources(builder);
            return Collections.singletonMap(builder.gav.toGa(), builder.build(runtime));
        }
        LinkedHashMap<ArtifactCoords.Ga, FeaturePackRuntime> fpRuntimes = new LinkedHashMap<ArtifactCoords.Ga, FeaturePackRuntime>(this.fpRtBuildersOrdered.size());
        for (FeaturePackRuntimeBuilder builder : this.fpRtBuildersOrdered) {
            this.copyResources(builder);
            fpRuntimes.put(builder.gav.toGa(), builder.build(runtime));
        }
        return Collections.unmodifiableMap(fpRuntimes);
    }

    private void mergeModelOnlyConfigs() throws ProvisioningException {
        Map<String, ConfigModelStack> targetConfigs;
        Map.Entry<String, ConfigModelStack> entry;
        if (!this.modelOnlyConfigSpecs.isEmpty()) {
            for (int i = 0; i < this.modelOnlyConfigSpecs.size(); ++i) {
                ConfigModel modelOnlySpec = this.modelOnlyConfigSpecs.get(i);
                if (!this.namedModelConfigs.containsKey(modelOnlySpec.getModel())) continue;
                this.fpConfigStack.activateConfigStack(i);
                ArtifactCoords.Gav fpGav = this.modelOnlyGavs.get(i);
                this.thisOrigin = fpGav == null ? null : this.getFpBuilder(this.modelOnlyGavs.get(i));
                this.setOrigin(this.thisOrigin);
                if (!this.processConfig(this.getConfigStack(modelOnlySpec.getId()), modelOnlySpec) || this.currentOrigin == null || this.currentOrigin.ordered) continue;
                this.orderFpRtBuilder(this.currentOrigin);
            }
        }
        if (this.modelOnlyConfigs.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<String, ConfigModelStack>> i = this.modelOnlyConfigs.entrySet().iterator();
        if (this.modelOnlyConfigs.size() == 1) {
            entry = i.next();
            targetConfigs = this.namedModelConfigs.get(entry.getKey());
            if (targetConfigs != null) {
                for (Map.Entry<String, ConfigModelStack> targetConfig : targetConfigs.entrySet()) {
                    targetConfig.getValue().merge(entry.getValue());
                }
            }
        } else {
            while (i.hasNext()) {
                entry = i.next();
                targetConfigs = this.namedModelConfigs.get(entry.getKey());
                if (targetConfigs == null) continue;
                for (Map.Entry<String, ConfigModelStack> targetConfig : targetConfigs.entrySet()) {
                    targetConfig.getValue().merge(entry.getValue());
                }
            }
        }
        this.modelOnlyConfigs = Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFpConfig(FeaturePackConfig fpConfig) throws ProvisioningException {
        this.thisOrigin = this.getFpBuilder(fpConfig.getGav());
        FeaturePackRuntimeBuilder parentFp = this.setOrigin(this.thisOrigin);
        try {
            ConfigModel config;
            ConfigModelStack configStack;
            List<Object> fpConfigStacks = Collections.emptyList();
            for (int i = fpConfig.getDefinedConfigs().size() - 1; i >= 0; --i) {
                ConfigModel config2 = fpConfig.getDefinedConfigs().get(i);
                if (this.fpConfigStack.isFilteredOut(config2.getId(), true)) continue;
                this.configStack = this.getConfigStack(config2.getId());
                this.configStack.pushConfig(config2);
                fpConfigStacks = CollectionUtils.add(fpConfigStacks, this.configStack);
            }
            List<Object> specConfigStacks = Collections.emptyList();
            for (int i = this.currentOrigin.spec.getDefinedConfigs().size() - 1; i >= 0; --i) {
                ConfigModel config3 = this.currentOrigin.spec.getDefinedConfigs().get(i);
                if (this.fpConfigStack.isFilteredOut(config3.getId(), false)) continue;
                this.configStack = this.getConfigStack(config3.getId());
                this.configStack.pushConfig(config3);
                specConfigStacks = CollectionUtils.add(specConfigStacks, this.configStack);
            }
            this.configStack = null;
            boolean extendedStackLevel = false;
            if (this.currentOrigin.spec.hasFeaturePackDeps()) {
                Collection<FeaturePackConfig> fpDeps = this.currentOrigin.spec.getFeaturePackDeps();
                for (FeaturePackConfig fpDep : fpDeps) {
                    extendedStackLevel |= this.fpConfigStack.push(fpDep, extendedStackLevel);
                }
                if (extendedStackLevel) {
                    while (this.fpConfigStack.hasNext()) {
                        this.processFpConfig(this.fpConfigStack.next());
                    }
                }
            }
            boolean contributed = false;
            for (int i = specConfigStacks.size() - 1; i >= 0; --i) {
                configStack = (ConfigModelStack)specConfigStacks.get(i);
                config = configStack.popConfig();
                if (config.getId().isModelOnly()) {
                    this.recordModelOnlyConfig(fpConfig.getGav(), config);
                    continue;
                }
                contributed |= this.processConfig(configStack, config);
            }
            if (fpConfig.isInheritPackages()) {
                for (String packageName : this.currentOrigin.spec.getDefaultPackageNames()) {
                    if (this.fpConfigStack.isPackageFilteredOut(this.currentOrigin.gav.toGa(), packageName, false)) continue;
                    this.resolvePackage(packageName);
                    contributed = true;
                }
            }
            if (fpConfig.hasIncludedPackages()) {
                for (PackageConfig pkgConfig : fpConfig.getIncludedPackages()) {
                    if (this.fpConfigStack.isPackageFilteredOut(this.currentOrigin.gav.toGa(), pkgConfig.getName(), true)) continue;
                    this.resolvePackage(pkgConfig.getName());
                    contributed = true;
                }
            }
            for (int i = fpConfigStacks.size() - 1; i >= 0; --i) {
                configStack = (ConfigModelStack)fpConfigStacks.get(i);
                config = configStack.popConfig();
                if (config.getId().isModelOnly()) {
                    this.recordModelOnlyConfig(fpConfig.getGav(), config);
                    continue;
                }
                contributed |= this.processConfig(configStack, config);
            }
            if (extendedStackLevel) {
                this.fpConfigStack.popLevel();
            }
            if (!this.currentOrigin.ordered && contributed) {
                this.orderFpRtBuilder(this.currentOrigin);
            }
        }
        finally {
            this.thisOrigin = parentFp;
            this.setOrigin(parentFp);
        }
    }

    private void recordModelOnlyConfig(ArtifactCoords.Gav gav, ConfigModel config) {
        this.modelOnlyConfigSpecs = CollectionUtils.add(this.modelOnlyConfigSpecs, config);
        this.modelOnlyGavs = CollectionUtils.add(this.modelOnlyGavs, gav);
        this.fpConfigStack.recordStack();
    }

    private boolean processConfig(ConfigModelStack configStack, ConfigModel config) throws ProvisioningException {
        this.configStack = configStack;
        configStack.overwriteProps(config.getProperties());
        configStack.overwriteConfigDeps(config.getConfigDeps());
        try {
            if (config.hasPackageDeps()) {
                this.processPackageDeps(config);
            }
            this.processConfigItemContainer(config);
            this.configStack = null;
            return true;
        }
        catch (ProvisioningException e) {
            throw new ProvisioningException(Errors.failedToResolveConfigSpec(config.getModel(), config.getName()), e);
        }
    }

    private ConfigModelStack getConfigStack(ConfigId id) throws ProvisioningException {
        if (id.getModel() == null) {
            if (id.getName() == null) {
                ConfigModelStack configStack = new ConfigModelStack(id, this);
                this.anonymousConfigs = CollectionUtils.add(this.anonymousConfigs, configStack);
                return configStack;
            }
            ConfigModelStack configStack = this.nameOnlyConfigs.get(id.getName());
            if (configStack == null) {
                configStack = new ConfigModelStack(id, this);
                this.nameOnlyConfigs = CollectionUtils.putLinked(this.nameOnlyConfigs, id.getName(), configStack);
            }
            return configStack;
        }
        if (id.getName() == null) {
            ConfigModelStack configStack = this.modelOnlyConfigs.get(id.getModel());
            if (configStack == null) {
                configStack = new ConfigModelStack(id, this);
                this.modelOnlyConfigs = CollectionUtils.putLinked(this.modelOnlyConfigs, id.getModel(), configStack);
            }
            return configStack;
        }
        Map<String, ConfigModelStack> namedConfigs = this.namedModelConfigs.get(id.getModel());
        if (namedConfigs == null) {
            ConfigModelStack configStack = new ConfigModelStack(id, this);
            namedConfigs = Collections.singletonMap(id.getName(), configStack);
            this.namedModelConfigs = CollectionUtils.putLinked(this.namedModelConfigs, id.getModel(), namedConfigs);
            return configStack;
        }
        ConfigModelStack configStack = namedConfigs.get(id.getName());
        if (configStack != null) {
            return configStack;
        }
        if (namedConfigs.size() == 1) {
            namedConfigs = new LinkedHashMap<String, ConfigModelStack>(namedConfigs);
            if (this.namedModelConfigs.size() == 1) {
                this.namedModelConfigs = new LinkedHashMap<String, Map<String, ConfigModelStack>>(this.namedModelConfigs);
            }
            this.namedModelConfigs.put(id.getModel(), namedConfigs);
        }
        configStack = new ConfigModelStack(id, this);
        namedConfigs.put(id.getName(), configStack);
        return configStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processFeatureGroup(FeatureGroupSupport includedFg) throws ProvisioningException {
        boolean pushed = this.configStack.pushGroup(includedFg);
        FeaturePackRuntimeBuilder originalOrigin = this.currentOrigin;
        boolean resolvedFeatures = false;
        try {
            FeatureGroup originalFg = this.getFeatureGroupSpec(includedFg.getName());
            if (originalFg.hasPackageDeps()) {
                this.processPackageDeps(originalFg);
            }
            if (!pushed) {
                boolean bl = false;
                return bl;
            }
            resolvedFeatures = this.processConfigItemContainer(originalFg);
        }
        finally {
            this.currentOrigin = originalOrigin;
        }
        resolvedFeatures |= this.configStack.popGroup();
        if (includedFg.hasItems()) {
            resolvedFeatures |= this.processConfigItemContainer(includedFg);
        }
        return resolvedFeatures;
    }

    private FeaturePackRuntimeBuilder setOrigin(String origin) throws ProvisioningException {
        return origin == null ? this.currentOrigin : this.setOrigin(this.getOrigin(origin));
    }

    private FeaturePackRuntimeBuilder setOrigin(FeaturePackRuntimeBuilder origin) {
        FeaturePackRuntimeBuilder prevOrigin = this.currentOrigin;
        this.currentOrigin = origin;
        return prevOrigin;
    }

    FeaturePackRuntimeBuilder getOrigin(String depName) throws ProvisioningException {
        if ("this".equals(depName)) {
            if (this.thisOrigin == null) {
                throw new ProvisioningException("Feature-pack reference 'this' cannot be used in the current context.");
            }
            return this.thisOrigin;
        }
        ArtifactCoords.Gav depGav = this.currentOrigin == null ? this.config.getFeaturePackDep(depName).getGav() : this.currentOrigin.spec.getFeaturePackDep(depName).getGav();
        return this.getFpBuilder(depGav);
    }

    private FeaturePackRuntimeBuilder setThisOrigin(FeaturePackRuntimeBuilder origin) {
        FeaturePackRuntimeBuilder prevOrigin = this.thisOrigin;
        this.thisOrigin = origin;
        return prevOrigin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResolvedFeatureGroupConfig resolveFeatureGroupConfig(FeatureGroupSupport fg) throws ProvisioningException {
        ArtifactCoords.Gav fgOrigin = null;
        if (!fg.isConfig()) {
            FeaturePackRuntimeBuilder originalOrigin = this.currentOrigin;
            this.getFeatureGroupSpec(fg.getName());
            fgOrigin = this.currentOrigin.gav;
            this.currentOrigin = originalOrigin;
        }
        ResolvedFeatureGroupConfig resolvedFgc = new ResolvedFeatureGroupConfig(this.configStack, fg, fgOrigin);
        resolvedFgc.inheritFeatures = fg.isInheritFeatures();
        if (fg.hasExcludedSpecs()) {
            resolvedFgc.excludedSpecs = this.resolveSpecIds(resolvedFgc.excludedSpecs, fg.getExcludedSpecs());
        }
        if (fg.hasIncludedSpecs()) {
            resolvedFgc.includedSpecs = this.resolveSpecIds(resolvedFgc.includedSpecs, fg.getIncludedSpecs());
        }
        if (fg.hasExcludedFeatures()) {
            resolvedFgc.excludedFeatures = this.resolveExcludedIds(resolvedFgc.excludedFeatures, fg.getExcludedFeatures());
        }
        if (fg.hasIncludedFeatures()) {
            resolvedFgc.includedFeatures = this.resolveIncludedIds(resolvedFgc.includedFeatures, fg.getIncludedFeatures());
        }
        if (fg.hasExternalFeatureGroups()) {
            FeaturePackRuntimeBuilder originalOrigin = this.currentOrigin;
            for (Map.Entry<String, FeatureGroup> entry : fg.getExternalFeatureGroups().entrySet()) {
                FeatureGroup extFg = entry.getValue();
                this.setOrigin(entry.getKey());
                try {
                    if (extFg.hasExcludedSpecs()) {
                        resolvedFgc.excludedSpecs = this.resolveSpecIds(resolvedFgc.excludedSpecs, extFg.getExcludedSpecs());
                    }
                    if (extFg.hasIncludedSpecs()) {
                        resolvedFgc.includedSpecs = this.resolveSpecIds(resolvedFgc.includedSpecs, extFg.getIncludedSpecs());
                    }
                    if (extFg.hasExcludedFeatures()) {
                        resolvedFgc.excludedFeatures = this.resolveExcludedIds(resolvedFgc.excludedFeatures, extFg.getExcludedFeatures());
                    }
                    if (!extFg.hasIncludedFeatures()) continue;
                    resolvedFgc.includedFeatures = this.resolveIncludedIds(resolvedFgc.includedFeatures, extFg.getIncludedFeatures());
                }
                finally {
                    this.setOrigin(originalOrigin);
                }
            }
        }
        return resolvedFgc;
    }

    boolean processIncludedFeatures(ResolvedFeatureGroupConfig pushedFgConfig) throws ProvisioningException {
        if (pushedFgConfig.includedFeatures.isEmpty()) {
            return false;
        }
        boolean resolvedFeatures = false;
        for (Map.Entry<ResolvedFeatureId, FeatureConfig> feature : pushedFgConfig.includedFeatures.entrySet()) {
            ResolvedFeatureId includedId;
            FeatureConfig includedFc = feature.getValue();
            if (includedFc == null || !includedFc.hasParams() || pushedFgConfig.configStack.isFilteredOut(includedId.specId, includedId = feature.getKey())) continue;
            if (!pushedFgConfig.configStack.includes(includedId)) {
                throw new ProvisioningException(Errors.featureNotInScope(includedId, pushedFgConfig.fg.getId() == null ? "'anonymous'" : pushedFgConfig.fg.getId().toString(), this.currentOrigin == null ? null : this.currentOrigin.gav));
            }
            resolvedFeatures |= this.resolveFeature(pushedFgConfig.configStack, includedFc);
        }
        return resolvedFeatures;
    }

    private Map<ResolvedFeatureId, FeatureConfig> resolveIncludedIds(Map<ResolvedFeatureId, FeatureConfig> includedFeatures, Map<FeatureId, FeatureConfig> features) throws ProvisioningException {
        for (Map.Entry<FeatureId, FeatureConfig> included : features.entrySet()) {
            FeatureConfig fc = new FeatureConfig(included.getValue());
            ResolvedFeatureSpec resolvedSpec = this.getFeatureSpec(fc.getSpecId().getName());
            if (this.parentFeature != null) {
                includedFeatures = CollectionUtils.put(includedFeatures, resolvedSpec.resolveIdFromForeignKey(this.parentFeature.id, fc.getParentRef(), fc.getParams()), fc);
                continue;
            }
            includedFeatures = CollectionUtils.put(includedFeatures, resolvedSpec.resolveFeatureId(fc.getParams()), fc);
        }
        return includedFeatures;
    }

    private Set<ResolvedFeatureId> resolveExcludedIds(Set<ResolvedFeatureId> resolvedIds, Map<FeatureId, String> features) throws ProvisioningException {
        for (Map.Entry<FeatureId, String> excluded : features.entrySet()) {
            FeatureId excludedId = excluded.getKey();
            ResolvedFeatureSpec resolvedSpec = this.getFeatureSpec(excludedId.getSpec().getName());
            if (this.parentFeature != null) {
                resolvedIds = CollectionUtils.add(resolvedIds, resolvedSpec.resolveIdFromForeignKey(this.parentFeature.id, excluded.getValue(), excludedId.getParams()));
                continue;
            }
            resolvedIds = CollectionUtils.add(resolvedIds, resolvedSpec.resolveFeatureId(excludedId.getParams()));
        }
        return resolvedIds;
    }

    private Set<ResolvedSpecId> resolveSpecIds(Set<ResolvedSpecId> resolvedIds, Set<SpecId> specs) throws ProvisioningException {
        for (SpecId specId : specs) {
            resolvedIds = CollectionUtils.add(resolvedIds, this.getFeatureSpec((String)specId.getName()).id);
        }
        return resolvedIds;
    }

    private boolean processConfigItemContainer(ConfigItemContainer ciContainer) throws ProvisioningException {
        if (!ciContainer.hasItems()) {
            return false;
        }
        boolean resolvedFeatures = false;
        FeaturePackRuntimeBuilder prevFpOrigin = ciContainer.isResetFeaturePackOrigin() ? this.setThisOrigin(this.currentOrigin) : null;
        for (ConfigItem item : ciContainer.getItems()) {
            FeaturePackRuntimeBuilder originalFp = this.setOrigin(item.getOrigin());
            try {
                if (item.isGroup()) {
                    FeatureGroup nestedFg = (FeatureGroup)item;
                    resolvedFeatures |= this.processFeatureGroup(nestedFg);
                    continue;
                }
                resolvedFeatures |= this.resolveFeature(this.configStack, (FeatureConfig)item);
            }
            catch (ProvisioningException e) {
                if (this.currentOrigin == null) {
                    throw e;
                }
                throw new ProvisioningException(item.isGroup() ? Errors.failedToProcess(this.currentOrigin.gav, ((FeatureGroup)item).getName()) : Errors.failedToProcess(this.currentOrigin.gav, (FeatureConfig)item), e);
            }
            finally {
                this.setOrigin(originalFp);
            }
        }
        if (prevFpOrigin != null) {
            this.setThisOrigin(prevFpOrigin);
        }
        return resolvedFeatures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean resolveFeature(ConfigModelStack configStack, FeatureConfig fc) throws ProvisioningException {
        FeaturePackRuntimeBuilder originalOrigin = this.currentOrigin;
        ResolvedFeatureSpec spec = this.getFeatureSpec(fc.getSpecId().getName(), true);
        ResolvedFeature originalParent = this.parentFeature;
        try {
            ResolvedFeatureId resolvedId;
            ResolvedFeatureId resolvedFeatureId = resolvedId = this.parentFeature == null ? spec.resolveFeatureId(fc.getParams()) : spec.resolveIdFromForeignKey(this.parentFeature.id, fc.getParentRef(), fc.getParams());
            if (configStack.isFilteredOut(spec.id, resolvedId)) {
                boolean bl = false;
                return bl;
            }
            this.parentFeature = this.resolveFeatureDepsAndRefs(configStack, spec, resolvedId, spec.resolveNonIdParams(this.parentFeature == null ? null : this.parentFeature.id, fc.getParentRef(), fc.getParams()), fc.getFeatureDeps());
            if (fc.hasUnsetParams()) {
                this.parentFeature.unsetAllParams(fc.getUnsetParams(), true);
            }
            if (fc.hasResetParams()) {
                this.parentFeature.resetAllParams(fc.getResetParams());
            }
            if (!this.currentOrigin.ordered) {
                this.orderFpRtBuilder(this.currentOrigin);
            }
        }
        finally {
            this.currentOrigin = originalOrigin;
        }
        this.processConfigItemContainer(fc);
        this.parentFeature = originalParent;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResolvedFeature resolveFeatureDepsAndRefs(ConfigModelStack configStack, ResolvedFeatureSpec spec, ResolvedFeatureId resolvedId, Map<String, Object> resolvedParams, Collection<FeatureDependencySpec> featureDeps) throws ProvisioningException {
        if (spec.xmlSpec.hasPackageDeps()) {
            this.processPackageDeps(spec.xmlSpec);
        }
        ResolvedFeature resolvedFeature = configStack.includeFeature(resolvedId, spec, resolvedParams, this.resolveFeatureDeps(configStack, featureDeps, spec));
        if (spec.xmlSpec.hasFeatureRefs()) {
            ResolvedFeature myParent = this.parentFeature;
            this.parentFeature = resolvedFeature;
            for (FeatureReferenceSpec refSpec : spec.xmlSpec.getFeatureRefs()) {
                if (!refSpec.isInclude()) continue;
                FeaturePackRuntimeBuilder originalFp = this.setOrigin(refSpec.getOrigin());
                try {
                    ResolvedFeatureSpec refResolvedSpec = this.getFeatureSpec(refSpec.getFeature().getName());
                    List<ResolvedFeatureId> refIds = spec.resolveRefId(this.parentFeature, refSpec, refResolvedSpec);
                    if (refIds.isEmpty()) continue;
                    for (ResolvedFeatureId refId : refIds) {
                        if (configStack.includes(refId) || configStack.isFilteredOut(refId.specId, refId)) continue;
                        this.resolveFeatureDepsAndRefs(configStack, refResolvedSpec, refId, Collections.emptyMap(), Collections.emptyList());
                    }
                }
                finally {
                    this.setOrigin(originalFp);
                }
            }
            this.parentFeature = myParent;
        }
        return resolvedFeature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ResolvedFeatureId, FeatureDependencySpec> resolveFeatureDeps(ConfigModelStack configStack, Collection<FeatureDependencySpec> featureDeps, ResolvedFeatureSpec spec) throws ProvisioningException {
        Map<ResolvedFeatureId, FeatureDependencySpec> resolvedDeps = spec.resolveFeatureDeps(this, featureDeps);
        if (!resolvedDeps.isEmpty()) {
            for (Map.Entry<ResolvedFeatureId, FeatureDependencySpec> dep : resolvedDeps.entrySet()) {
                ResolvedFeatureId depId;
                if (!dep.getValue().isInclude() || configStack.includes(depId = dep.getKey()) || configStack.isFilteredOut(depId.specId, depId)) continue;
                FeatureDependencySpec depSpec = dep.getValue();
                FeaturePackRuntimeBuilder originalFp = this.setOrigin(depSpec.getOrigin());
                try {
                    this.resolveFeatureDepsAndRefs(configStack, this.getFeatureSpec(depId.getSpecId().getName()), depId, Collections.emptyMap(), Collections.emptyList());
                }
                finally {
                    this.setOrigin(originalFp);
                }
            }
        }
        return resolvedDeps;
    }

    FeaturePackRuntimeBuilder getOrLoadFpBuilder(ArtifactCoords.Gav gav) throws ProvisioningException {
        FeaturePackRuntimeBuilder fp = this.getFpBuilder(gav, false);
        if (fp != null) {
            return fp;
        }
        return this.loadFpBuilder(gav);
    }

    FeaturePackRuntimeBuilder getFpBuilder(ArtifactCoords.Gav gav) throws ProvisioningDescriptionException {
        return this.getFpBuilder(gav, true);
    }

    FeaturePackRuntimeBuilder getFpBuilder(ArtifactCoords.Gav gav, boolean failIfNotFound) throws ProvisioningDescriptionException {
        FeaturePackRuntimeBuilder fp = this.fpRtBuilders.get(gav.toGa());
        if (fp == null && failIfNotFound) {
            throw new ProvisioningDescriptionException(Errors.unknownFeaturePack(gav));
        }
        return fp;
    }

    FeaturePackRuntimeBuilder loadFpBuilder(ArtifactCoords.Gav gav) throws ProvisioningException {
        FeaturePackRuntimeBuilder fp;
        Path fpDir = LayoutUtils.getFeaturePackDir(this.layoutDir, gav, false);
        ProvisioningRuntimeBuilder.mkdirs(fpDir);
        Path artifactPath = this.artifactResolver.resolve(gav.toArtifactCoords());
        try {
            ZipUtils.unzip(artifactPath, fpDir);
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to unzip " + artifactPath + " to " + this.layoutDir, e);
        }
        Path fpXml = fpDir.resolve("feature-pack.xml");
        if (!Files.exists(fpXml, new LinkOption[0])) {
            throw new ProvisioningDescriptionException(Errors.pathDoesNotExist(fpXml));
        }
        try (BufferedReader reader = Files.newBufferedReader(fpXml);){
            fp = FeaturePackRuntime.builder(FeaturePackXmlParser.getInstance().parse(reader), fpDir);
        }
        catch (IOException | XMLStreamException e) {
            throw new ProvisioningException(Errors.parseXml(fpXml), e);
        }
        this.fpRtBuilders.put(gav.toGa(), fp);
        return fp;
    }

    private void resolvePackage(String pkgName) throws ProvisioningException {
        if (this.resolvePackage(this.currentOrigin, pkgName, Collections.emptySet(), false)) {
            return;
        }
        throw new ProvisioningDescriptionException(Errors.packageNotFound(this.currentOrigin.gav, pkgName));
    }

    private boolean resolvePackage(FeaturePackRuntimeBuilder origin, String name, Set<ArtifactCoords.Ga> visitedGas, boolean switchOrigin) throws ProvisioningException {
        FeaturePackDepsConfig fpDeps;
        if (origin != null) {
            if (origin.resolvePackage(name, this)) {
                return true;
            }
            fpDeps = origin.spec;
            visitedGas = CollectionUtils.add(visitedGas, origin.gav.toGa());
        } else {
            fpDeps = this.config;
        }
        if (!fpDeps.hasFeaturePackDeps()) {
            return false;
        }
        for (FeaturePackConfig fpDep : fpDeps.getFeaturePackDeps()) {
            if (visitedGas.contains(fpDep.getGav().toGa()) || !this.resolvePackage(this.getOrLoadFpBuilder(fpDep.getGav()), name, visitedGas, switchOrigin)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processPackageDeps(PackageDepsSpec pkgDeps) throws ProvisioningException {
        if (pkgDeps.hasLocalPackageDeps()) {
            for (PackageDependencySpec dep : pkgDeps.getLocalPackageDeps()) {
                if (this.fpConfigStack.isPackageExcluded(this.currentOrigin.gav.toGa(), dep.getName())) {
                    if (dep.isOptional()) continue;
                    throw new ProvisioningDescriptionException(Errors.unsatisfiedPackageDependency(this.currentOrigin.gav, dep.getName()));
                }
                try {
                    this.resolvePackage(dep.getName());
                }
                catch (ProvisioningDescriptionException e) {
                    if (dep.isOptional()) continue;
                    throw e;
                }
            }
        }
        if (!pkgDeps.hasExternalPackageDeps()) {
            return;
        }
        for (String origin : pkgDeps.getPackageOrigins()) {
            FeaturePackRuntimeBuilder originalFp = this.setOrigin(origin);
            try {
                for (PackageDependencySpec pkgDep : pkgDeps.getExternalPackageDeps(origin)) {
                    if (this.fpConfigStack.isPackageExcluded(this.currentOrigin.gav.toGa(), pkgDep.getName())) {
                        if (pkgDep.isOptional()) continue;
                        throw new ProvisioningDescriptionException(Errors.unsatisfiedPackageDependency(this.currentOrigin.gav, pkgDep.getName()));
                    }
                    try {
                        this.resolvePackage(pkgDep.getName());
                    }
                    catch (ProvisioningDescriptionException e) {
                        if (pkgDep.isOptional()) continue;
                        throw e;
                    }
                }
            }
            finally {
                this.setOrigin(originalFp);
            }
        }
    }

    void orderFpRtBuilder(FeaturePackRuntimeBuilder fpRtBuilder) {
        this.fpRtBuildersOrdered.add(fpRtBuilder);
        fpRtBuilder.ordered = true;
    }

    List<ProvisionedConfig> getResolvedConfigs() throws ProvisioningException {
        int configsTotal = this.anonymousConfigs.size() + this.nameOnlyConfigs.size() + this.namedModelConfigs.size();
        if (configsTotal == 0) {
            return Collections.emptyList();
        }
        ArrayList<ProvisionedConfig> configList = new ArrayList<ProvisionedConfig>(configsTotal);
        if (!this.anonymousConfigs.isEmpty()) {
            for (ConfigModelStack configModelStack : this.anonymousConfigs) {
                this.orderConfig(configModelStack, configList, Collections.emptySet());
            }
        }
        if (!this.nameOnlyConfigs.isEmpty()) {
            for (ConfigModelStack configModelStack : this.nameOnlyConfigs.values()) {
                if (this.contains(configList, configModelStack.id)) continue;
                this.orderConfig(configModelStack, configList, Collections.emptySet());
            }
        }
        if (!this.namedModelConfigs.isEmpty()) {
            for (Map.Entry entry : this.namedModelConfigs.entrySet()) {
                for (ConfigModelStack config : ((Map)entry.getValue()).values()) {
                    if (this.contains(configList, config.id)) continue;
                    this.orderConfig(config, configList, Collections.emptySet());
                }
            }
        }
        return configList.size() > 0 ? Collections.unmodifiableList(configList) : configList;
    }

    private void orderConfig(ConfigModelStack config, List<ProvisionedConfig> configList, Set<ConfigId> scheduledIds) throws ProvisioningException {
        if (!config.hasConfigDeps()) {
            configList.add(ResolvedConfig.build(config));
            return;
        }
        if (!config.id.isAnonymous()) {
            scheduledIds = CollectionUtils.add(scheduledIds, config.id);
        }
        for (ConfigId depId : config.getConfigDeps().values()) {
            ConfigModelStack configStack;
            if (scheduledIds.contains(depId) || this.contains(configList, depId)) continue;
            if (depId.isModelOnly()) {
                Map<String, ConfigModelStack> configs = this.namedModelConfigs.get(depId.getModel());
                if (configs == null) {
                    throw new ProvisioningDescriptionException("Config " + config.id + " has unsatisfied dependency on config " + depId);
                }
                for (ConfigModelStack dep : configs.values()) {
                    if (this.contains(configList, dep.id)) continue;
                    this.orderConfig(dep, configList, scheduledIds);
                }
                continue;
            }
            if (depId.getModel() == null) {
                configStack = this.nameOnlyConfigs.get(depId.getName());
            } else {
                Map<String, ConfigModelStack> configs = this.namedModelConfigs.get(depId.getModel());
                if (configs == null) {
                    throw new ProvisioningDescriptionException("Config " + config.id + " has unsatisfied dependency on config " + depId);
                }
                configStack = configs.get(depId.getName());
            }
            if (configStack == null) {
                throw new ProvisioningDescriptionException("Config " + config.id + " has unsatisfied dependency on config " + depId);
            }
            if (this.contains(configList, configStack.id)) continue;
            this.orderConfig(configStack, configList, scheduledIds);
        }
        scheduledIds = CollectionUtils.remove(scheduledIds, config.id);
        configList.add(ResolvedConfig.build(config));
    }

    private boolean contains(List<ProvisionedConfig> configList, ConfigId depId) {
        int i = 0;
        while (i < configList.size()) {
            if (!((ResolvedConfig)configList.get((int)i++)).id.equals(depId)) continue;
            return true;
        }
        return false;
    }

    private void copyResources(FeaturePackRuntimeBuilder fpRtBuilder) throws ProvisioningException {
        Path fpPlugins;
        Path fpResources = fpRtBuilder.dir.resolve("resources");
        if (Files.exists(fpResources, new LinkOption[0])) {
            try {
                IoUtils.copy(fpResources, this.workDir.resolve("resources"));
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.copyFile(fpResources, this.workDir.resolve("resources")), e);
            }
        }
        if (Files.exists(fpPlugins = fpRtBuilder.dir.resolve("plugins"), new LinkOption[0])) {
            if (this.pluginsDir == null) {
                this.pluginsDir = this.workDir.resolve("plugins");
            }
            try {
                IoUtils.copy(fpPlugins, this.pluginsDir);
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.copyFile(fpPlugins, this.workDir.resolve("plugins")), e);
            }
        }
    }

    public ProvisioningRuntimeBuilder setOption(String name, String param) {
        this.options = CollectionUtils.put(this.options, name, param);
        return this;
    }

    public ProvisioningRuntimeBuilder addOptions(Map<String, String> options) {
        this.options = CollectionUtils.putAll(this.options, options);
        return this;
    }

    private void emptyHomeDir() throws ProvisioningException {
        if (!Files.exists(this.installDir, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.installDir);){
            for (Path p : stream) {
                IoUtils.recursiveDelete(p);
            }
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.readDirectory(this.installDir));
        }
    }

    private FeatureGroup getFeatureGroupSpec(String name) throws ProvisioningException {
        FeatureGroup fg = this.getFeatureGroupSpec(this.currentOrigin, name, Collections.emptySet());
        if (fg == null) {
            throw new ProvisioningDescriptionException("Failed to locate feature group '" + name + "' in " + (this.currentOrigin == null ? "the provisioning configuration" : this.currentOrigin.gav + " and its dependencies"));
        }
        return fg;
    }

    private FeatureGroup getFeatureGroupSpec(FeaturePackRuntimeBuilder origin, String name, Set<ArtifactCoords.Ga> visitedGas) throws ProvisioningException {
        FeaturePackDepsConfig fpDeps;
        if (origin != null) {
            FeatureGroup fg = origin.getFeatureGroupSpec(name);
            if (fg != null) {
                this.currentOrigin = origin;
                return fg;
            }
            fpDeps = origin.spec;
            visitedGas = CollectionUtils.add(visitedGas, origin.gav.toGa());
        } else {
            fpDeps = this.config;
        }
        if (!fpDeps.hasFeaturePackDeps()) {
            return null;
        }
        for (FeaturePackConfig fpDep : fpDeps.getFeaturePackDeps()) {
            FeatureGroup fg;
            if (visitedGas.contains(fpDep.getGav().toGa()) || (fg = this.getFeatureGroupSpec(this.getOrLoadFpBuilder(fpDep.getGav()), name, visitedGas)) == null) continue;
            return fg;
        }
        return null;
    }

    private ResolvedFeatureSpec getFeatureSpec(String name) throws ProvisioningException {
        return this.getFeatureSpec(name, false);
    }

    private ResolvedFeatureSpec getFeatureSpec(String name, boolean switchOrigin) throws ProvisioningException {
        return this.getFeatureSpec(this.currentOrigin, name, switchOrigin);
    }

    ResolvedFeatureSpec getFeatureSpec(FeaturePackRuntimeBuilder origin, String name) throws ProvisioningException {
        return this.getFeatureSpec(origin, name, false);
    }

    private ResolvedFeatureSpec getFeatureSpec(FeaturePackRuntimeBuilder origin, String name, boolean switchOrigin) throws ProvisioningException {
        ResolvedFeatureSpec resolvedSpec = this.getFeatureSpec(origin, name, Collections.emptySet(), switchOrigin);
        if (resolvedSpec == null) {
            if (origin == null) {
                throw new ProvisioningDescriptionException("Failed to locate feature spec '" + name + "' in the installed feature-packs.");
            }
            throw new ProvisioningDescriptionException("Failed to locate feature spec '" + name + "' in " + origin.gav + " and its dependencies.");
        }
        return resolvedSpec;
    }

    private ResolvedFeatureSpec getFeatureSpec(FeaturePackRuntimeBuilder origin, String name, Set<ArtifactCoords.Ga> visitedGas, boolean switchOrigin) throws ProvisioningException {
        FeaturePackDepsConfig fpDeps;
        if (origin != null) {
            ResolvedFeatureSpec fs = origin.getFeatureSpec(name);
            if (fs != null) {
                if (switchOrigin) {
                    this.currentOrigin = origin;
                }
                return fs;
            }
            fpDeps = origin.spec;
            visitedGas = CollectionUtils.add(visitedGas, origin.gav.toGa());
        } else {
            fpDeps = this.config;
        }
        if (!fpDeps.hasFeaturePackDeps()) {
            return null;
        }
        for (FeaturePackConfig fpDep : fpDeps.getFeaturePackDeps()) {
            ResolvedFeatureSpec fs;
            if (visitedGas.contains(fpDep.getGav().toGa()) || (fs = this.getFeatureSpec(this.getOrLoadFpBuilder(fpDep.getGav()), name, visitedGas, switchOrigin)) == null) continue;
            return fs;
        }
        return null;
    }
}

