/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.runtime.ResolvedFeatureId;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.state.ProvisionedConfig;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.ProvisionedConfigBuilder;
import org.jboss.galleon.xml.ProvisionedFeatureBuilder;
import org.jboss.galleon.xml.ProvisionedStateXmlParser10;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class ProvisionedConfigXmlUtil {
    private static final ProvisionedConfigXmlUtil INSTANCE = new ProvisionedConfigXmlUtil();

    public static ProvisionedConfigXmlUtil getInstance() {
        return INSTANCE;
    }

    public static ProvisionedConfig readConfig(XMLExtendedStreamReader reader) throws XMLStreamException {
        ProvisionedConfigBuilder config = ProvisionedConfigBuilder.builder();
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            ProvisionedStateXmlParser10.Attribute attribute = ProvisionedStateXmlParser10.Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    config.setName(reader.getAttributeValue(i));
                    continue block12;
                }
                case MODEL: {
                    config.setModel(reader.getAttributeValue(i));
                    continue block12;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        block13: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return config.build();
                }
                case 1: {
                    ProvisionedStateXmlParser10.Element element = ProvisionedStateXmlParser10.Element.of(reader.getName());
                    switch (element) {
                        case PROPS: {
                            ProvisionedConfigXmlUtil.readProps(reader, config);
                            continue block13;
                        }
                        case FEATURE_PACK: {
                            ProvisionedConfigXmlUtil.readFeaturePack(reader, config);
                            continue block13;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void readProps(XMLExtendedStreamReader reader, ProvisionedConfigBuilder config) throws XMLStreamException {
        ParsingUtils.parseNoAttributes(reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    ProvisionedStateXmlParser10.Element element = ProvisionedStateXmlParser10.Element.of(reader.getName());
                    switch (element) {
                        case PROP: {
                            ProvisionedConfigXmlUtil.readProp(reader, config);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void readProp(XMLExtendedStreamReader reader, ProvisionedConfigBuilder config) throws XMLStreamException {
        String name = null;
        String value = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ProvisionedStateXmlParser10.Attribute attribute = ProvisionedStateXmlParser10.Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block4;
                }
                case VALUE: {
                    value = reader.getAttributeValue(i);
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (name == null) {
            if (value == null) {
                HashSet<ProvisionedStateXmlParser10.Attribute> attrs = new HashSet<ProvisionedStateXmlParser10.Attribute>();
                attrs.add(ProvisionedStateXmlParser10.Attribute.NAME);
                attrs.add(ProvisionedStateXmlParser10.Attribute.VALUE);
                throw ParsingUtils.missingAttributes(reader.getLocation(), attrs);
            }
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(ProvisionedStateXmlParser10.Attribute.NAME));
        }
        if (value == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(ProvisionedStateXmlParser10.Attribute.VALUE));
        }
        config.setProperty(name, value);
        ParsingUtils.parseNoContent(reader);
    }

    private static void readFeaturePack(XMLExtendedStreamReader reader, ProvisionedConfigBuilder config) throws XMLStreamException {
        String group = null;
        String artifact = null;
        String version = null;
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            ProvisionedStateXmlParser10.Attribute attribute = ProvisionedStateXmlParser10.Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case GROUP_ID: {
                    group = reader.getAttributeValue(i);
                    continue block12;
                }
                case ARTIFACT_ID: {
                    artifact = reader.getAttributeValue(i);
                    continue block12;
                }
                case VERSION: {
                    version = reader.getAttributeValue(i);
                    continue block12;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        HashSet<ProvisionedStateXmlParser10.Attribute> missingAttrs = null;
        if (group == null) {
            missingAttrs = new HashSet<ProvisionedStateXmlParser10.Attribute>();
            missingAttrs.add(ProvisionedStateXmlParser10.Attribute.GROUP_ID);
        }
        if (artifact == null) {
            if (missingAttrs == null) {
                missingAttrs = new HashSet();
            }
            missingAttrs.add(ProvisionedStateXmlParser10.Attribute.ARTIFACT_ID);
        }
        if (version == null) {
            if (missingAttrs == null) {
                missingAttrs = new HashSet();
            }
            missingAttrs.add(ProvisionedStateXmlParser10.Attribute.VERSION);
        }
        if (missingAttrs != null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), missingAttrs);
        }
        ArtifactCoords.Gav gav = ArtifactCoords.newGav(group, artifact, version);
        block13: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    ProvisionedStateXmlParser10.Element element = ProvisionedStateXmlParser10.Element.of(reader.getName());
                    switch (element) {
                        case SPEC: {
                            ProvisionedConfigXmlUtil.readSpec(reader, gav, config);
                            continue block13;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void readSpec(XMLExtendedStreamReader reader, ArtifactCoords.Gav fpGav, ProvisionedConfigBuilder config) throws XMLStreamException {
        String name = null;
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            ProvisionedStateXmlParser10.Attribute attribute = ProvisionedStateXmlParser10.Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block10;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (name == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(ProvisionedStateXmlParser10.Attribute.NAME));
        }
        ResolvedSpecId specId = new ResolvedSpecId(fpGav, name);
        block11: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    ProvisionedStateXmlParser10.Element element = ProvisionedStateXmlParser10.Element.of(reader.getName());
                    switch (element) {
                        case FEATURE: {
                            ProvisionedConfigXmlUtil.readFeature(reader, specId, config);
                            continue block11;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void readFeature(XMLExtendedStreamReader reader, ResolvedSpecId specId, ProvisionedConfigBuilder config) throws XMLStreamException {
        ProvisionedFeatureBuilder featureBuilder;
        ResolvedFeatureId id = null;
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            ProvisionedStateXmlParser10.Attribute attribute = ProvisionedStateXmlParser10.Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case ID: {
                    try {
                        id = ResolvedFeatureId.fromString(reader.getAttributeValue(i));
                        continue block14;
                    }
                    catch (ProvisioningDescriptionException e) {
                        throw new XMLStreamException(Errors.parseXml(), e);
                    }
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        ProvisionedFeatureBuilder provisionedFeatureBuilder = featureBuilder = id == null ? ProvisionedFeatureBuilder.builder(specId) : ProvisionedFeatureBuilder.builder(id);
        block15: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    try {
                        config.addFeature(featureBuilder.build());
                    }
                    catch (ProvisioningDescriptionException e) {
                        throw new XMLStreamException("Failed to instantiate provisioned feature", reader.getLocation(), e);
                    }
                    return;
                }
                case 1: {
                    ProvisionedStateXmlParser10.Element element = ProvisionedStateXmlParser10.Element.of(reader.getName());
                    switch (element) {
                        case PARAM: {
                            ProvisionedConfigXmlUtil.readParam(reader, featureBuilder);
                            continue block15;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void readParam(XMLExtendedStreamReader reader, ProvisionedFeatureBuilder featureBuilder) throws XMLStreamException {
        String name = null;
        String value = null;
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ProvisionedStateXmlParser10.Attribute attribute = ProvisionedStateXmlParser10.Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block4;
                }
                case VALUE: {
                    value = reader.getAttributeValue(i);
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (name == null) {
            Set<ProvisionedStateXmlParser10.Attribute> missingAttrs = null;
            if (value == null) {
                missingAttrs = new HashSet<ProvisionedStateXmlParser10.Attribute>(2);
                missingAttrs.add(ProvisionedStateXmlParser10.Attribute.NAME);
                missingAttrs.add(ProvisionedStateXmlParser10.Attribute.VALUE);
            } else {
                missingAttrs = Collections.singleton(ProvisionedStateXmlParser10.Attribute.NAME);
            }
            throw ParsingUtils.missingAttributes(reader.getLocation(), missingAttrs);
        }
        if (value == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(ProvisionedStateXmlParser10.Attribute.VALUE));
        }
        featureBuilder.setConfigParam(name, value);
        ParsingUtils.parseNoContent(reader);
    }
}

