/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.model;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.model.Identity;
import org.jboss.galleon.plugin.CliPlugin;
import org.jboss.galleon.runtime.PackageRuntime;
import org.jboss.galleon.spec.PackageSpec;

public class PackageInfo {
    private final Path contentDir;
    private final PackageSpec spec;
    private final List<String> content = new ArrayList<String>();
    private final Identity identity;
    private Set<Identity> providers = new HashSet<Identity>();
    private final ArtifactCoords.Gav gav;
    private final CliPlugin.CustomPackageContent customContent;

    PackageInfo(PackageRuntime pkg, Identity identity, CliPlugin plugin) throws IOException, ProvisioningException {
        this.gav = pkg.getFeaturePackRuntime().getGav();
        this.identity = identity;
        this.contentDir = pkg.getContentDir();
        this.spec = pkg.getSpec();
        CliPlugin.CustomPackageContent customPackageContent = this.customContent = plugin == null ? null : plugin.handlePackageContent(pkg);
        if (this.customContent == null) {
            this.fillContent();
        }
    }

    public String getCustomContent() {
        if (this.customContent == null) {
            return null;
        }
        return this.customContent.getInfo();
    }

    public ArtifactCoords.Gav getGav() {
        return this.gav;
    }

    private void fillContent() throws IOException {
        Files.walkFileTree(this.contentDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
                String r = PackageInfo.this.contentDir.toString();
                String child = file.toString().substring(0, file.toString().length());
                String name = child.substring(r.length() + 1);
                PackageInfo.this.content.add(name);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        });
        Collections.sort(this.content);
    }

    public List<String> getContent() {
        return this.content;
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public PackageSpec getSpec() {
        return this.spec;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PackageInfo)) {
            return false;
        }
        PackageInfo pi = (PackageInfo)obj;
        return pi.getIdentity().equals(this.getIdentity());
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.identity);
        return hash;
    }

    void addProvider(Identity provider) {
        this.providers.add(provider);
    }

    public Set<Identity> getProviders() {
        return this.providers;
    }
}

