/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import org.aesh.command.activator.OptionActivator;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.impl.internal.ParsedOption;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ArtifactException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.GavCompleter;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.ProvisioningCommand;
import org.jboss.galleon.cli.StreamCompleter;

public abstract class ProvisioningFeaturePackCommand
extends ProvisioningCommand {
    public static final String FP_OPTION_NAME = "fp";
    @Argument(completer=StreamCompleter.class, activator=StreamNameActivator.class)
    protected String streamName;
    @Option(name="fp", completer=GavCompleter.class, activator=FPActivator.class)
    protected String fpCoords;

    protected ArtifactCoords.Gav getGav(PmSession session) throws CommandExecutionException {
        String coords;
        if (this.fpCoords == null && this.streamName == null) {
            throw new CommandExecutionException("Stream name or feature-pack coordinates must be set");
        }
        if (this.fpCoords != null && this.streamName != null) {
            throw new CommandExecutionException("Only one of stream name or feature-pack coordinates must be set");
        }
        if (this.streamName != null) {
            try {
                coords = session.getUniverses().resolveStream(this.streamName).toString();
            }
            catch (ArtifactException ex) {
                throw new CommandExecutionException("Stream resolution failed", ex);
            }
        } else {
            coords = this.fpCoords;
        }
        return ArtifactCoords.newGav(coords);
    }

    protected String getName() {
        if (this.streamName == null) {
            return this.fpCoords;
        }
        return this.streamName;
    }

    public static class StreamNameActivator
    implements OptionActivator {
        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            ParsedOption opt = parsedCommand.findLongOptionNoActivatorCheck(ProvisioningFeaturePackCommand.FP_OPTION_NAME);
            return opt == null || opt.value() == null;
        }
    }

    public static class FPActivator
    implements OptionActivator {
        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            String argumentValue = parsedCommand.argument().value();
            return argumentValue == null;
        }
    }
}

