/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.aesh.command.CommandDefinition;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.aesh.io.Resource;
import org.aesh.readline.AeshContext;
import org.jboss.galleon.DefaultMessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.MavenArtifactRepositoryManager;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmOptionActivator;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.cmd.state.StateNoExplorationActivator;
import org.jboss.galleon.cli.model.state.State;

@CommandDefinition(name="provision", description="Install from a provided file or the current state", activator=StateNoExplorationActivator.class)
public class StateProvisionCommand
extends PmSessionCommand {
    @Option(completer=FileOptionCompleter.class, required=false, description="Directory to install the current configuration.")
    protected String dir;
    @Option(required=false, hasValue=false)
    private Boolean verbose;
    @Argument(description="File describing the desired provisioned state.", activator=FileActivator.class, required=false)
    private Resource file;

    @Override
    protected void runCommand(PmCommandInvocation invoc) throws CommandExecutionException {
        if (invoc.getPmSession().getState() != null) {
            State session = invoc.getPmSession().getState();
            try {
                this.getManager(invoc).provision(session.getConfig());
            }
            catch (ProvisioningException ex) {
                throw new CommandExecutionException(ex);
            }
        }
        if (this.file == null) {
            throw new CommandExecutionException("Option --file is missing");
        }
        Resource specResource = this.file.resolve(invoc.getAeshContext().getCurrentWorkingDirectory()).get(0);
        Path provisioningFile = Paths.get(specResource.getAbsolutePath(), new String[0]);
        if (!Files.exists(provisioningFile, new LinkOption[0])) {
            throw new CommandExecutionException("Failed to locate provisioning file " + provisioningFile.toAbsolutePath());
        }
        try {
            this.getManager(invoc).provision(provisioningFile);
        }
        catch (ProvisioningException e) {
            throw new CommandExecutionException("Provisioning failed", e);
        }
        Path home = this.getInstallationHome(invoc.getAeshContext());
        if (Files.exists(home, new LinkOption[0]) && invoc.getPmSession().getState() != null) {
            try {
                invoc.println("Installation done in " + home.toFile().getCanonicalPath());
            }
            catch (IOException ex) {
                throw new CommandExecutionException(ex);
            }
        } else if (invoc.getPmSession().getState() != null) {
            invoc.println("Nothing to install");
        }
    }

    protected ProvisioningManager getManager(PmCommandInvocation session) {
        return ProvisioningManager.builder().setArtifactResolver(MavenArtifactRepositoryManager.getInstance()).setInstallationHome(this.getInstallationHome(session.getAeshContext())).setMessageWriter(new DefaultMessageWriter(session.getOut(), session.getErr(), this.verbose)).build();
    }

    protected Path getInstallationHome(AeshContext context) {
        Path workDir = PmSession.getWorkDir(context);
        return this.dir == null ? PmSession.getWorkDir(context) : workDir.resolve(this.dir);
    }

    public static class FileActivator
    extends PmOptionActivator {
        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            return this.getPmSession().getState() == null;
        }
    }
}

