/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.model.ConfigInfo;
import org.jboss.galleon.cli.model.FeatureSpecInfo;
import org.jboss.galleon.config.FeatureConfig;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.spec.FeatureId;
import org.jboss.galleon.state.ProvisionedFeature;

public class FeatureInfo {
    private final ProvisionedFeature feature;
    private final List<String> path;
    private final ArtifactCoords.Gav currentFP;
    private FeatureSpecInfo specInfo;
    private final FeatureId featureId;
    private final FeatureConfig featureConfig;
    private final String fullPath;
    private final ConfigInfo configInfo;

    public FeatureInfo(ConfigInfo configInfo, ProvisionedFeature feature, List<String> path, ArtifactCoords.Gav currentFP) throws ProvisioningDescriptionException {
        this.feature = feature;
        this.path = path;
        this.currentFP = currentFP;
        this.configInfo = configInfo;
        FeatureId.Builder builder = FeatureId.builder(feature.getId().getSpecId().getName());
        for (Map.Entry<String, Object> param : feature.getId().getParams().entrySet()) {
            builder.setParam(param.getKey(), param.getValue().toString());
        }
        this.featureId = builder.build();
        this.featureConfig = FeatureConfig.newConfig(this.featureId);
        StringBuilder b = new StringBuilder();
        b.append("/configs/final/").append(configInfo.getModel()).append('/').append(configInfo.getName()).append('/');
        for (int i = 0; i < path.size(); ++i) {
            b.append(path.get(i));
            if (i >= path.size() - 1) continue;
            b.append('/');
        }
        this.fullPath = b.toString();
    }

    public String getPath() {
        return this.fullPath;
    }

    void attachSpecInfo(FeatureSpecInfo specInfo) {
        this.specInfo = specInfo;
        for (Map.Entry<String, Object> p : this.feature.getResolvedParams().entrySet()) {
            if (specInfo.getSpec().getParams().get(p.getKey()).isFeatureId()) continue;
            this.featureConfig.setParam(p.getKey(), p.getValue().toString());
        }
    }

    public FeatureId getFeatureId() {
        return this.featureId;
    }

    public FeatureConfig getFeatureConfig() {
        return this.featureConfig;
    }

    public String getDescription() {
        return "no description available";
    }

    public ResolvedSpecId getSpecId() {
        return this.feature.getSpecId();
    }

    public String getType() {
        return this.specInfo.getType();
    }

    public Map<String, Object> getResolvedParams() throws ProvisioningException {
        try {
            return this.feature.getResolvedParams();
        }
        catch (Exception ex) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String param : this.feature.getParamNames()) {
                map.put(param, this.feature.getConfigParam(param));
            }
            return map;
        }
    }

    public List<String> getUndefinedParams() throws ProvisioningException {
        ArrayList<String> res = new ArrayList<String>();
        for (String p : this.specInfo.getAllParameters()) {
            if (this.feature.getConfigParam(p) != null) continue;
            res.add(p);
        }
        Collections.sort(res);
        return res;
    }
}

