/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.model;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ArtifactException;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.model.Caches;
import org.jboss.galleon.cli.model.FeatureGroupsBuilder;
import org.jboss.galleon.cli.model.FeatureSpecInfo;
import org.jboss.galleon.cli.model.Group;
import org.jboss.galleon.cli.model.Identity;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.spec.FeatureSpec;
import org.jboss.galleon.spec.PackageDependencySpec;
import org.jboss.galleon.xml.FeatureSpecXmlParser;

public class FeatureSpecsBuilder {
    private final Map<ResolvedSpecId, FeatureSpecInfo> allspecs = new HashMap<ResolvedSpecId, FeatureSpecInfo>();

    public Map<ResolvedSpecId, FeatureSpecInfo> getAllSpecs() {
        return this.allspecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group buildTree(PmSession session, final ArtifactCoords.Gav fpgav, final ArtifactCoords.Gav gav, final Map<Identity, Group> allPackages, boolean useCache, final Set<ResolvedSpecId> wantedSpecs) throws IOException, ArtifactException {
        final FeatureGroupsBuilder grpBuilder = new FeatureGroupsBuilder();
        Set<Object> specs = null;
        Map<ArtifactCoords.Gav, Set<FeatureSpecInfo>> allSpecs = null;
        if (useCache && (allSpecs = Caches.getSpecs()) != null) {
            specs = allSpecs.get(fpgav);
        }
        if (specs == null) {
            final HashSet fSpecs = specs = new HashSet();
            try (final FileSystem fs = FileSystems.newFileSystem(session.getArtifactResolver().resolve(fpgav.toArtifactCoords()), null);){
                final Path path = fs.getPath("features/", new String[0]);
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        if (!dir.equals(path)) {
                            String r = path.toString();
                            String child = dir.toString().substring(0, dir.toString().length() - 1);
                            String name = child.substring(r.length() + 1);
                            ResolvedSpecId resolved = new ResolvedSpecId(fpgav, name);
                            if (wantedSpecs == null || wantedSpecs.contains(resolved)) {
                                FeatureSpecInfo specInfo = (FeatureSpecInfo)FeatureSpecsBuilder.this.allspecs.get(resolved);
                                if (specInfo == null) {
                                    try {
                                        HashSet<Identity> missingPackages = new HashSet<Identity>();
                                        FeatureSpec spec = FeatureSpecsBuilder.getFeatureSpec(fs, name);
                                        specInfo = new FeatureSpecInfo(resolved, gav, spec);
                                        Identity specId = Identity.fromGav(resolved.getGav(), resolved.getName());
                                        boolean featureEnabled = true;
                                        for (PackageDependencySpec p : spec.getLocalPackageDeps()) {
                                            Identity id = Identity.fromGav(resolved.getGav(), p.getName());
                                            Group grp = (Group)allPackages.get(id);
                                            if (grp != null) {
                                                specInfo.addPackage(grp.getPackage());
                                                FeatureSpecsBuilder.attachProvider(specId, grp, new HashSet());
                                                continue;
                                            }
                                            featureEnabled = false;
                                            missingPackages.add(id);
                                        }
                                        for (String o : spec.getPackageOrigins()) {
                                            for (PackageDependencySpec p : spec.getExternalPackageDeps(o)) {
                                                Identity id = Identity.fromString(o, p.getName());
                                                Group grp = (Group)allPackages.get(id);
                                                if (grp != null) {
                                                    specInfo.addPackage(grp.getPackage());
                                                    FeatureSpecsBuilder.attachProvider(specId, grp, new HashSet());
                                                    continue;
                                                }
                                                featureEnabled = false;
                                                missingPackages.add(id);
                                            }
                                        }
                                        specInfo.setEnabled(featureEnabled);
                                        specInfo.setMissingPackages(missingPackages);
                                        FeatureSpecsBuilder.this.allspecs.put(resolved, specInfo);
                                        fSpecs.add(specInfo);
                                    }
                                    catch (XMLStreamException ex) {
                                        throw new RuntimeException(ex);
                                    }
                                }
                                String fullSpecName = resolved.getName();
                                ArrayList<String> path2 = new ArrayList<String>();
                                Group parent = grpBuilder.buildFeatureSpecGroups(fullSpecName, specInfo, path2);
                                parent.setFeatureSpec(specInfo);
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) {
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            if (useCache) {
                if (allSpecs == null) {
                    allSpecs = new HashMap<ArtifactCoords.Gav, Set<FeatureSpecInfo>>();
                    Caches.addSpecs(allSpecs);
                }
                allSpecs.put(fpgav, specs);
            }
        } else {
            for (FeatureSpecInfo spec : specs) {
                this.allspecs.put(spec.getSpecId(), spec);
                String fullSpecName = spec.getSpecId().getName();
                ArrayList<String> path = new ArrayList<String>();
                Group parent = grpBuilder.buildFeatureSpecGroups(fullSpecName, spec, path);
                parent.setFeatureSpec(spec);
            }
        }
        return grpBuilder.getRoot();
    }

    private static void attachProvider(Identity provider, Group grp, HashSet<Group> seen) {
        grp.getPackage().addProvider(provider);
        if (seen.contains(grp)) {
            return;
        }
        seen.add(grp);
        for (Group dep : grp.getGroups()) {
            FeatureSpecsBuilder.attachProvider(provider, dep, seen);
        }
    }

    private static FeatureSpec getFeatureSpec(FileSystem fs, String name) throws IOException, XMLStreamException {
        Path path = fs.getPath("features/" + name + "/spec.xml", new String[0]);
        byte[] content = Files.readAllBytes(path);
        ByteArrayInputStream stream = new ByteArrayInputStream(content);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            FeatureSpec featureSpec = FeatureSpecXmlParser.getInstance().parse(reader);
            return featureSpec;
        }
    }
}

