/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.model.state;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.model.state.State;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;

class FeaturePackProvisioning {
    FeaturePackProvisioning() {
    }

    State.Action removeDependency(ArtifactCoords.Gav gav) throws ProvisioningException {
        return new RemoveDependencyAction(gav);
    }

    State.Action addDependency(PmSession pmSession, String name, ArtifactCoords.Gav gav, boolean inheritConfigs, boolean inheritPackages) throws ProvisioningException, IOException {
        AddDependencyAction action = new AddDependencyAction(gav, inheritConfigs, inheritPackages);
        return action;
    }

    State.Action includeConfiguration(Map<FeaturePackConfig, ConfigId> cf) throws ProvisioningDescriptionException, ProvisioningException, IOException {
        return new IncludeConfigurationAction(cf);
    }

    State.Action removeIncludedConfiguration(Map<FeaturePackConfig, ConfigId> cf) throws ProvisioningDescriptionException, ProvisioningException, IOException {
        return new RemoveIncludedConfigurationAction(cf);
    }

    State.Action excludeConfiguration(Map<FeaturePackConfig, ConfigId> cf) throws ProvisioningDescriptionException, ProvisioningException, IOException {
        return new ExcludeConfigurationAction(cf);
    }

    State.Action removeExcludedConfiguration(Map<FeaturePackConfig, ConfigId> cf) throws ProvisioningDescriptionException, ProvisioningException, IOException {
        return new RemoveExcludedConfigurationAction(cf);
    }

    State.Action includePackage(String pkg, FeaturePackConfig cf) throws ProvisioningDescriptionException, ProvisioningException, IOException {
        HashMap<FeaturePackConfig, String> map = new HashMap<FeaturePackConfig, String>();
        map.put(cf, pkg);
        return new IncludePackageAction((Map<FeaturePackConfig, String>)map);
    }

    State.Action removeIncludedPackage(Map<FeaturePackConfig, String> cf) throws ProvisioningDescriptionException, ProvisioningException, IOException {
        return new RemoveIncludedPackageAction(cf);
    }

    State.Action excludePackage(String pkg, FeaturePackConfig cf) throws ProvisioningDescriptionException, ProvisioningException, IOException {
        HashMap<FeaturePackConfig, String> map = new HashMap<FeaturePackConfig, String>();
        map.put(cf, pkg);
        return new ExcludePackageAction((Map<FeaturePackConfig, String>)map);
    }

    State.Action removeExcludedPackage(Map<FeaturePackConfig, String> cf) throws ProvisioningDescriptionException, ProvisioningException, IOException {
        return new RemoveExcludedPackageAction(cf);
    }

    private class RemoveExcludedPackageAction
    extends AbstractAction<String> {
        RemoveExcludedPackageAction(Map<FeaturePackConfig, String> cf) {
            super(cf);
        }

        @Override
        protected boolean doAction(FeaturePackConfig.Builder fpBuilder, String pkg) throws ProvisioningException {
            try {
                fpBuilder.removeExcludedPackage(pkg);
            }
            catch (ProvisioningDescriptionException ex) {
                return false;
            }
            return true;
        }

        @Override
        protected void undoAction(FeaturePackConfig.Builder fpBuilder, String pkg) throws ProvisioningException {
            fpBuilder.excludePackage(pkg);
        }
    }

    private class RemoveIncludedPackageAction
    extends AbstractAction<String> {
        RemoveIncludedPackageAction(Map<FeaturePackConfig, String> cf) {
            super(cf);
        }

        @Override
        protected boolean doAction(FeaturePackConfig.Builder fpBuilder, String pkg) throws ProvisioningException {
            try {
                fpBuilder.removeIncludedPackage(pkg);
            }
            catch (ProvisioningDescriptionException ex) {
                return false;
            }
            return true;
        }

        @Override
        protected void undoAction(FeaturePackConfig.Builder fpBuilder, String pkg) throws ProvisioningException {
            fpBuilder.includePackage(pkg);
        }
    }

    private class ExcludePackageAction
    extends AbstractAction<String> {
        ExcludePackageAction(Map<FeaturePackConfig, String> cf) {
            super(cf);
        }

        @Override
        protected boolean doAction(FeaturePackConfig.Builder fpBuilder, String pkg) throws ProvisioningException {
            try {
                fpBuilder.excludePackage(pkg);
            }
            catch (ProvisioningDescriptionException ex) {
                return false;
            }
            return true;
        }

        @Override
        protected void undoAction(FeaturePackConfig.Builder fpBuilder, String pkg) throws ProvisioningException {
            fpBuilder.removeExcludedPackage(pkg);
        }
    }

    private class IncludePackageAction
    extends AbstractAction<String> {
        IncludePackageAction(Map<FeaturePackConfig, String> cf) {
            super(cf);
        }

        @Override
        protected boolean doAction(FeaturePackConfig.Builder fpBuilder, String pkg) throws ProvisioningException {
            try {
                fpBuilder.includePackage(pkg);
            }
            catch (ProvisioningDescriptionException ex) {
                return false;
            }
            return true;
        }

        @Override
        protected void undoAction(FeaturePackConfig.Builder fpBuilder, String pkg) throws ProvisioningException {
            fpBuilder.removeIncludedPackage(pkg);
        }
    }

    private class RemoveIncludedConfigurationAction
    extends AbstractAction<ConfigId> {
        RemoveIncludedConfigurationAction(Map<FeaturePackConfig, ConfigId> cf) {
            super(cf);
        }

        @Override
        protected boolean doAction(FeaturePackConfig.Builder fpBuilder, ConfigId id) throws ProvisioningException {
            try {
                fpBuilder.removeIncludedDefaultConfig(id);
            }
            catch (ProvisioningDescriptionException ex) {
                return false;
            }
            return true;
        }

        @Override
        protected void undoAction(FeaturePackConfig.Builder fpBuilder, ConfigId id) throws ProvisioningException {
            fpBuilder.includeDefaultConfig(id);
        }
    }

    private class RemoveExcludedConfigurationAction
    extends AbstractAction<ConfigId> {
        RemoveExcludedConfigurationAction(Map<FeaturePackConfig, ConfigId> cf) {
            super(cf);
        }

        @Override
        protected boolean doAction(FeaturePackConfig.Builder fpBuilder, ConfigId id) throws ProvisioningException {
            try {
                fpBuilder.removeExcludedDefaultConfig(id);
            }
            catch (ProvisioningDescriptionException ex) {
                return false;
            }
            return true;
        }

        @Override
        protected void undoAction(FeaturePackConfig.Builder fpBuilder, ConfigId id) throws ProvisioningException {
            fpBuilder.excludeDefaultConfig(id);
        }
    }

    private class ExcludeConfigurationAction
    extends AbstractAction<ConfigId> {
        ExcludeConfigurationAction(Map<FeaturePackConfig, ConfigId> cf) {
            super(cf);
        }

        @Override
        protected boolean doAction(FeaturePackConfig.Builder fpBuilder, ConfigId id) throws ProvisioningException {
            fpBuilder.excludeDefaultConfig(id);
            return true;
        }

        @Override
        protected void undoAction(FeaturePackConfig.Builder fpBuilder, ConfigId id) throws ProvisioningException {
            fpBuilder.removeExcludedDefaultConfig(id);
        }
    }

    private class IncludeConfigurationAction
    extends AbstractAction<ConfigId> {
        IncludeConfigurationAction(Map<FeaturePackConfig, ConfigId> cf) {
            super(cf);
        }

        @Override
        protected boolean doAction(FeaturePackConfig.Builder fpBuilder, ConfigId id) throws ProvisioningException {
            try {
                fpBuilder.includeDefaultConfig(id);
            }
            catch (ProvisioningDescriptionException ex) {
                return false;
            }
            return true;
        }

        @Override
        protected void undoAction(FeaturePackConfig.Builder fpBuilder, ConfigId id) throws ProvisioningException {
            fpBuilder.removeIncludedDefaultConfig(id);
        }
    }

    private abstract class AbstractAction<T>
    implements State.Action {
        private final Map<FeaturePackConfig, T> cf;
        private final Map<ArtifactCoords.Gav, Integer> indexes = new HashMap<ArtifactCoords.Gav, Integer>();

        AbstractAction(Map<FeaturePackConfig, T> cf) {
            this.cf = cf;
        }

        protected abstract boolean doAction(FeaturePackConfig.Builder var1, T var2) throws ProvisioningException;

        protected abstract void undoAction(FeaturePackConfig.Builder var1, T var2) throws ProvisioningException;

        @Override
        public void doAction(ProvisioningConfig current, ProvisioningConfig.Builder builder) throws ProvisioningException {
            for (Map.Entry<FeaturePackConfig, T> entry : this.cf.entrySet()) {
                FeaturePackConfig.Builder fpBuilder = entry.getKey().getBuilder();
                boolean doit = this.doAction(fpBuilder, entry.getValue());
                if (!doit) continue;
                int index = builder.getFeaturePackDepIndex(entry.getKey().getGav());
                this.indexes.put(entry.getKey().getGav(), index);
                builder.removeFeaturePackDep(entry.getKey().getGav());
                builder.addFeaturePackDep(index, fpBuilder.build());
            }
        }

        @Override
        public void undoAction(ProvisioningConfig.Builder builder) throws ProvisioningException {
            for (Map.Entry<FeaturePackConfig, T> entry : this.cf.entrySet()) {
                Integer index = this.indexes.get(entry.getKey().getGav());
                if (index == null) continue;
                FeaturePackConfig.Builder fpBuilder = entry.getKey().getBuilder();
                this.undoAction(fpBuilder, entry.getValue());
                builder.removeFeaturePackDep(entry.getKey().getGav());
                builder.addFeaturePackDep(index, fpBuilder.build());
            }
        }
    }

    private class RemoveDependencyAction
    implements State.Action {
        private final ArtifactCoords.Gav gav;
        private int index;
        private FeaturePackConfig fpConfig;

        RemoveDependencyAction(ArtifactCoords.Gav gav) {
            this.gav = gav;
        }

        @Override
        public void doAction(ProvisioningConfig current, ProvisioningConfig.Builder builder) throws ProvisioningException {
            this.index = builder.getFeaturePackDepIndex(this.gav);
            this.fpConfig = current.getFeaturePackDep(this.gav.toGa());
            builder.removeFeaturePackDep(this.gav);
        }

        @Override
        public void undoAction(ProvisioningConfig.Builder builder) throws ProvisioningException {
            builder.addFeaturePackDep(this.index, this.fpConfig);
        }
    }

    private class AddDependencyAction
    implements State.Action {
        private final FeaturePackConfig.Builder newDepBuilder;
        private final ArtifactCoords.Gav gav;

        AddDependencyAction(ArtifactCoords.Gav gav, boolean inheritConfigs, boolean inheritPackages) {
            this.gav = gav;
            this.newDepBuilder = ((FeaturePackConfig.Builder)FeaturePackConfig.builder(gav).setInheritConfigs(inheritConfigs)).setInheritPackages(inheritPackages);
        }

        @Override
        public void doAction(ProvisioningConfig current, ProvisioningConfig.Builder builder) throws ProvisioningException {
            builder.addFeaturePackDep(this.newDepBuilder.build());
        }

        @Override
        public void undoAction(ProvisioningConfig.Builder builder) throws ProvisioningException {
            builder.removeFeaturePackDep(this.gav);
        }
    }
}

