/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.spec.PackageDependencySpec;
import org.jboss.galleon.spec.PackageSpec;
import org.jboss.galleon.util.CollectionUtils;

public class FeaturePackLayout {
    private final FeaturePackSpec spec;
    private final Map<String, PackageSpec> packages;
    final List<String> unresolvedLocalPkgs;
    final boolean externalPkgDeps;

    public static Builder builder(FeaturePackSpec.Builder spec) {
        return new Builder(spec);
    }

    private FeaturePackLayout(Builder builder) throws ProvisioningDescriptionException {
        this.spec = builder.spec.build();
        this.packages = CollectionUtils.unmodifiable(builder.packages);
        for (String name : this.spec.getDefaultPackageNames()) {
            if (this.packages.containsKey(name)) continue;
            throw new ProvisioningDescriptionException(Errors.unknownPackage(this.spec.getGav(), name));
        }
        List<String> notFound = Collections.emptyList();
        boolean externalPkgDeps = false;
        if (!this.packages.isEmpty()) {
            for (PackageSpec pkg : this.packages.values()) {
                if (pkg.hasLocalPackageDeps()) {
                    for (PackageDependencySpec pkgDep : pkg.getLocalPackageDeps()) {
                        PackageSpec depSpec = this.packages.get(pkgDep.getName());
                        if (depSpec != null) continue;
                        if (notFound.isEmpty()) {
                            notFound = new ArrayList<String>();
                        }
                        notFound.add(pkgDep.getName());
                    }
                    if (!this.spec.hasFeaturePackDeps() && !notFound.isEmpty()) {
                        throw new ProvisioningDescriptionException(Errors.unsatisfiedPackageDependencies(this.spec.getGav(), pkg.getName(), notFound));
                    }
                }
                if (!pkg.hasExternalPackageDeps()) continue;
                for (String origin : pkg.getPackageOrigins()) {
                    try {
                        this.spec.getFeaturePackDep(origin);
                    }
                    catch (ProvisioningDescriptionException e) {
                        throw new ProvisioningDescriptionException(Errors.unknownFeaturePackDependencyName(this.spec.getGav(), pkg.getName(), origin), e);
                    }
                }
                externalPkgDeps = true;
            }
        }
        this.externalPkgDeps = externalPkgDeps;
        this.unresolvedLocalPkgs = CollectionUtils.unmodifiable(notFound);
    }

    public ArtifactCoords.Gav getGav() {
        return this.spec.getGav();
    }

    public FeaturePackSpec getSpec() {
        return this.spec;
    }

    public boolean hasPackages() {
        return !this.packages.isEmpty();
    }

    public boolean hasPackage(String name) {
        return this.packages.containsKey(name);
    }

    public PackageSpec getPackage(String name) {
        return this.packages.get(name);
    }

    public Set<String> getPackageNames() {
        return this.packages.keySet();
    }

    public Collection<PackageSpec> getPackages() {
        return this.packages.values();
    }

    public static class Builder {
        private final FeaturePackSpec.Builder spec;
        private Map<String, PackageSpec> packages = Collections.emptyMap();

        private Builder(FeaturePackSpec.Builder spec) {
            this.spec = spec;
        }

        public Builder addPackage(PackageSpec pkg) {
            this.packages = CollectionUtils.put(this.packages, pkg.getName(), pkg);
            return this;
        }

        public boolean hasPackage(String name) {
            return this.packages.containsKey(name);
        }

        public FeaturePackSpec.Builder getSpecBuilder() {
            return this.spec;
        }

        public FeaturePackLayout build() throws ProvisioningDescriptionException {
            return new FeaturePackLayout(this);
        }
    }
}

