/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.repomanager;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ArtifactRepositoryManager;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeatureGroup;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.plugin.InstallPlugin;
import org.jboss.galleon.repomanager.FeaturePackInstaller;
import org.jboss.galleon.repomanager.PackageBuilder;
import org.jboss.galleon.repomanager.fs.FsTaskContext;
import org.jboss.galleon.repomanager.fs.FsTaskList;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.spec.FeatureSpec;
import org.jboss.galleon.spec.PackageSpec;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.ZipUtils;
import org.jboss.galleon.xml.FeatureGroupXmlWriter;
import org.jboss.galleon.xml.FeaturePackXmlWriter;
import org.jboss.galleon.xml.FeatureSpecXmlWriter;

public class FeaturePackBuilder {
    private final FeaturePackInstaller installer;
    private final FeaturePackSpec.Builder fpBuilder = FeaturePackSpec.builder();
    private List<PackageBuilder> pkgs = Collections.emptyList();
    private Set<Class<?>> classes = Collections.emptySet();
    private Map<String, Set<String>> services = Collections.emptyMap();
    private String pluginFileName = "plugins.jar";
    private List<Path> plugins = Collections.emptyList();
    private Map<String, FeatureSpec> specs = Collections.emptyMap();
    private Map<String, FeatureGroup> featureGroups = Collections.emptyMap();
    private FsTaskList tasks;

    public static FeaturePackBuilder newInstance() {
        return FeaturePackBuilder.newInstance(null);
    }

    public static FeaturePackBuilder newInstance(FeaturePackInstaller installer) {
        return new FeaturePackBuilder(installer);
    }

    protected FeaturePackBuilder(FeaturePackInstaller repo) {
        this.installer = repo;
    }

    public FeaturePackInstaller getInstaller() {
        return this.installer;
    }

    public FeaturePackBuilder setGav(ArtifactCoords.Gav gav) {
        this.fpBuilder.setGav(gav);
        return this;
    }

    public FeaturePackBuilder addDependency(String origin, FeaturePackConfig dep) throws ProvisioningDescriptionException {
        this.fpBuilder.addFeaturePackDep(origin, dep);
        return this;
    }

    public FeaturePackBuilder addDependency(FeaturePackConfig dep) throws ProvisioningDescriptionException {
        return this.addDependency(null, dep);
    }

    public FeaturePackBuilder addDependency(ArtifactCoords.Gav gav) throws ProvisioningDescriptionException {
        return this.addDependency(FeaturePackConfig.forGav(gav));
    }

    public FeaturePackBuilder addDependency(String origin, ArtifactCoords.Gav gav) throws ProvisioningDescriptionException {
        return this.addDependency(origin, FeaturePackConfig.forGav(gav));
    }

    public FeaturePackBuilder addPackage(PackageBuilder pkg) {
        this.pkgs = CollectionUtils.add(this.pkgs, pkg);
        return this;
    }

    public PackageBuilder newPackage(String name) {
        return this.newPackage(name, false);
    }

    public PackageBuilder newPackage(String name, boolean isDefault) {
        PackageBuilder pkg = PackageBuilder.newInstance(this, name);
        if (isDefault) {
            pkg.setDefault();
        }
        this.addPackage(pkg);
        return pkg;
    }

    public FeaturePackBuilder addSpec(FeatureSpec spec) throws ProvisioningDescriptionException {
        if (this.specs.isEmpty()) {
            this.specs = Collections.singletonMap(spec.getName(), spec);
        } else {
            if (this.specs.containsKey(spec.getName())) {
                throw new ProvisioningDescriptionException("Duplicate spec name " + spec.getName() + " for " + this.fpBuilder.getGav());
            }
            if (this.specs.size() == 1) {
                this.specs = new HashMap<String, FeatureSpec>(this.specs);
            }
            this.specs.put(spec.getName(), spec);
        }
        return this;
    }

    public FeaturePackBuilder addFeatureGroup(FeatureGroup featureGroup) throws ProvisioningDescriptionException {
        if (this.featureGroups.isEmpty()) {
            this.featureGroups = Collections.singletonMap(featureGroup.getName(), featureGroup);
        } else {
            if (this.featureGroups.containsKey(featureGroup.getName())) {
                throw new ProvisioningDescriptionException("Duplicate feature-group name " + featureGroup.getName() + " for " + this.fpBuilder.getGav());
            }
            if (this.featureGroups.size() == 1) {
                this.featureGroups = new HashMap<String, FeatureGroup>(this.featureGroups);
            }
            this.featureGroups.put(featureGroup.getName(), featureGroup);
        }
        return this;
    }

    public FeaturePackBuilder addConfig(ConfigModel config) throws ProvisioningDescriptionException {
        this.fpBuilder.addConfig(config);
        return this;
    }

    public FeaturePackBuilder setPluginFileName(String pluginFileName) {
        this.pluginFileName = pluginFileName;
        return this;
    }

    public FeaturePackBuilder addClassToPlugin(Class<?> cls) {
        if (this.classes.contains(cls)) {
            return this;
        }
        switch (this.classes.size()) {
            case 0: {
                this.classes = Collections.singleton(cls);
                break;
            }
            case 1: {
                this.classes = new HashSet(this.classes);
            }
            default: {
                this.classes.add(cls);
            }
        }
        return this;
    }

    public FeaturePackBuilder addPlugin(Path file) {
        if (this.plugins.contains(file)) {
            return this;
        }
        this.plugins = CollectionUtils.add(this.plugins, file);
        return this;
    }

    public FeaturePackBuilder addPlugin(Class<? extends InstallPlugin> pluginCls) {
        return this.addService(InstallPlugin.class, pluginCls);
    }

    public FeaturePackBuilder addService(Class<?> serviceInterface, Class<?> serviceImpl) {
        String serviceName = serviceInterface.getName();
        Set<String> implSet = this.services.get(serviceName);
        if (implSet == null) {
            switch (this.services.size()) {
                case 0: {
                    this.services = Collections.singletonMap(serviceName, Collections.singleton(serviceImpl.getName()));
                    break;
                }
                case 1: {
                    this.services = new HashMap<String, Set<String>>(this.services);
                }
                default: {
                    this.services.put(serviceName, Collections.singleton(serviceImpl.getName()));
                    break;
                }
            }
        } else {
            if (implSet.contains(serviceImpl.getName())) {
                return this;
            }
            if (implSet.size() == 1) {
                implSet = new HashSet<String>(implSet);
                implSet.add(serviceImpl.getName());
                if (this.services.size() == 1) {
                    this.services = Collections.singletonMap(serviceName, implSet);
                } else {
                    this.services.put(serviceName, implSet);
                }
            } else {
                implSet.add(serviceImpl.getName());
            }
        }
        this.addClassToPlugin(serviceImpl);
        return this;
    }

    public FeaturePackBuilder writeResources(String relativePath, String content) throws ProvisioningDescriptionException {
        if (this.tasks == null) {
            this.tasks = FsTaskList.newList();
        }
        this.tasks.write(content, relativePath, false);
        return this;
    }

    public FeaturePackSpec build(ArtifactRepositoryManager manager) throws ProvisioningDescriptionException {
        Path fpWorkDir = IoUtils.createRandomTmpDir();
        try {
            for (PackageBuilder pkg : this.pkgs) {
                PackageSpec pkgDescr = pkg.build(fpWorkDir);
                if (!pkg.isDefault()) continue;
                this.fpBuilder.addDefaultPackage(pkgDescr.getName());
            }
            if (!this.specs.isEmpty()) {
                Path featuresDir = fpWorkDir.resolve("features");
                FeatureSpecXmlWriter specWriter = FeatureSpecXmlWriter.getInstance();
                for (FeatureSpec spec : this.specs.values()) {
                    Path featureDir = featuresDir.resolve(spec.getName());
                    this.ensureDir(featureDir);
                    specWriter.write(spec, featureDir.resolve("spec.xml"));
                }
            }
            if (!this.featureGroups.isEmpty()) {
                Path fgsDir = fpWorkDir.resolve("feature_groups");
                this.ensureDir(fgsDir);
                FeatureGroupXmlWriter fgWriter = FeatureGroupXmlWriter.getInstance();
                for (FeatureGroup fg : this.featureGroups.values()) {
                    fgWriter.write(fg, fgsDir.resolve(fg.getName() + ".xml"));
                }
            }
            if (!this.classes.isEmpty() || !this.plugins.isEmpty()) {
                this.addPlugins(fpWorkDir);
            }
            FeaturePackSpec fpSpec = this.fpBuilder.build();
            FeaturePackXmlWriter writer = FeaturePackXmlWriter.getInstance();
            writer.write(fpSpec, fpWorkDir.resolve("feature-pack.xml"));
            if (this.tasks != null && !this.tasks.isEmpty()) {
                this.tasks.execute(FsTaskContext.builder().setTargetRoot(fpWorkDir.resolve("resources")).build());
            }
            manager.install(fpSpec.getGav().toArtifactCoords(), fpWorkDir);
            FeaturePackSpec featurePackSpec = fpSpec;
            return featurePackSpec;
        }
        catch (ProvisioningDescriptionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            IoUtils.recursiveDelete(fpWorkDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPlugins(Path fpDir) throws IOException {
        Path tmpDir = IoUtils.createRandomTmpDir();
        try {
            byte[] bytes = new byte[65536];
            for (Class<?> cls : this.classes) {
                Path p = tmpDir;
                String[] parts = cls.getName().split("\\.");
                int i = 0;
                while (i < parts.length - 1) {
                    p = p.resolve(parts[i++]);
                }
                p = p.resolve(parts[i] + ".class");
                Files.createDirectories(p.getParent(), new FileAttribute[0]);
                InputStream is = cls.getClassLoader().getResourceAsStream(tmpDir.relativize(p).toString());
                if (is == null) {
                    throw new IOException("Failed to locate " + tmpDir.relativize(p));
                }
                try {
                    OutputStream os = Files.newOutputStream(p, new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        int rc;
                        while ((rc = is.read(bytes)) != -1) {
                            os.write(bytes, 0, rc);
                        }
                        os.flush();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (os == null) continue;
                        if (throwable != null) {
                            try {
                                os.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        os.close();
                    }
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (!this.services.isEmpty()) {
                Path servicesDir = tmpDir.resolve("META-INF").resolve("services");
                Files.createDirectories(servicesDir, new FileAttribute[0]);
                for (Map.Entry<String, Set<String>> entry : this.services.entrySet()) {
                    Path service = servicesDir.resolve(entry.getKey());
                    BufferedWriter writer = Files.newBufferedWriter(service, new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        for (String impl : entry.getValue()) {
                            writer.write(impl);
                            writer.newLine();
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (writer == null) continue;
                        if (throwable != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        writer.close();
                    }
                }
            }
            Path pluginsDir = fpDir.resolve("plugins");
            this.ensureDir(pluginsDir);
            ZipUtils.zip(tmpDir, pluginsDir.resolve(this.pluginFileName));
            if (!this.plugins.isEmpty()) {
                for (Path plugin : this.plugins) {
                    Files.copy(plugin, pluginsDir.resolve(plugin.getFileName()), new CopyOption[0]);
                }
            }
        }
        finally {
            IoUtils.recursiveDelete(tmpDir);
        }
    }

    private void ensureDir(Path dir) throws IOException {
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        } else if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IllegalStateException(dir + " is not a directory.");
        }
    }
}

