/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeatureGroupSupport;
import org.jboss.galleon.runtime.DefaultBranchedConfigArranger;
import org.jboss.galleon.runtime.ProvisioningRuntimeBuilder;
import org.jboss.galleon.runtime.ResolvedFeature;
import org.jboss.galleon.runtime.ResolvedFeatureGroupConfig;
import org.jboss.galleon.runtime.ResolvedFeatureId;
import org.jboss.galleon.runtime.ResolvedFeatureSpec;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.runtime.SpecFeatures;
import org.jboss.galleon.runtime.SpecOnlyConfigArranger;
import org.jboss.galleon.spec.FeatureDependencySpec;

class ConfigModelStack {
    final ConfigId id;
    final ProvisioningRuntimeBuilder rt;
    Map<String, String> props = Collections.emptyMap();
    Map<String, ConfigId> configDeps = Collections.emptyMap();
    Map<ResolvedSpecId, SpecFeatures> specFeatures = new LinkedHashMap<ResolvedSpecId, SpecFeatures>();
    private List<Map<ResolvedFeatureId, ResolvedFeature>> fgFeatures = new ArrayList<Map<ResolvedFeatureId, ResolvedFeature>>();
    private int lastFg = -1;
    Map<ResolvedFeatureId, ResolvedFeature> features;
    private int featureIncludeCount = 0;
    private List<ConfigScope> configs = new ArrayList<ConfigScope>();
    private ConfigScope lastConfig;
    private List<ResolvedFeature> orderedFeatures = null;

    ConfigModelStack(ConfigId configId, ProvisioningRuntimeBuilder rt) throws ProvisioningException {
        this.id = configId;
        this.rt = rt;
        this.lastConfig = new ConfigScope(null);
        this.configs.add(this.lastConfig);
        this.newFgScope();
    }

    boolean hasProperties() {
        return !this.props.isEmpty();
    }

    Map<String, String> getProperties() {
        return this.props;
    }

    void overwriteProps(Map<String, String> props) {
        if (props.isEmpty()) {
            return;
        }
        if (this.props.isEmpty()) {
            this.props = new HashMap<String, String>(props.size());
        }
        this.props.putAll(props);
    }

    boolean hasConfigDeps() {
        return !this.configDeps.isEmpty();
    }

    Map<String, ConfigId> getConfigDeps() {
        return this.configDeps;
    }

    void overwriteConfigDeps(Map<String, ConfigId> configDeps) {
        if (configDeps.isEmpty()) {
            return;
        }
        if (this.configDeps.isEmpty()) {
            this.configDeps = new HashMap<String, ConfigId>(configDeps.size());
        }
        this.configDeps.putAll(configDeps);
    }

    void pushConfig(ConfigModel model) throws ProvisioningException {
        this.lastConfig = new ConfigScope(model);
        this.configs.add(this.lastConfig);
    }

    ConfigModel popConfig() throws ProvisioningException {
        ConfigScope result = this.lastConfig;
        this.configs.remove(this.configs.size() - 1);
        this.lastConfig = this.configs.get(this.configs.size() - 1);
        result.complete();
        return result.config;
    }

    boolean pushGroup(FeatureGroupSupport fg) throws ProvisioningException {
        if (!this.lastConfig.push(fg)) {
            return false;
        }
        this.newFgScope();
        return true;
    }

    boolean popGroup() throws ProvisioningException {
        this.mergeFgScope();
        return this.lastConfig.pop();
    }

    private void newFgScope() {
        ++this.lastFg;
        if (this.fgFeatures.size() == this.lastFg) {
            this.features = new LinkedHashMap<ResolvedFeatureId, ResolvedFeature>();
            this.fgFeatures.add(this.features);
        } else {
            this.features = this.fgFeatures.get(this.lastFg);
        }
    }

    private void mergeFgScope() throws ProvisioningException {
        if (this.lastFg <= 0) {
            return;
        }
        Map<ResolvedFeatureId, ResolvedFeature> endedGroup = this.fgFeatures.get(this.lastFg--);
        Map<ResolvedFeatureId, ResolvedFeature> parentGroup = this.fgFeatures.get(this.lastFg);
        for (Map.Entry<ResolvedFeatureId, ResolvedFeature> entry : endedGroup.entrySet()) {
            ResolvedFeature parentFeature = parentGroup.get(entry.getKey());
            if (parentFeature == null) {
                parentGroup.put(entry.getKey(), entry.getValue());
                if (this.lastFg != 0) continue;
                this.addToSpecFeatures(entry.getValue());
                continue;
            }
            parentFeature.merge(entry.getValue(), true);
        }
        endedGroup.clear();
        this.features = parentGroup;
    }

    boolean includes(ResolvedFeatureId id) {
        return this.features.containsKey(id);
    }

    void addFeature(ResolvedFeature feature) throws ProvisioningDescriptionException {
        if (feature.id == null) {
            this.addToSpecFeatures(feature);
            return;
        }
        this.features.put(feature.id, feature);
        if (this.lastFg == 0) {
            this.addToSpecFeatures(feature);
        }
    }

    ResolvedFeature includeFeature(ResolvedFeatureId id, ResolvedFeatureSpec spec, Map<String, Object> resolvedParams, Map<ResolvedFeatureId, FeatureDependencySpec> resolvedDeps) throws ProvisioningException {
        ResolvedFeature feature;
        if (id != null && (feature = this.features.get(id)) != null) {
            feature.merge(resolvedDeps, resolvedParams, true);
            return feature;
        }
        feature = new ResolvedFeature(id, spec, resolvedParams, resolvedDeps, ++this.featureIncludeCount);
        this.addFeature(feature);
        return feature;
    }

    boolean isFilteredOut(ResolvedSpecId specId, ResolvedFeatureId id) {
        if (this.lastConfig.isFilteredOut(specId, id)) {
            return true;
        }
        if (this.configs.size() > 1) {
            for (int i = this.configs.size() - 2; i >= 0; --i) {
                if (!this.configs.get(i).isFilteredOut(specId, id)) continue;
                return true;
            }
        }
        return false;
    }

    void merge(ConfigModelStack other) throws ProvisioningException {
        if (!other.props.isEmpty()) {
            if (this.props.isEmpty()) {
                this.props = other.props;
            } else {
                for (Map.Entry<String, String> entry : other.props.entrySet()) {
                    if (this.props.containsKey(entry.getKey())) continue;
                    this.props.put(entry.getKey(), entry.getValue());
                }
            }
        }
        if (!other.configDeps.isEmpty()) {
            if (this.configDeps.isEmpty()) {
                this.configDeps = other.configDeps;
            } else {
                for (Map.Entry<Object, Object> entry : other.configDeps.entrySet()) {
                    if (this.configDeps.containsKey(entry.getKey())) continue;
                    this.configDeps.put((String)entry.getKey(), (ConfigId)entry.getValue());
                }
            }
        }
        if (other.specFeatures.isEmpty()) {
            return;
        }
        for (Map.Entry<Object, Object> entry : other.specFeatures.entrySet()) {
            SpecFeatures otherSpecFeatures = (SpecFeatures)entry.getValue();
            SpecFeatures specFeatures = null;
            for (ResolvedFeature feature : otherSpecFeatures.getFeatures()) {
                if (feature.id == null) {
                    if (specFeatures == null) {
                        specFeatures = this.getSpecFeatures(otherSpecFeatures.spec);
                    }
                    specFeatures.add(feature);
                    continue;
                }
                ResolvedFeature localFeature = this.features.get(feature.id);
                if (localFeature == null) {
                    feature = feature.copy(++this.featureIncludeCount);
                    this.features.put(feature.id, feature);
                    if (specFeatures == null) {
                        specFeatures = this.getSpecFeatures(otherSpecFeatures.spec);
                    }
                    specFeatures.add(feature);
                    continue;
                }
                localFeature.merge(feature, false);
            }
        }
    }

    List<ResolvedFeature> orderFeatures() throws ProvisioningException {
        if (this.orderedFeatures != null) {
            return this.orderedFeatures;
        }
        if (this.features.isEmpty()) {
            this.orderedFeatures = Collections.emptyList();
        } else {
            String arranger = System.getProperty("galleon.config.arranger");
            if (arranger == null) {
                this.orderedFeatures = new DefaultBranchedConfigArranger(this).orderFeatures();
            } else if ("spec-only".equals(arranger)) {
                this.orderedFeatures = new SpecOnlyConfigArranger().orderFeatures(this);
            } else {
                throw new ProvisioningException("Unsupported config arranger " + arranger);
            }
        }
        return this.orderedFeatures;
    }

    private void addToSpecFeatures(ResolvedFeature feature) {
        this.getSpecFeatures(feature.spec).add(feature);
    }

    SpecFeatures getSpecFeatures(ResolvedFeatureSpec spec) {
        SpecFeatures sf = this.specFeatures.get(spec.id);
        if (sf == null) {
            sf = new SpecFeatures(spec);
            this.specFeatures.put(spec.id, sf);
        }
        return sf;
    }

    private boolean isRelevant(ResolvedFeatureGroupConfig resolvedFg) {
        if (resolvedFg.fg.getId() == null) {
            return true;
        }
        if (!this.lastConfig.isRelevant(resolvedFg)) {
            return false;
        }
        if (this.configs.size() > 1) {
            for (int i = this.configs.size() - 2; i >= 0; --i) {
                if (this.configs.get(i).isRelevant(resolvedFg)) continue;
                return false;
            }
        }
        return true;
    }

    private class ConfigScope {
        final ConfigModel config;
        private final boolean pushedFgScope;
        private List<ResolvedFeatureGroupConfig> groupStack = new ArrayList<ResolvedFeatureGroupConfig>();

        ConfigScope(ConfigModel config) throws ProvisioningException {
            this.config = config;
            if (config != null) {
                this.pushedFgScope = this.push(config);
                if (this.pushedFgScope) {
                    ConfigModelStack.this.newFgScope();
                }
            } else {
                this.pushedFgScope = false;
            }
        }

        void complete() throws ProvisioningException {
            if (this.pushedFgScope) {
                ConfigModelStack.this.mergeFgScope();
            }
            for (int i = this.groupStack.size() - 1; i >= 0; --i) {
                ConfigModelStack.this.rt.processIncludedFeatures(this.groupStack.get(i));
            }
        }

        boolean push(FeatureGroupSupport fg) throws ProvisioningException {
            ResolvedFeatureGroupConfig resolvedFg = ConfigModelStack.this.rt.resolveFeatureGroupConfig(fg);
            if (!fg.isConfig() && !ConfigModelStack.this.isRelevant(resolvedFg)) {
                return false;
            }
            this.groupStack.add(resolvedFg);
            return true;
        }

        boolean pop() throws ProvisioningException {
            if (this.groupStack.isEmpty()) {
                throw new IllegalStateException("Feature group stack is empty");
            }
            ResolvedFeatureGroupConfig last = this.groupStack.remove(this.groupStack.size() - 1);
            boolean processed = ConfigModelStack.this.rt.processIncludedFeatures(last);
            return processed;
        }

        boolean isFilteredOut(ResolvedSpecId specId, ResolvedFeatureId id) {
            boolean included = false;
            for (int i = this.groupStack.size() - 1; i >= 0; --i) {
                ResolvedFeatureGroupConfig fgConfig = this.groupStack.get(i);
                if (fgConfig.inheritFeatures) {
                    if (id != null && fgConfig.excludedFeatures.contains(id)) {
                        return true;
                    }
                    if (!fgConfig.excludedSpecs.contains(specId)) continue;
                    if (id != null && fgConfig.includedFeatures.containsKey(id)) {
                        included = true;
                        continue;
                    }
                    return true;
                }
                if (id != null && fgConfig.includedFeatures.containsKey(id)) {
                    included = true;
                    continue;
                }
                if (!fgConfig.includedSpecs.contains(specId)) {
                    return true;
                }
                if (id != null && fgConfig.excludedFeatures.contains(id)) {
                    return true;
                }
                included = true;
            }
            if (included) {
                return false;
            }
            return this.config == null ? false : !this.config.isInheritFeatures();
        }

        private boolean isRelevant(ResolvedFeatureGroupConfig resolvedFg) {
            if (resolvedFg.fg.getId() == null) {
                return true;
            }
            for (int i = this.groupStack.size() - 1; i >= 0; --i) {
                ResolvedFeatureGroupConfig stacked = this.groupStack.get(i);
                if (stacked.fg.getId() == null || stacked.gav == null || resolvedFg.gav == null || !stacked.gav.equals(resolvedFg.gav) || !stacked.fg.getId().equals(resolvedFg.fg.getId())) continue;
                return !resolvedFg.isSubsetOf(stacked);
            }
            return true;
        }
    }
}

