/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.diff.FileSystemDiffResult;
import org.jboss.galleon.xml.BaseXmlWriter;
import org.jboss.galleon.xml.FileSystemDiffResultParser;
import org.jboss.galleon.xml.util.AttributeValue;
import org.jboss.galleon.xml.util.CDataNode;
import org.jboss.galleon.xml.util.ElementNode;
import org.jboss.galleon.xml.util.TextNode;

public class FileSystemDiffResultWriter
extends BaseXmlWriter<FileSystemDiffResult> {
    private static final FileSystemDiffResultWriter INSTANCE = new FileSystemDiffResultWriter();

    public static FileSystemDiffResultWriter getInstance() {
        return INSTANCE;
    }

    @Override
    protected ElementNode toElement(FileSystemDiffResult result) throws XMLStreamException {
        ElementNode root = FileSystemDiffResultWriter.addElement(null, FileSystemDiffResultParser.Element.DIFF_RESULT);
        if (result.getAddedFiles() != null && !result.getAddedFiles().isEmpty()) {
            ElementNode addedFilesNode = FileSystemDiffResultWriter.addElement(root, FileSystemDiffResultParser.Element.ADDED);
            for (Path path : result.getAddedFiles()) {
                FileSystemDiffResultWriter.addElement(addedFilesNode, FileSystemDiffResultParser.Element.PATH).addChild(new TextNode(path.toString()));
            }
        }
        if (result.getDeletedFiles() != null && !result.getDeletedFiles().isEmpty()) {
            ElementNode deletedFilesNode = FileSystemDiffResultWriter.addElement(root, FileSystemDiffResultParser.Element.DELETED);
            for (Path path : result.getDeletedFiles()) {
                FileSystemDiffResultWriter.addElement(deletedFilesNode, FileSystemDiffResultParser.Element.PATH).addChild(new TextNode(path.toString()));
            }
        }
        if (result.getUnifiedDiffs() != null && !result.getUnifiedDiffs().isEmpty()) {
            ElementNode changesNode = FileSystemDiffResultWriter.addElement(root, FileSystemDiffResultParser.Element.CHANGES);
            for (Map.Entry entry : result.getUnifiedDiffs().entrySet()) {
                ElementNode changeNode = FileSystemDiffResultWriter.addElement(changesNode, FileSystemDiffResultParser.Element.CHANGE);
                changeNode.addChild(this.addChangeContent((List)entry.getValue()));
                changeNode.addAttribute("path", new AttributeValue(((Path)entry.getKey()).toString()));
            }
            ElementNode modifiedFilesNode = FileSystemDiffResultWriter.addElement(root, FileSystemDiffResultParser.Element.MODIFIED);
            for (Path modifiedFile : result.getModifiedBinaryFiles()) {
                FileSystemDiffResultWriter.addElement(modifiedFilesNode, FileSystemDiffResultParser.Element.PATH).addChild(new TextNode(modifiedFile.toString()));
            }
        }
        return root;
    }

    private CDataNode addChangeContent(List<String> diff) {
        return new CDataNode(diff.stream().collect(Collectors.joining(System.lineSeparator(), System.lineSeparator(), System.lineSeparator())));
    }
}

