/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.model.Caches;
import org.jboss.galleon.cli.model.ConfigInfo;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.cli.model.FeatureGroupsBuilder;
import org.jboss.galleon.cli.model.FeatureInfo;
import org.jboss.galleon.cli.model.FeaturePackInfo;
import org.jboss.galleon.cli.model.FeatureSpecInfo;
import org.jboss.galleon.cli.model.FeatureSpecsBuilder;
import org.jboss.galleon.cli.model.Group;
import org.jboss.galleon.cli.model.Identity;
import org.jboss.galleon.cli.model.PackageGroupsBuilder;
import org.jboss.galleon.cli.model.PackageInfo;
import org.jboss.galleon.cli.model.ProvisioningInfo;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.plugin.CliPlugin;
import org.jboss.galleon.plugin.ProvisionedConfigHandler;
import org.jboss.galleon.runtime.FeaturePackRuntime;
import org.jboss.galleon.runtime.PackageRuntime;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.state.ProvisionedConfig;
import org.jboss.galleon.state.ProvisionedFeature;

public abstract class FeatureContainers {
    public static FeatureContainer fromFeaturePackGav(PmSession session, ProvisioningManager manager, ArtifactCoords.Gav gav, String name) throws ProvisioningException, IOException {
        FeatureContainer fp = Caches.getFeaturePackInfo(gav);
        if (fp != null) {
            return fp;
        }
        fp = new FeaturePackInfo(name, gav);
        ProvisioningRuntime rt = FeatureContainers.buildFullRuntime(gav, manager);
        FeatureContainers.populateFeatureContainer(fp, session, rt, true);
        Caches.addFeaturePackInfo(gav, fp);
        return fp;
    }

    public static FeatureContainer fromProvisioningRuntime(PmSession session, ProvisioningManager manager, ProvisioningRuntime runtime) throws ProvisioningException, IOException {
        ProvisioningInfo info = new ProvisioningInfo();
        FeatureContainers.populateFeatureContainer(info, session, runtime, false);
        return info;
    }

    private static void populateFeatureContainer(final FeatureContainer fp, PmSession session, ProvisioningRuntime runtime, final boolean allSpecs) throws ProvisioningException, IOException {
        final HashMap<String, FeaturePackRuntime> gavs = new HashMap<String, FeaturePackRuntime>();
        for (FeaturePackRuntime rt : runtime.getFeaturePacks()) {
            gavs.put(Identity.buildOrigin(rt.getGav()), rt);
            fp.addDependency(rt.getGav());
        }
        final ArrayList cliPlugins = new ArrayList();
        ProvisioningRuntime.PluginVisitor<CliPlugin> visitor = new ProvisioningRuntime.PluginVisitor<CliPlugin>(){

            @Override
            public void visitPlugin(CliPlugin plugin) throws ProvisioningException {
                cliPlugins.add(plugin);
            }
        };
        runtime.visitePlugins(visitor, CliPlugin.class);
        final CliPlugin plugin = cliPlugins.isEmpty() ? null : (CliPlugin)cliPlugins.get(0);
        PackageGroupsBuilder pkgBuilder = new PackageGroupsBuilder();
        final FeatureSpecsBuilder specsBuilder = new FeatureSpecsBuilder();
        for (FeaturePackRuntime rt : runtime.getFeaturePacks()) {
            pkgBuilder.resetRoots();
            for (final PackageRuntime packageRuntime : rt.getPackages()) {
                pkgBuilder.buildGroups(new PackageInfo(packageRuntime, Identity.fromGav(rt.getGav(), packageRuntime.getName()), plugin), new PackageGroupsBuilder.PackageInfoBuilder(){

                    @Override
                    public PackageInfo build(Identity identity, PackageInfo parent) {
                        try {
                            FeaturePackRuntime currentRuntime = parent.getFeaturePackRuntime();
                            Identity resolvedIdentity = null;
                            PackageRuntime p = null;
                            if (identity.getOrigin().equals("")) {
                                p = currentRuntime.getPackage(identity.getName());
                                if (p == null) {
                                    for (FeaturePackConfig fpdep : currentRuntime.getSpec().getFeaturePackDeps()) {
                                        FeaturePackRuntime depRuntime;
                                        if (currentRuntime.getSpec().originOf(fpdep.getGav().toGa()) != null || (p = (depRuntime = (FeaturePackRuntime)gavs.get(Identity.buildOrigin(fpdep.getGav()))).getPackage(identity.getName())) == null) continue;
                                        resolvedIdentity = Identity.fromGav(fpdep.getGav(), identity.getName());
                                        break;
                                    }
                                } else {
                                    resolvedIdentity = Identity.fromGav(currentRuntime.getGav(), identity.getName());
                                }
                            } else {
                                FeaturePackRuntime extRt = (FeaturePackRuntime)gavs.get(identity.getOrigin());
                                if (extRt == null) {
                                    FeaturePackConfig fpdep = currentRuntime.getSpec().getFeaturePackDep(identity.getOrigin());
                                    if (fpdep != null) {
                                        resolvedIdentity = Identity.fromGav(fpdep.getGav(), identity.getName());
                                        extRt = (FeaturePackRuntime)gavs.get(resolvedIdentity.getOrigin());
                                    }
                                } else {
                                    resolvedIdentity = identity;
                                }
                                if (extRt != null) {
                                    p = extRt.getPackage(identity.getName());
                                }
                            }
                            if (p == null) {
                                throw new RuntimeException("Package " + packageRuntime.getName() + ", unknown dependency " + identity + " local is " + currentRuntime.getGav());
                            }
                            return new PackageInfo(p, resolvedIdentity, plugin);
                        }
                        catch (IOException | ProvisioningException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            fp.setPackagesRoot(Identity.buildOrigin(rt.getGav()), pkgBuilder.getPackagesRoot());
            if (!allSpecs) continue;
            Group specsRoot = specsBuilder.buildTree(session, rt.getGav(), fp.getGav(), pkgBuilder.getPackages(), allSpecs, null);
            fp.setFeatureSpecRoot(Identity.buildOrigin(rt.getGav()), specsRoot);
        }
        fp.setAllPackages(pkgBuilder.getPackages());
        final HashMap actualSet = new HashMap();
        final HashMap<ResolvedSpecId, List<FeatureInfo>> features = new HashMap<ResolvedSpecId, List<FeatureInfo>>();
        for (ProvisionedConfig provisionedConfig : runtime.getConfigs()) {
            final ConfigInfo config = new ConfigInfo(provisionedConfig.getModel(), provisionedConfig.getName());
            fp.addFinalConfig(config);
            final FeatureGroupsBuilder grpBuilder = new FeatureGroupsBuilder();
            provisionedConfig.handle(new ProvisionedConfigHandler(){

                @Override
                public void nextFeature(ProvisionedFeature feature) throws ProvisioningException {
                    HashSet<ResolvedSpecId> set = (HashSet<ResolvedSpecId>)actualSet.get(feature.getSpecId().getGav());
                    if (set == null) {
                        set = new HashSet<ResolvedSpecId>();
                        actualSet.put(feature.getSpecId().getGav(), set);
                    }
                    set.add(feature.getSpecId());
                    String fullSpecName = feature.getSpecId().getName();
                    ArrayList<String> path = new ArrayList<String>();
                    Group parent = grpBuilder.buildFeatureGroups(fullSpecName, feature.getId(), path);
                    FeatureInfo featInfo = new FeatureInfo(config, feature, path, fp.getGav());
                    ArrayList<FeatureInfo> lst = (ArrayList<FeatureInfo>)features.get(feature.getSpecId());
                    if (lst == null) {
                        lst = new ArrayList<FeatureInfo>();
                        features.put(feature.getSpecId(), lst);
                    }
                    lst.add(featInfo);
                    parent.setFeature(featInfo);
                    if (allSpecs) {
                        FeatureSpecInfo spec = specsBuilder.getAllSpecs().get(feature.getSpecId());
                        featInfo.attachSpecInfo(spec);
                        parent.setFeature(featInfo);
                    }
                }
            });
            config.setFeatureGroupRoot(grpBuilder.getRoot());
        }
        if (!allSpecs) {
            for (Map.Entry entry : actualSet.entrySet()) {
                Group specsRoot = specsBuilder.buildTree(session, (ArtifactCoords.Gav)entry.getKey(), fp.getGav(), pkgBuilder.getPackages(), false, (Set)entry.getValue());
                for (ResolvedSpecId rs : (Set)entry.getValue()) {
                    List lst = (List)features.get(rs);
                    for (FeatureInfo fi : lst) {
                        fi.attachSpecInfo(specsBuilder.getAllSpecs().get(rs));
                    }
                }
                fp.setFeatureSpecRoot(Identity.buildOrigin((ArtifactCoords.Gav)entry.getKey()), specsRoot);
            }
        }
        fp.seAllFeatureSpecs(specsBuilder.getAllSpecs());
        fp.setAllFeatures(features);
    }

    private static ProvisioningRuntime buildFullRuntime(ArtifactCoords.Gav gav, ProvisioningManager manager) throws ProvisioningException {
        FeaturePackConfig config = FeaturePackConfig.forGav(gav);
        ProvisioningConfig provisioning = ((ProvisioningConfig.Builder)ProvisioningConfig.builder().addFeaturePackDep(config)).build();
        ProvisioningRuntime runtime = manager.getRuntime(provisioning, null, Collections.emptyMap());
        return runtime;
    }
}

