/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ArtifactException;
import org.jboss.galleon.ArtifactRepositoryManager;
import org.jboss.galleon.Errors;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.diff.FileSystemDiffResult;
import org.jboss.galleon.plugin.DiffPlugin;
import org.jboss.galleon.plugin.InstallPlugin;
import org.jboss.galleon.plugin.PluginOption;
import org.jboss.galleon.plugin.ProvisioningPlugin;
import org.jboss.galleon.plugin.UpgradePlugin;
import org.jboss.galleon.repomanager.FeaturePackBuilder;
import org.jboss.galleon.repomanager.FeaturePackRepositoryManager;
import org.jboss.galleon.runtime.FeaturePackRuntime;
import org.jboss.galleon.runtime.PackageRuntime;
import org.jboss.galleon.runtime.ProvisioningRuntimeBuilder;
import org.jboss.galleon.state.FeaturePackSet;
import org.jboss.galleon.state.ProvisionedConfig;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.FeaturePackInstallException;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.PathsUtils;
import org.jboss.galleon.util.StringUtils;
import org.jboss.galleon.xml.ProvisionedStateXmlWriter;
import org.jboss.galleon.xml.ProvisioningXmlWriter;

public class ProvisioningRuntime
implements FeaturePackSet<FeaturePackRuntime>,
AutoCloseable {
    private final long startTime;
    private final ArtifactRepositoryManager artifactResolver;
    private ProvisioningConfig config;
    private Path installDir;
    private final Path stagedDir;
    private final Path workDir;
    private final Path tmpDir;
    private final Path pluginsDir;
    private final Map<ArtifactCoords.Ga, FeaturePackRuntime> fpRuntimes;
    private final Map<String, String> pluginOptions;
    private final MessageWriter messageWriter;
    private List<ProvisionedConfig> configs = Collections.emptyList();
    private FileSystemDiffResult diff = FileSystemDiffResult.empty();
    private final String operation;
    private ClassLoader pluginsClassLoader;
    private boolean closePluginsCl;

    public static void install(ProvisioningRuntime runtime) throws ProvisioningException {
        for (FeaturePackRuntime fp : runtime.fpRuntimes.values()) {
            ArtifactCoords.Gav fpGav = fp.getGav();
            runtime.messageWriter.verbose("Installing %s", fpGav);
            for (PackageRuntime pkg : fp.getPackages()) {
                Path pkgSrcDir = pkg.getContentDir();
                if (!Files.exists(pkgSrcDir, new LinkOption[0])) continue;
                try {
                    IoUtils.copy(pkgSrcDir, runtime.stagedDir);
                }
                catch (IOException e) {
                    throw new FeaturePackInstallException(Errors.packageContentCopyFailed(pkg.getName()), e);
                }
            }
        }
        runtime.executePlugins();
        try {
            ProvisioningXmlWriter.getInstance().write(runtime.config, PathsUtils.getProvisioningXml(runtime.stagedDir));
        }
        catch (IOException | XMLStreamException e) {
            throw new FeaturePackInstallException(Errors.writeFile(PathsUtils.getProvisioningXml(runtime.stagedDir)), e);
        }
        try {
            ProvisionedStateXmlWriter.getInstance().write(runtime, PathsUtils.getProvisionedStateXml(runtime.stagedDir));
        }
        catch (IOException | XMLStreamException e) {
            throw new FeaturePackInstallException(Errors.writeFile(PathsUtils.getProvisionedStateXml(runtime.stagedDir)), e);
        }
        runtime.messageWriter.verbose("Moving the provisioned installation from the staged directory to %s", runtime.installDir);
        if (Files.exists(runtime.installDir, new LinkOption[0])) {
            IoUtils.recursiveDelete(runtime.installDir);
        }
        try {
            IoUtils.copy(runtime.stagedDir, runtime.installDir);
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.copyFile(runtime.stagedDir, runtime.installDir));
        }
    }

    public static void exportToFeaturePack(ProvisioningRuntime runtime, ArtifactCoords.Gav exportGav, Path location, Path installationHome) throws ProvisioningDescriptionException, ProvisioningException, IOException {
        ProvisioningRuntime.diff(runtime, location, installationHome);
        FeaturePackRepositoryManager fpRepoManager = FeaturePackRepositoryManager.newInstance(location);
        FeaturePackBuilder fpBuilder = fpRepoManager.installer().newFeaturePack(exportGav);
        HashMap<String, FeaturePackConfig.Builder> builders = new HashMap<String, FeaturePackConfig.Builder>();
        for (FeaturePackConfig featurePackConfig : runtime.getProvisioningConfig().getFeaturePackDeps()) {
            FeaturePackConfig.Builder builder = FeaturePackConfig.builder(featurePackConfig.getGav());
            for (ConfigModel configModel : featurePackConfig.getDefinedConfigs()) {
                builder.addConfig(configModel);
            }
            builder.excludeAllPackages(featurePackConfig.getExcludedPackages());
            builder.setInheritConfigs(featurePackConfig.isInheritConfigs());
            builder.setInheritModelOnlyConfigs(featurePackConfig.isInheritModelOnlyConfigs());
            builder.setInheritPackages(featurePackConfig.isInheritPackages());
            for (Map.Entry entry : featurePackConfig.getFullModelsExcluded().entrySet()) {
                builder.excludeConfigModel((String)entry.getKey(), (Boolean)entry.getValue());
            }
            for (ConfigId configId : featurePackConfig.getIncludedConfigs()) {
                builder.includeDefaultConfig(configId);
            }
            builders.put(FeaturePackConfig.getDefaultOriginName(featurePackConfig.getGav()), builder);
        }
        runtime.exportDiffResultToFeaturePack(fpBuilder, builders, installationHome);
        for (Map.Entry entry : builders.entrySet()) {
            fpBuilder.addDependency((String)entry.getKey(), ((FeaturePackConfig.Builder)entry.getValue()).build());
        }
        try {
            Throwable throwable = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(runtime.pluginsDir);){
                for (Path file : stream) {
                    if (!Files.isRegularFile(file, new LinkOption[0])) continue;
                    fpBuilder.addPlugin(file);
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (IOException ioex) {
            throw new ProvisioningException(ioex);
        }
        fpBuilder.getInstaller().install();
        runtime.artifactResolver.install(exportGav.toArtifactCoords(), fpRepoManager.resolve(exportGav.toArtifactCoords()));
    }

    public static void diff(ProvisioningRuntime runtime, Path target, Path customizedInstallation) throws ProvisioningException, IOException {
        runtime.executeDiffPlugins(target, customizedInstallation);
    }

    public static void upgrade(ProvisioningRuntime runtime, Path customizedInstallation) throws ProvisioningException {
        runtime.executeUpgradePlugins(customizedInstallation);
        if (Files.exists(customizedInstallation, new LinkOption[0])) {
            IoUtils.recursiveDelete(customizedInstallation);
        }
        try {
            IoUtils.copy(runtime.installDir, customizedInstallation);
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.copyFile(runtime.installDir, customizedInstallation));
        }
    }

    ProvisioningRuntime(ProvisioningRuntimeBuilder builder, MessageWriter messageWriter) throws ProvisioningException {
        this.startTime = builder.startTime;
        this.artifactResolver = builder.artifactResolver;
        this.config = builder.config;
        this.fpRuntimes = builder.getFpRuntimes(this);
        this.pluginsDir = builder.pluginsDir;
        this.configs = builder.getResolvedConfigs();
        this.pluginOptions = CollectionUtils.unmodifiable(builder.pluginOptions);
        this.operation = builder.operation;
        this.workDir = builder.workDir;
        this.installDir = builder.installDir;
        this.stagedDir = this.workDir.resolve("staged");
        try {
            Files.createDirectories(this.stagedDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.mkdirs(this.stagedDir), e);
        }
        this.tmpDir = this.workDir.resolve("tmp");
        this.messageWriter = messageWriter;
    }

    private ClassLoader getPluginClassloader() throws ProvisioningException {
        if (this.pluginsClassLoader != null) {
            return this.pluginsClassLoader;
        }
        if (this.pluginsDir != null) {
            ArrayList<URL> urls = new ArrayList<URL>();
            try (Stream<Path> stream = Files.list(this.pluginsDir);){
                Iterator i = stream.iterator();
                while (i.hasNext()) {
                    urls.add(((Path)i.next()).toUri().toURL());
                }
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.readDirectory(this.pluginsDir), e);
            }
            if (!urls.isEmpty()) {
                this.closePluginsCl = true;
                Thread thread = Thread.currentThread();
                this.pluginsClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), thread.getContextClassLoader());
            } else {
                this.pluginsClassLoader = Thread.currentThread().getContextClassLoader();
            }
        } else {
            this.pluginsClassLoader = Thread.currentThread().getContextClassLoader();
        }
        return this.pluginsClassLoader;
    }

    public Path getStagedDir() {
        return this.stagedDir;
    }

    public Path getInstallDir() {
        return this.installDir;
    }

    public void setInstallDir(Path installDir) {
        this.installDir = installDir;
    }

    public ProvisioningConfig getProvisioningConfig() {
        return this.config;
    }

    @Override
    public boolean hasFeaturePacks() {
        return !this.fpRuntimes.isEmpty();
    }

    @Override
    public boolean hasFeaturePack(ArtifactCoords.Ga ga) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<FeaturePackRuntime> getFeaturePacks() {
        return this.fpRuntimes.values();
    }

    @Override
    public FeaturePackRuntime getFeaturePack(ArtifactCoords.Ga ga) {
        return this.fpRuntimes.get(ga);
    }

    public MessageWriter getMessageWriter() {
        return this.messageWriter;
    }

    public void setDiff(FileSystemDiffResult diff) {
        this.diff = diff;
    }

    public FileSystemDiffResult getDiff() {
        return this.diff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportDiffResultToFeaturePack(FeaturePackBuilder fpBuilder, Map<String, FeaturePackConfig.Builder> builders, Path installationHome) throws ProvisioningException {
        ClassLoader pluginClassLoader = this.getPluginClassloader();
        if (pluginClassLoader != null) {
            Thread thread = Thread.currentThread();
            ClassLoader ocl = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(pluginClassLoader);
                this.diff.toFeaturePack(fpBuilder, builders, this, installationHome);
            }
            finally {
                thread.setContextClassLoader(ocl);
            }
        }
    }

    public String getOperation() {
        return this.operation;
    }

    public Path getResource(String ... path) {
        if (path.length == 0) {
            throw new IllegalArgumentException("Resource path is null");
        }
        if (path.length == 1) {
            return this.workDir.resolve("resources").resolve(path[0]);
        }
        Path p = this.workDir.resolve("resources");
        for (String name : path) {
            p = p.resolve(name);
        }
        return p;
    }

    public Path getTmpPath(String ... path) {
        if (path.length == 0) {
            return this.tmpDir;
        }
        if (path.length == 1) {
            return this.tmpDir.resolve(path[0]);
        }
        Path p = this.tmpDir;
        for (String name : path) {
            p = p.resolve(name);
        }
        return p;
    }

    public boolean isOptionSet(PluginOption option) throws ProvisioningException {
        if (!this.pluginOptions.containsKey(option.getName())) {
            return false;
        }
        if (option.isAcceptsValue() || this.pluginOptions.get(option.getName()) == null) {
            return true;
        }
        throw new ProvisioningException("Plugin option " + option.getName() + " does expect value but is set to " + this.pluginOptions.get(option.getName()));
    }

    public String getOptionValue(PluginOption option) throws ProvisioningException {
        return this.getOptionValue(option, null);
    }

    public String getOptionValue(PluginOption option, String defaultValue) throws ProvisioningException {
        String value = this.pluginOptions.get(option.getName());
        if (value == null) {
            if (defaultValue != null) {
                return defaultValue;
            }
            defaultValue = option.getDefaultValue();
            if (defaultValue != null) {
                return defaultValue;
            }
            if (option.isRequired()) {
                throw new ProvisioningException("Required plugin option " + option.getName() + " has not been provided");
            }
            return null;
        }
        if (!option.isAcceptsValue()) {
            throw new ProvisioningException("Plugin option " + option.getName() + " is set to " + value + " but does not accept values");
        }
        if (!option.getValueSet().isEmpty() && !option.getValueSet().contains(value)) {
            StringBuilder buf = new StringBuilder();
            buf.append("Plugin option ").append(option.getName()).append(" is set to ").append(value).append(" but expects one of ");
            StringUtils.append(buf, option.getValueSet());
            throw new ProvisioningException(buf.toString());
        }
        return value;
    }

    public Map<String, String> getPluginOptions() {
        return this.pluginOptions;
    }

    public Path resolveArtifact(ArtifactCoords coords) throws ArtifactException {
        return this.artifactResolver.resolve(coords);
    }

    @Override
    public boolean hasConfigs() {
        return !this.configs.isEmpty();
    }

    @Override
    public List<ProvisionedConfig> getConfigs() {
        return this.configs;
    }

    private void executePlugins() throws ProvisioningException {
        PluginVisitor<InstallPlugin> visitor = new PluginVisitor<InstallPlugin>(){

            @Override
            public void visitPlugin(InstallPlugin plugin) throws ProvisioningException {
                plugin.postInstall(ProvisioningRuntime.this);
            }
        };
        this.visitePlugins(visitor, InstallPlugin.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ProvisioningPlugin> void visitePlugins(PluginVisitor<T> visitor, Class<T> clazz) throws ProvisioningException {
        ClassLoader pluginClassLoader = this.getPluginClassloader();
        if (pluginClassLoader != null) {
            Thread thread = Thread.currentThread();
            ServiceLoader<T> pluginLoader = ServiceLoader.load(clazz, pluginClassLoader);
            Iterator<T> pluginIterator = pluginLoader.iterator();
            if (pluginIterator.hasNext()) {
                ClassLoader ocl = thread.getContextClassLoader();
                try {
                    thread.setContextClassLoader(pluginClassLoader);
                    ProvisioningPlugin plugin = (ProvisioningPlugin)pluginIterator.next();
                    visitor.visitPlugin(plugin);
                    while (pluginIterator.hasNext()) {
                        visitor.visitPlugin((ProvisioningPlugin)pluginIterator.next());
                    }
                }
                finally {
                    thread.setContextClassLoader(ocl);
                }
            }
        }
    }

    @Override
    public void close() {
        block3: {
            if (this.closePluginsCl) {
                try {
                    ((URLClassLoader)this.pluginsClassLoader).close();
                }
                catch (IOException e) {
                    if (!this.messageWriter.isVerboseEnabled()) break block3;
                    this.messageWriter.verbose("Failed to close plugins classloader");
                    e.printStackTrace();
                }
            }
        }
        IoUtils.recursiveDelete(this.workDir);
        long time = System.currentTimeMillis() - this.startTime;
        long seconds = time / 1000L;
        this.messageWriter.print("Done in %d.%d seconds", seconds, time - seconds * 1000L);
    }

    private void executeDiffPlugins(final Path target, final Path customizedInstallation) throws ProvisioningException, IOException {
        PluginVisitor<DiffPlugin> visitor = new PluginVisitor<DiffPlugin>(){

            @Override
            public void visitPlugin(DiffPlugin plugin) throws ProvisioningException {
                plugin.computeDiff(ProvisioningRuntime.this, customizedInstallation, target);
            }
        };
        this.visitePlugins(visitor, DiffPlugin.class);
    }

    private void executeUpgradePlugins(final Path customizedInstallation) throws ProvisioningException {
        PluginVisitor<UpgradePlugin> visitor = new PluginVisitor<UpgradePlugin>(){

            @Override
            public void visitPlugin(UpgradePlugin plugin) throws ProvisioningException {
                plugin.upgrade(ProvisioningRuntime.this, customizedInstallation);
            }
        };
    }

    public static interface PluginVisitor<T extends ProvisioningPlugin> {
        public void visitPlugin(T var1) throws ProvisioningException;
    }
}

