/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.impl.internal.ParsedOption;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.aesh.readline.AeshContext;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ArtifactException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.GavCompleter;
import org.jboss.galleon.cli.PmOptionActivator;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.StreamCompleter;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.cli.model.FeatureContainers;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.runtime.ProvisioningRuntime;

public abstract class AbstractFeaturePackCommand
extends PmSessionCommand {
    public static final String DIR_OPTION_NAME = "dir";
    public static final String FP_OPTION_NAME = "fp";
    public static final String VERBOSE_OPTION_NAME = "verbose";
    @Option(name="dir", completer=FileOptionCompleter.class, required=false, activator=DirActivator.class, description="Installation directory.")
    protected String targetDirArg;
    @Argument(completer=StreamCompleter.class, activator=StreamNameActivator.class)
    protected String streamName;
    @Option(name="fp", completer=GavCompleter.class, activator=FPGavActivator.class)
    protected String fpCoords;

    protected ArtifactCoords.Gav getGav(PmSession session) throws CommandExecutionException {
        String coords;
        if (session.getState() != null) {
            return null;
        }
        if (this.fpCoords == null && this.streamName == null) {
            throw new CommandExecutionException("Stream name or feature-pack coordinates must be set");
        }
        if (this.fpCoords != null && this.streamName != null) {
            throw new CommandExecutionException("Only one of stream name or feature-pack coordinates must be set");
        }
        if (this.streamName != null) {
            try {
                coords = session.getUniverses().resolveStream(this.streamName).toString();
            }
            catch (ArtifactException ex) {
                throw new CommandExecutionException("Stream resolution failed", ex);
            }
        } else {
            coords = this.fpCoords;
        }
        return ArtifactCoords.newGav(coords);
    }

    protected String getName() {
        if (this.streamName != null) {
            return this.streamName;
        }
        if (this.targetDirArg != null) {
            return Paths.get(this.targetDirArg, new String[0]).getFileName().toString();
        }
        if (this.fpCoords != null) {
            return this.fpCoords;
        }
        return null;
    }

    protected ProvisioningManager getManager(PmSession session, AeshContext ctx) {
        ProvisioningManager.Builder builder = ProvisioningManager.builder().setArtifactResolver(session.getArtifactResolver());
        builder.setInstallationHome(this.getTargetDir(ctx));
        return builder.build();
    }

    protected Path getTargetDir(AeshContext context) {
        Path workDir = PmSession.getWorkDir(context);
        return this.targetDirArg == null ? PmSession.getWorkDir(context) : workDir.resolve(this.targetDirArg);
    }

    public FeatureContainer getFeatureContainer(PmSession session, AeshContext ctx) throws ProvisioningException, Exception {
        FeatureContainer container;
        if (session.getContainer() != null) {
            return session.getContainer();
        }
        ArtifactCoords.Gav gav = null;
        try {
            gav = this.getGav(session);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ProvisioningManager manager = this.getManager(session, ctx);
        if (gav != null) {
            container = FeatureContainers.fromFeaturePackGav(session, manager, gav, this.streamName);
        } else {
            if (manager.getProvisionedState() == null) {
                throw new CommandExecutionException("Specified directory doesn't contain an installation");
            }
            ProvisioningConfig config = manager.getProvisioningConfig();
            ProvisioningRuntime runtime = manager.getRuntime(config, null, Collections.emptyMap());
            container = FeatureContainers.fromProvisioningRuntime(session, manager, runtime);
        }
        return container;
    }

    public static class FPGavActivator
    extends PmOptionActivator {
        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            if (this.getPmSession().getContainer() != null) {
                return false;
            }
            ParsedOption opt = parsedCommand.findLongOptionNoActivatorCheck(AbstractFeaturePackCommand.DIR_OPTION_NAME);
            if (opt != null && opt.value() != null) {
                return false;
            }
            String argumentValue = parsedCommand.argument().value();
            return argumentValue == null;
        }
    }

    public static class StreamNameActivator
    extends PmOptionActivator {
        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            if (this.getPmSession().getContainer() != null) {
                return false;
            }
            ParsedOption opt = parsedCommand.findLongOptionNoActivatorCheck(AbstractFeaturePackCommand.DIR_OPTION_NAME);
            if (opt != null && opt.value() != null) {
                return false;
            }
            opt = parsedCommand.findLongOptionNoActivatorCheck(AbstractFeaturePackCommand.FP_OPTION_NAME);
            return opt == null || opt.value() == null;
        }
    }

    public static class DirActivator
    extends PmOptionActivator {
        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            if (this.getPmSession().getContainer() != null) {
                return false;
            }
            String argumentValue = parsedCommand.argument().value();
            if (argumentValue != null) {
                return false;
            }
            ParsedOption opt = parsedCommand.findLongOptionNoActivatorCheck(AbstractFeaturePackCommand.FP_OPTION_NAME);
            return opt == null || opt.value() == null;
        }
    }
}

