/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ArtifactException;
import org.jboss.galleon.ArtifactRepositoryManager;
import org.jboss.galleon.cli.Util;
import org.jboss.galleon.cli.config.mvn.MavenConfig;
import org.jboss.galleon.cli.config.mvn.MavenSettings;
import org.jboss.galleon.maven.plugin.FpMavenErrors;

public class MavenArtifactRepositoryManager
implements ArtifactRepositoryManager {
    public static final String DEFAULT_REPOSITORY_TYPE = "default";
    private final RepositorySystem repoSystem = Util.newRepositorySystem();
    private final MavenConfig config;
    private final RepositoryListener listener;
    private MavenSettings mavenSettings;
    private boolean commandStarted;

    MavenArtifactRepositoryManager(MavenConfig config, RepositoryListener listener) {
        this.config = config;
        this.listener = listener;
    }

    void commandStart() {
        this.commandStarted = true;
        this.mavenSettings = null;
    }

    void commandEnd() {
        this.commandStarted = false;
    }

    private MavenSettings getSettings() throws ArtifactException {
        if (this.commandStarted) {
            if (this.mavenSettings == null) {
                this.mavenSettings = this.config.buildSettings(this.repoSystem, this.listener);
            }
        } else {
            this.mavenSettings = this.config.buildSettings(this.repoSystem, this.listener);
        }
        return this.mavenSettings;
    }

    @Override
    public Path resolve(ArtifactCoords coords) throws ArtifactException {
        ArtifactResult result;
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact(new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getExtension(), coords.getVersion()));
        request.setRepositories(this.getSettings().getRepositories());
        try {
            result = this.repoSystem.resolveArtifact(this.getSettings().getSession(), request);
        }
        catch (ArtifactResolutionException e) {
            throw new ArtifactException(FpMavenErrors.artifactResolution(coords), e);
        }
        if (!result.isResolved()) {
            throw new ArtifactException(FpMavenErrors.artifactResolution(coords));
        }
        if (result.isMissing()) {
            throw new ArtifactException(FpMavenErrors.artifactMissing(coords));
        }
        return Paths.get(result.getArtifact().getFile().toURI());
    }

    @Override
    public void install(ArtifactCoords coords, Path file) throws ArtifactException {
        InstallRequest request = new InstallRequest();
        request.addArtifact(new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getExtension(), coords.getVersion(), Collections.emptyMap(), file.toFile()));
        try {
            this.repoSystem.install(this.getSettings().getSession(), request);
        }
        catch (InstallationException ex) {
            Logger.getLogger(MavenArtifactRepositoryManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void deploy(ArtifactCoords coords, Path file) throws ArtifactException {
        DeployRequest request = new DeployRequest();
        request.addArtifact(new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getExtension(), coords.getVersion(), Collections.emptyMap(), file.toFile()));
        try {
            this.repoSystem.deploy(this.getSettings().getSession(), request);
        }
        catch (DeploymentException ex) {
            Logger.getLogger(MavenArtifactRepositoryManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public String getHighestVersion(ArtifactCoords coords, String range) throws ArtifactException {
        VersionRangeResult rangeResult;
        DefaultArtifact artifact = new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getExtension(), range);
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact(artifact);
        rangeRequest.setRepositories(this.getSettings().getRepositories());
        try {
            rangeResult = this.repoSystem.resolveVersionRange(this.getSettings().getSession(), rangeRequest);
        }
        catch (VersionRangeResolutionException ex) {
            throw new ArtifactException(ex.getLocalizedMessage(), ex);
        }
        String version = null;
        if (rangeResult != null && rangeResult.getHighestVersion() != null) {
            version = rangeResult.getHighestVersion().toString();
        }
        if (version == null) {
            throw new ArtifactException("No version retrieved for " + coords);
        }
        return version;
    }
}

