/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.aesh.command.activator.CommandActivator;
import org.aesh.command.activator.CommandActivatorProvider;
import org.aesh.command.activator.OptionActivator;
import org.aesh.command.activator.OptionActivatorProvider;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.completer.CompleterInvocationProvider;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.invocation.CommandInvocationProvider;
import org.aesh.readline.AeshContext;
import org.aesh.readline.Prompt;
import org.aesh.utils.Config;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ArtifactException;
import org.jboss.galleon.ArtifactRepositoryManager;
import org.jboss.galleon.cli.MavenArtifactRepositoryManager;
import org.jboss.galleon.cli.PmCommandActivator;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.PmOptionActivator;
import org.jboss.galleon.cli.Universe;
import org.jboss.galleon.cli.Universes;
import org.jboss.galleon.cli.config.Configuration;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.cli.model.state.State;

public class PmSession
implements CommandInvocationProvider<PmCommandInvocation>,
CompleterInvocationProvider<PmCompleterInvocation>,
CommandActivatorProvider,
OptionActivatorProvider<OptionActivator> {
    private PrintStream out;
    private PrintStream err;
    private final Configuration config;
    private final Universes universes;
    private State state;
    private FeatureContainer exploredContainer;
    private String currentPath;
    private final MavenArtifactRepositoryManager maven;
    private final MavenListener mavenListener;

    public PmSession(Configuration config) throws Exception {
        this.config = config;
        this.mavenListener = new MavenListener();
        this.maven = new MavenArtifactRepositoryManager(config.getMavenConfig(), this.mavenListener);
        this.universes = Universes.buildUniverses(config, this.maven);
    }

    public void commandStart() {
        this.maven.commandStart();
    }

    public void commandEnd() {
        this.maven.commandEnd();
    }

    public void setState(State session) {
        this.state = session;
    }

    public State getState() {
        return this.state;
    }

    public void setExploredContainer(FeatureContainer exploredContainer) {
        this.exploredContainer = exploredContainer;
    }

    public FeatureContainer getExploredContainer() {
        return this.exploredContainer;
    }

    public FeatureContainer getContainer() {
        if (this.state != null) {
            return this.state.getContainer();
        }
        if (this.exploredContainer != null) {
            return this.exploredContainer;
        }
        return null;
    }

    public String getCurrentPath() {
        if (this.state != null) {
            return this.state.getPath();
        }
        if (this.currentPath != null) {
            return this.currentPath;
        }
        return null;
    }

    public void setCurrentPath(String currentPath) {
        if (this.state != null) {
            this.state.setPath(currentPath);
        }
        if (currentPath != null) {
            this.currentPath = currentPath;
        }
    }

    public void println(String txt) {
        this.out.print(txt + Config.getLineSeparator());
    }

    public void print(String txt) {
        this.out.print(txt);
    }

    public Configuration getPmConfiguration() {
        return this.config;
    }

    public Universes getUniverses() {
        return this.universes;
    }

    public ArtifactRepositoryManager getArtifactResolver() {
        return this.maven;
    }

    public boolean hasPopulatedUniverse() {
        for (Universe u : this.universes.getUniverses()) {
            if (u.getStreamLocations().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static Prompt buildPrompt(AeshContext aeshCtx) {
        return PmSession.buildPrompt(aeshCtx.getCurrentWorkingDirectory().getName());
    }

    public static Prompt buildPrompt(String name) {
        return new Prompt('[' + name + "]$ ");
    }

    public static Path getWorkDir(AeshContext aeshCtx) {
        return Paths.get(aeshCtx.getCurrentWorkingDirectory().getAbsolutePath(), new String[0]);
    }

    @Override
    public PmCommandInvocation enhanceCommandInvocation(CommandInvocation commandInvocation) {
        return new PmCommandInvocation(this, this.out, this.err, commandInvocation);
    }

    void setOut(PrintStream out) {
        this.out = out;
    }

    void setErr(PrintStream err) {
        this.err = err;
    }

    @Override
    public PmCompleterInvocation enhanceCompleterInvocation(CompleterInvocation completerInvocation) {
        return new PmCompleterInvocation(completerInvocation, this);
    }

    public CommandActivator enhanceCommandActivator(CommandActivator ca) {
        if (ca instanceof PmCommandActivator) {
            ((PmCommandActivator)ca).setPmSession(this);
        }
        return ca;
    }

    @Override
    public OptionActivator enhanceOptionActivator(OptionActivator oa) {
        if (oa instanceof PmOptionActivator) {
            ((PmOptionActivator)oa).setPmSession(this);
        }
        return oa;
    }

    public boolean existsInLocalRepository(ArtifactCoords.Gav gav) {
        Path local = this.getPmConfiguration().getMavenConfig().getLocalRepository();
        String grp = gav.getGroupId().replaceAll("\\.", "/");
        String art = gav.getArtifactId().replaceAll("\\.", "/");
        String vers = gav.getVersion();
        return Files.exists(Paths.get(local.toString(), grp, art, vers), new LinkOption[0]);
    }

    public void downloadFp(ArtifactCoords.Gav gav) throws ArtifactException {
        this.getArtifactResolver().resolve(gav.toArtifactCoords());
    }

    public void enableMavenTrace(boolean b) {
        this.mavenListener.setActive(b);
    }

    private class MavenListener
    implements RepositoryListener {
        private static final String MAVEN = "[MAVEN] ";
        private boolean active;

        private MavenListener() {
        }

        void setActive(boolean active) {
            this.active = active;
        }

        @Override
        public void artifactDownloaded(RepositoryEvent re) {
            if (this.active && re != null) {
                String artifact = re.getArtifact().getGroupId() + ":" + re.getArtifact().getArtifactId() + ":" + re.getArtifact().getVersion() + ":" + re.getArtifact().getExtension();
                if (re.getException() == null) {
                    PmSession.this.println("[MAVEN] downloaded " + artifact + " from " + re.getRepository().getId());
                } else if (re.getException() instanceof ArtifactNotFoundException) {
                    PmSession.this.println("[MAVEN] artifact " + artifact + " not found in " + re.getRepository().getId());
                } else {
                    PmSession.this.println(MAVEN + re.getException().getLocalizedMessage() + " while downloading artifact " + artifact);
                }
            }
        }

        @Override
        public void artifactDownloading(RepositoryEvent re) {
            if (this.active && re != null) {
                PmSession.this.println("[MAVEN] attempting to download " + re.getArtifact().getGroupId() + ":" + re.getArtifact().getArtifactId() + ":" + re.getArtifact().getVersion() + ":" + re.getArtifact().getExtension() + (re.getRepository() != null ? " from " + re.getRepository().getId() : ""));
            }
        }

        @Override
        public void artifactDescriptorInvalid(RepositoryEvent re) {
        }

        @Override
        public void artifactDescriptorMissing(RepositoryEvent re) {
        }

        @Override
        public void metadataInvalid(RepositoryEvent re) {
        }

        @Override
        public void artifactResolving(RepositoryEvent re) {
        }

        @Override
        public void artifactResolved(RepositoryEvent re) {
        }

        @Override
        public void metadataResolving(RepositoryEvent re) {
        }

        @Override
        public void metadataResolved(RepositoryEvent re) {
        }

        @Override
        public void metadataDownloading(RepositoryEvent re) {
        }

        @Override
        public void metadataDownloaded(RepositoryEvent re) {
        }

        @Override
        public void artifactInstalling(RepositoryEvent re) {
        }

        @Override
        public void artifactInstalled(RepositoryEvent re) {
        }

        @Override
        public void metadataInstalling(RepositoryEvent re) {
        }

        @Override
        public void metadataInstalled(RepositoryEvent re) {
        }

        @Override
        public void artifactDeploying(RepositoryEvent re) {
        }

        @Override
        public void artifactDeployed(RepositoryEvent re) {
        }

        @Override
        public void metadataDeploying(RepositoryEvent re) {
        }

        @Override
        public void metadataDeployed(RepositoryEvent re) {
        }
    }
}

