/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ArtifactException;
import org.jboss.galleon.ArtifactRepositoryManager;
import org.jboss.galleon.cli.Universe;
import org.jboss.galleon.cli.UniverseLocation;
import org.jboss.galleon.cli.config.Configuration;
import org.jboss.galleon.cli.config.mvn.MavenConfig;

public class Universes
implements MavenConfig.MavenChangeListener {
    private final List<Universe> universes = new ArrayList<Universe>();
    private final List<UniverseLocation> locations;
    private final ArtifactRepositoryManager manager;

    private Universes(List<UniverseLocation> locations, ArtifactRepositoryManager manager) {
        this.locations = locations;
        this.manager = manager;
        this.addUniverses();
    }

    private void addUniverses() {
        try {
            for (UniverseLocation loc : this.locations) {
                this.addUniverse(Universe.buildUniverse(this.manager, loc));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void configurationChanged(MavenConfig config) throws XMLStreamException, IOException {
        this.universes.clear();
        this.addUniverses();
    }

    public List<Universe> getUniverses() {
        return Collections.unmodifiableList(this.universes);
    }

    public ArtifactCoords resolveStream(String name) throws ArtifactException {
        for (Universe universe : this.universes) {
            ArtifactCoords coords = universe.resolveStream(name);
            if (coords == null) continue;
            return coords;
        }
        throw new ArtifactException("Can't resolve stream " + name);
    }

    private void addUniverse(Universe universe) {
        this.universes.add(universe);
    }

    static Universes buildUniverses(Configuration config, ArtifactRepositoryManager manager) throws Exception {
        Universes universes = new Universes(config.getUniversesLocations(), manager);
        config.getMavenConfig().addListener(universes);
        return universes;
    }
}

