/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import java.io.InputStream;
import java.nio.file.Path;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.jboss.galleon.cli.CommandExecutionException;

public class Util {
    static InputStream getResourceStream(String resource) throws CommandExecutionException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream pomIs = cl.getResourceAsStream(resource);
        if (pomIs == null) {
            throw new CommandExecutionException(resource + " not found");
        }
        return pomIs;
    }

    public static RepositorySystemSession newRepositorySession(RepositorySystem repoSystem, Path path, RepositoryListener listener, ProxySelector proxySelector, boolean offline) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setRepositoryListener(listener);
        session.setOffline(offline);
        LocalRepository localRepo = new LocalRepository(path.toString());
        session.setLocalRepositoryManager(repoSystem.newLocalRepositoryManager(session, localRepo));
        if (proxySelector != null) {
            session.setProxySelector(proxySelector);
        }
        return session;
    }

    static RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return locator.getService(RepositorySystem.class);
    }
}

