/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.mvn;

import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ArtifactException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.GavCompleter;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.StreamCompleter;
import org.jboss.galleon.cli.cmd.plugin.AbstractPluginsCommand;
import org.jboss.galleon.cli.cmd.state.AbstractFPProvisioningCommand;

@CommandDefinition(name="fetch-feature-pack", description="download a feature-pack to the local repository")
public class FetchArtifact
extends PmSessionCommand {
    @Argument(completer=StreamCompleter.class, activator=AbstractPluginsCommand.StreamNameActivator.class)
    protected String streamName;
    @Option(name="fp", completer=GavCompleter.class, activator=AbstractPluginsCommand.FPActivator.class)
    protected String fpCoords;
    @Option(hasValue=false)
    private boolean verbose;

    @Override
    protected void runCommand(PmCommandInvocation session) throws CommandExecutionException {
        try {
            ArtifactCoords.Gav gav = AbstractFPProvisioningCommand.getGav(this.fpCoords, this.streamName, session.getPmSession());
            if (this.verbose) {
                session.getPmSession().enableMavenTrace(true);
            }
            try {
                session.getPmSession().getArtifactResolver().resolve(gav.toArtifactCoords());
                session.println("artifact installed in local mvn repository " + session.getPmSession().getPmConfiguration().getMavenConfig().getLocalRepository());
            }
            finally {
                session.getPmSession().enableMavenTrace(false);
            }
        }
        catch (ArtifactException ex) {
            throw new CommandExecutionException(ex);
        }
    }
}

