/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.mvn;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Argument;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.AbstractCompleter;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.PmSessionCommand;

@CommandDefinition(name="remove-repository", description="Remove a maven repo")
public class MavenRemoveRepository
extends PmSessionCommand {
    @Argument(description="Maven remote repository name", required=true, completer=RepositoriesCompleter.class)
    private String name;

    @Override
    protected void runCommand(PmCommandInvocation session) throws CommandExecutionException {
        try {
            session.getPmSession().getPmConfiguration().getMavenConfig().removeRemoteRepository(this.name);
        }
        catch (IOException | XMLStreamException | ProvisioningException ex) {
            throw new CommandExecutionException(ex);
        }
    }

    public static class RepositoriesCompleter
    extends AbstractCompleter {
        @Override
        protected List<String> getItems(PmCompleterInvocation completerInvocation) {
            ArrayList<String> names = new ArrayList<String>();
            names.addAll(completerInvocation.getPmSession().getPmConfiguration().getMavenConfig().getRemoteRepositoryNames());
            return names;
        }
    }
}

