/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.plugin;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aesh.command.activator.OptionActivator;
import org.aesh.command.impl.internal.OptionType;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.impl.internal.ParsedOption;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.internal.ProcessedOptionBuilder;
import org.aesh.command.parser.OptionParserException;
import org.aesh.readline.AeshContext;
import org.aesh.utils.Config;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ArtifactException;
import org.jboss.galleon.DefaultMessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.GavCompleter;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.StreamCompleter;
import org.jboss.galleon.cli.cmd.AbstractDynamicCommand;
import org.jboss.galleon.cli.model.state.State;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.plugin.PluginOption;
import org.jboss.galleon.runtime.ProvisioningRuntime;

public abstract class AbstractPluginsCommand
extends AbstractDynamicCommand {
    private static final String FP_NAME = "fp";
    private AeshContext ctx;

    public AbstractPluginsCommand(PmSession pmSession) {
        super(pmSession, true, true);
    }

    public void setAeshContext(AeshContext ctx) {
        this.ctx = ctx;
    }

    protected boolean isVerbose() {
        return this.contains("verbose");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runCommand(PmCommandInvocation session, Map<String, String> options) throws CommandExecutionException {
        ArtifactCoords.Gav gav = this.getGav(this.pmSession);
        if (this.isVerbose()) {
            session.getPmSession().enableMavenTrace(true);
        }
        try {
            this.runCommand(session, options, gav);
        }
        finally {
            session.getPmSession().enableMavenTrace(false);
        }
    }

    protected abstract void runCommand(PmCommandInvocation var1, Map<String, String> var2, ArtifactCoords.Gav var3) throws CommandExecutionException;

    @Override
    protected void doValidateOptions() throws CommandExecutionException {
        this.getId(this.pmSession);
    }

    @Override
    protected List<ProcessedOption> getStaticOptions() throws OptionParserException {
        ArrayList<ProcessedOption> options = new ArrayList<ProcessedOption>();
        options.add(ProcessedOptionBuilder.builder().name("org.jboss.pm.tool.arg").hasValue(true).description("stream name").type(String.class).optionType(OptionType.ARGUMENT).completer(StreamCompleter.class).activator(StreamNameActivator.class).build());
        options.add(ProcessedOptionBuilder.builder().name(FP_NAME).hasValue(true).description("Feature-pack maven gav").type(String.class).optionType(OptionType.NORMAL).completer(GavCompleter.class).activator(FPActivator.class).build());
        options.add(ProcessedOptionBuilder.builder().name("verbose").hasValue(false).type(Boolean.class).description("Whether or not the output should be verbose").optionType(OptionType.BOOLEAN).build());
        options.addAll(this.getOtherOptions());
        return options;
    }

    protected List<ProcessedOption> getOtherOptions() throws OptionParserException {
        return Collections.emptyList();
    }

    @Override
    protected List<AbstractDynamicCommand.DynamicOption> getDynamicOptions(State state, String id) throws Exception {
        ArrayList<AbstractDynamicCommand.DynamicOption> options = new ArrayList<AbstractDynamicCommand.DynamicOption>();
        ProvisioningManager manager = this.getManager(this.ctx);
        ArtifactCoords.Gav gav = ArtifactCoords.newGav(id);
        this.checkLocalArtifact(gav);
        FeaturePackConfig config = FeaturePackConfig.forGav(gav);
        ProvisioningConfig provisioning = ((ProvisioningConfig.Builder)ProvisioningConfig.builder().addFeaturePackDep(config)).build();
        ProvisioningRuntime runtime = manager.getRuntime(provisioning, null, Collections.emptyMap());
        Set<PluginOption> pluginOptions = this.getPluginOptions(runtime);
        for (PluginOption opt : pluginOptions) {
            AbstractDynamicCommand.DynamicOption dynOption = new AbstractDynamicCommand.DynamicOption(opt.getName(), opt.isRequired(), opt.isAcceptsValue());
            options.add(dynOption);
        }
        return options;
    }

    protected abstract Set<PluginOption> getPluginOptions(ProvisioningRuntime var1) throws ProvisioningException;

    protected abstract Path getInstallationHome(AeshContext var1);

    private ProvisioningManager getManager(AeshContext ctx) {
        ProvisioningManager manager = ProvisioningManager.builder().setArtifactResolver(this.pmSession.getArtifactResolver()).setInstallationHome(this.getInstallationHome(ctx)).build();
        return manager;
    }

    protected ProvisioningManager getManager(PmCommandInvocation session) {
        return ProvisioningManager.builder().setArtifactResolver(session.getPmSession().getArtifactResolver()).setInstallationHome(this.getInstallationHome(session.getAeshContext())).setMessageWriter(new DefaultMessageWriter(session.getOut(), session.getErr(), this.isVerbose())).build();
    }

    @Override
    protected String getId(PmSession session) throws CommandExecutionException {
        String streamName = (String)this.getValue("org.jboss.pm.tool.arg");
        String fpCoords = (String)this.getValue(FP_NAME);
        if (fpCoords == null && streamName == null) {
            String val = this.getArgumentValue();
            if (val == null) {
                val = this.getOptionValue(FP_NAME);
                return val;
            }
            streamName = val;
        }
        String coords = null;
        if (streamName != null) {
            try {
                coords = session.getUniverses().resolveStream(streamName).toString();
            }
            catch (ArtifactException ex) {
                throw new CommandExecutionException(ex);
            }
        } else {
            coords = fpCoords;
        }
        return coords;
    }

    protected ArtifactCoords.Gav getGav(PmSession session) throws CommandExecutionException {
        String id = this.getId(session);
        if (id == null) {
            throw new CommandExecutionException("Stream resolution failed");
        }
        return ArtifactCoords.newGav(id);
    }

    private void checkLocalArtifact(ArtifactCoords.Gav gav) throws CommandExecutionException {
        if (!this.pmSession.existsInLocalRepository(gav)) {
            try {
                this.pmSession.println(Config.getLineSeparator() + "retrieving feature-pack content from remote repository...");
                this.pmSession.downloadFp(gav);
            }
            catch (ArtifactException ex) {
                throw new CommandExecutionException(ex);
            }
        }
    }

    public static class StreamNameActivator
    implements OptionActivator {
        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            ParsedOption opt = parsedCommand.findLongOptionNoActivatorCheck(AbstractPluginsCommand.FP_NAME);
            return opt == null || opt.value() == null;
        }
    }

    public static class FPActivator
    implements OptionActivator {
        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            String argumentValue = parsedCommand.argument().value();
            return argumentValue == null;
        }
    }
}

