/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.plugin;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.impl.internal.OptionType;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.internal.ProcessedOptionBuilder;
import org.aesh.command.parser.OptionParserException;
import org.aesh.readline.AeshContext;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandActivator;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.plugin.AbstractPluginsCommand;
import org.jboss.galleon.cli.cmd.state.NoStateCommandActivator;
import org.jboss.galleon.plugin.DiffPlugin;
import org.jboss.galleon.plugin.PluginOption;
import org.jboss.galleon.runtime.ProvisioningRuntime;

public class DiffCommand
extends AbstractPluginsCommand {
    private static final String SRC_NAME = "src";
    private static final String TARGET_NAME = "target";

    public DiffCommand(PmSession pmSession) {
        super(pmSession);
    }

    @Override
    protected void runCommand(PmCommandInvocation session, Map<String, String> options, ArtifactCoords.Gav gav) throws CommandExecutionException {
        try {
            Path targetDirectory = this.toPath((String)this.getValue(TARGET_NAME), session.getAeshContext());
            this.getManager(session).exportConfigurationChanges(targetDirectory, gav, options);
        }
        catch (Exception ex) {
            throw new CommandExecutionException(ex);
        }
    }

    @Override
    protected Set<PluginOption> getPluginOptions(ProvisioningRuntime runtime) throws ProvisioningException {
        final HashSet<PluginOption> pluginOptions = new HashSet<PluginOption>();
        ProvisioningRuntime.PluginVisitor<DiffPlugin> visitor = new ProvisioningRuntime.PluginVisitor<DiffPlugin>(){

            @Override
            public void visitPlugin(DiffPlugin plugin) throws ProvisioningException {
                pluginOptions.addAll(plugin.getOptions().values());
            }
        };
        runtime.visitPlugins(visitor, DiffPlugin.class);
        return pluginOptions;
    }

    @Override
    protected List<ProcessedOption> getOtherOptions() throws OptionParserException {
        ArrayList<ProcessedOption> options = new ArrayList<ProcessedOption>();
        ProcessedOption srcDir = ProcessedOptionBuilder.builder().name(SRC_NAME).hasValue(true).type(String.class).optionType(OptionType.NORMAL).description("Customized source installation directory.").completer(FileOptionCompleter.class).build();
        options.add(srcDir);
        ProcessedOption targetDir = ProcessedOptionBuilder.builder().name(TARGET_NAME).hasValue(true).type(String.class).optionType(OptionType.NORMAL).description("Directory to save the feature pack to.").completer(FileOptionCompleter.class).build();
        options.add(targetDir);
        return options;
    }

    @Override
    protected String getName() {
        return "diff";
    }

    @Override
    protected String getDescription() {
        return "Saves current provisioned configuration changes into a feature pack.";
    }

    @Override
    protected Path getInstallationHome(AeshContext context) {
        String srcPath = (String)this.getValue(SRC_NAME);
        return this.toPath(srcPath, context);
    }

    private Path toPath(String value, AeshContext context) {
        Path workDir = PmSession.getWorkDir(context);
        return value == null ? PmSession.getWorkDir(context) : workDir.resolve(value);
    }

    @Override
    protected PmCommandActivator getActivator() {
        return new NoStateCommandActivator();
    }
}

