/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state;

import java.io.IOException;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ArtifactException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.GavCompleter;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.StreamCompleter;
import org.jboss.galleon.cli.cmd.plugin.AbstractPluginsCommand;
import org.jboss.galleon.cli.cmd.state.AbstractStateCommand;
import org.jboss.galleon.cli.model.state.State;

public abstract class AbstractFPProvisioningCommand
extends AbstractStateCommand {
    @Argument(completer=StreamCompleter.class, activator=AbstractPluginsCommand.StreamNameActivator.class)
    protected String streamName;
    @Option(name="fp", completer=GavCompleter.class, activator=AbstractPluginsCommand.FPActivator.class)
    protected String fpCoords;

    @Override
    protected void runCommand(PmCommandInvocation invoc, State session) throws IOException, ProvisioningException, CommandExecutionException {
        ArtifactCoords.Gav gav = AbstractFPProvisioningCommand.getGav(this.fpCoords, this.streamName, invoc.getPmSession());
        if (!invoc.getPmSession().existsInLocalRepository(gav)) {
            try {
                invoc.getPmSession().downloadFp(gav);
            }
            catch (ArtifactException ex) {
                throw new CommandExecutionException(ex);
            }
        }
        this.runCommand(invoc, session, gav);
    }

    protected abstract void runCommand(PmCommandInvocation var1, State var2, ArtifactCoords.Gav var3) throws IOException, ProvisioningException, CommandExecutionException;

    public static ArtifactCoords.Gav getGav(String fpCoords, String streamName, PmSession session) throws CommandExecutionException {
        String coords;
        if (fpCoords == null && streamName == null) {
            throw new CommandExecutionException("Stream name or feature-pack coordinates must be set");
        }
        if (fpCoords != null && streamName != null) {
            throw new CommandExecutionException("Only one of stream name or feature-pack coordinates must be set");
        }
        if (streamName != null) {
            try {
                coords = session.getUniverses().resolveStream(streamName).toString();
            }
            catch (ArtifactException ex) {
                throw new CommandExecutionException("Stream resolution failed", ex);
            }
        } else {
            coords = fpCoords;
        }
        return ArtifactCoords.newGav(coords);
    }

    public String getName() {
        if (this.streamName == null) {
            return this.fpCoords;
        }
        return this.streamName;
    }
}

