/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state.configuration;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.state.AbstractFPProvisionedCommand;
import org.jboss.galleon.cli.model.ConfigInfo;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.cli.model.FeatureContainers;
import org.jboss.galleon.cli.path.FeatureContainerPathConsumer;
import org.jboss.galleon.cli.path.PathConsumerException;
import org.jboss.galleon.cli.path.PathParser;
import org.jboss.galleon.cli.path.PathParserException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.FeaturePackConfig;

public abstract class ConfigurationUtil
extends AbstractFPProvisionedCommand {
    public static Map<FeaturePackConfig, ConfigId> getConfigurations(PmSession session, FeaturePackConfig config, String configuration) throws PathParserException, PathConsumerException, ProvisioningException, Exception {
        HashMap<FeaturePackConfig, ConfigId> configs = new HashMap<FeaturePackConfig, ConfigId>();
        if (config == null) {
            for (FeaturePackConfig c : session.getState().getConfig().getFeaturePackDeps()) {
                ConfigInfo info = ConfigurationUtil.getConfig(session, c.getGav(), configuration);
                if (info == null) continue;
                configs.put(c, info.getId());
            }
        } else {
            ConfigInfo info = ConfigurationUtil.getConfig(session, config.getGav(), configuration);
            if (info != null) {
                configs.put(config, info.getId());
            }
        }
        if (configs.isEmpty()) {
            throw new ProvisioningException("Not a valid config " + configuration);
        }
        return configs;
    }

    public static Map<FeaturePackConfig, ConfigId> getIncludedConfigurations(PmSession session, FeaturePackConfig config, String configuration) throws PathParserException, PathConsumerException, ProvisioningException, Exception {
        HashMap<FeaturePackConfig, ConfigId> configs = new HashMap<FeaturePackConfig, ConfigId>();
        if (config == null) {
            for (FeaturePackConfig c : session.getState().getConfig().getFeaturePackDeps()) {
                ConfigInfo info = ConfigurationUtil.getConfig(session, c.getGav(), configuration);
                if (info == null || !c.getIncludedConfigs().contains(new ConfigId(info.getModel(), info.getName()))) continue;
                configs.put(c, info.getId());
            }
        } else {
            ConfigInfo info = ConfigurationUtil.getConfig(session, config.getGav(), configuration);
            if (info != null && config.getIncludedConfigs().contains(new ConfigId(info.getModel(), info.getName()))) {
                configs.put(config, info.getId());
            }
        }
        if (configs.isEmpty()) {
            throw new ProvisioningException("Not a valid config " + configuration);
        }
        return configs;
    }

    public static Map<FeaturePackConfig, ConfigId> getExcludedConfigurations(PmSession session, FeaturePackConfig config, String configuration) throws PathParserException, PathConsumerException, ProvisioningException, Exception {
        HashMap<FeaturePackConfig, ConfigId> configs = new HashMap<FeaturePackConfig, ConfigId>();
        if (config == null) {
            for (FeaturePackConfig c : session.getState().getConfig().getFeaturePackDeps()) {
                ConfigInfo info = ConfigurationUtil.getConfig(session, c.getGav(), configuration);
                if (info == null || !c.getExcludedConfigs().contains(new ConfigId(info.getModel(), info.getName()))) continue;
                configs.put(c, info.getId());
            }
        } else {
            ConfigInfo info = ConfigurationUtil.getConfig(session, config.getGav(), configuration);
            if (info != null && config.getExcludedConfigs().contains(new ConfigId(info.getModel(), info.getName()))) {
                configs.put(config, info.getId());
            }
        }
        if (configs.isEmpty()) {
            throw new ProvisioningException("Not a valid config " + configuration);
        }
        return configs;
    }

    private static ConfigInfo getConfig(PmSession session, ArtifactCoords.Gav gav, String configuration) throws ProvisioningException, IOException, PathParserException, PathConsumerException {
        String path = "/configs/final/" + configuration + '/';
        FeatureContainer full = FeatureContainers.fromFeaturePackGav(session, ProvisioningManager.builder().setArtifactResolver(session.getArtifactResolver()).build(), gav, null);
        ConfigInfo ci = null;
        try {
            FeatureContainerPathConsumer consumer = new FeatureContainerPathConsumer(full, false);
            PathParser.parse(path, consumer);
            ci = consumer.getConfig();
        }
        catch (PathConsumerException | PathParserException exception) {
            // empty catch block
        }
        return ci;
    }

    public static String getCurrentPath(PmSession session) {
        return "/configs/final/";
    }

    public static void filterCandidates(FeatureContainerPathConsumer consumer, List<String> candidates) {
        if (consumer.getConfig() != null) {
            candidates.clear();
        }
        if (consumer.getConfigModel() != null) {
            for (int i = 0; i < candidates.size(); ++i) {
                String c = candidates.get(i);
                if (!c.endsWith("/")) continue;
                candidates.set(i, c.substring(0, c.length() - 1));
            }
        }
    }
}

