/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state.pkg;

import java.util.HashMap;
import java.util.Map;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.cli.model.FeatureContainers;
import org.jboss.galleon.cli.model.Group;
import org.jboss.galleon.cli.path.FeatureContainerPathConsumer;
import org.jboss.galleon.cli.path.PathConsumerException;
import org.jboss.galleon.cli.path.PathParser;
import org.jboss.galleon.cli.path.PathParserException;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.PackageConfig;

public class PackagesUtil {
    public static String getPackage(PmSession session, ArtifactCoords.Gav gav, String pkg) throws PathParserException, PathConsumerException, ProvisioningException, Exception {
        String path = "/packages/" + pkg + (pkg.endsWith("/") ? "" : Character.valueOf('/'));
        FeatureContainer full = FeatureContainers.fromFeaturePackGav(session, ProvisioningManager.builder().setArtifactResolver(session.getArtifactResolver()).build(), gav, null);
        FeatureContainerPathConsumer consumer = new FeatureContainerPathConsumer(full, false);
        PathParser.parse(path, consumer);
        Group grp = consumer.getCurrentNode(path);
        if (grp == null || grp.getPackage() == null) {
            throw new ProvisioningException("Not a valid package " + pkg);
        }
        return grp.getPackage().getSpec().getName();
    }

    public static Map<FeaturePackConfig, String> getIncludedPackages(PmSession session, FeaturePackConfig config, String pkg) throws PathParserException, PathConsumerException, ProvisioningException, Exception {
        HashMap<FeaturePackConfig, String> packages = new HashMap<FeaturePackConfig, String>();
        if (config == null) {
            for (FeaturePackConfig c : session.getState().getConfig().getFeaturePackDeps()) {
                if (!c.getIncludedPackages().contains(PackageConfig.forName(pkg))) continue;
                packages.put(c, pkg);
            }
        } else if (config.getIncludedPackages().contains(PackageConfig.forName(pkg))) {
            packages.put(config, pkg);
        }
        if (packages.isEmpty()) {
            throw new ProvisioningException("Not a valid package " + pkg);
        }
        return packages;
    }

    public static Map<FeaturePackConfig, String> getExcludedPackages(PmSession session, FeaturePackConfig config, String pkg) throws PathParserException, PathConsumerException, ProvisioningException, Exception {
        HashMap<FeaturePackConfig, String> packages = new HashMap<FeaturePackConfig, String>();
        if (config == null) {
            for (FeaturePackConfig c : session.getState().getConfig().getFeaturePackDeps()) {
                if (!c.getExcludedPackages().contains(pkg)) continue;
                packages.put(c, pkg);
            }
        } else if (config.getExcludedPackages().contains(pkg)) {
            packages.put(config, pkg);
        }
        if (packages.isEmpty()) {
            throw new ProvisioningException("Not a valid package " + pkg);
        }
        return packages;
    }
}

