/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.UniverseLocation;
import org.jboss.galleon.cli.config.ConfigXmlParser10;
import org.jboss.galleon.cli.config.mvn.MavenConfig;
import org.jboss.galleon.xml.XmlParsers;
import org.jboss.galleon.xml.util.FormattingXmlStreamWriter;

public class Configuration
implements MavenConfig.MavenChangeListener {
    private static final String CONFIG_FILE_NAME = ".galleon-cli";
    private static final File DEFAULT_HISTORY_FILE;
    private final List<UniverseLocation> universes = new ArrayList<UniverseLocation>();
    private File historyFile = DEFAULT_HISTORY_FILE;
    private final MavenConfig maven = new MavenConfig();

    private Configuration() {
        this.maven.addListener(this);
    }

    public MavenConfig getMavenConfig() {
        return this.maven;
    }

    @Override
    public void configurationChanged(MavenConfig config) throws XMLStreamException, IOException {
        this.needRewrite();
    }

    private void needRewrite() throws XMLStreamException, IOException {
        Path path = Configuration.getStoragePath();
        Files.deleteIfExists(path);
        try (BufferedWriter bw = Files.newBufferedWriter(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
             FormattingXmlStreamWriter writer = new FormattingXmlStreamWriter(XMLOutputFactory.newInstance().createXMLStreamWriter(bw));){
            writer.writeStartDocument();
            writer.writeStartElement(ConfigXmlParser10.ROOT_1_0.getLocalPart());
            writer.writeDefaultNamespace("urn:jboss:galleon:cli:1.0");
            this.maven.write(writer);
            writer.writeEndElement();
            writer.writeEndDocument();
        }
    }

    public File getHistoryFile() {
        return this.historyFile;
    }

    public List<UniverseLocation> getUniversesLocations() {
        return Collections.unmodifiableList(this.universes);
    }

    public static Configuration parse() throws ProvisioningException {
        Configuration config = new Configuration();
        config.universes.add(UniverseLocation.DEFAULT);
        Path configFile = Configuration.getStoragePath();
        if (Files.exists(configFile, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(configFile);){
                XmlParsers.parse(reader, config);
            }
            catch (IOException | XMLStreamException e) {
                throw new ProvisioningException(Errors.parseXml(configFile), e);
            }
        }
        return config;
    }

    private static Path getStoragePath() {
        return new File(System.getProperty("user.home") + File.separator + CONFIG_FILE_NAME).toPath();
    }

    static {
        new ConfigXmlParser10().plugin(XmlParsers.getInstance());
        DEFAULT_HISTORY_FILE = new File(System.getProperty("user.home"), ".galleon-history");
    }
}

