/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.config.mvn;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.jboss.galleon.ArtifactException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.config.mvn.MavenCliSettings;
import org.jboss.galleon.cli.config.mvn.MavenMvnSettings;
import org.jboss.galleon.cli.config.mvn.MavenRemoteRepository;
import org.jboss.galleon.cli.config.mvn.MavenSettings;
import org.jboss.galleon.util.PropertyUtils;
import org.jboss.galleon.xml.util.FormattingXmlStreamWriter;

public class MavenConfig {
    private final Map<String, MavenRemoteRepository> repositories = new HashMap<String, MavenRemoteRepository>();
    private Path localRepository;
    private final List<MavenChangeListener> listeners = new ArrayList<MavenChangeListener>();
    private Path settings;

    public Path getSettings() {
        return this.settings;
    }

    public void addListener(MavenChangeListener listener) {
        this.listeners.add(listener);
    }

    static Path getDefaultMavenRepositoryPath() {
        String repoPath = PropertyUtils.getSystemProperty("maven.repo.path");
        if (repoPath == null) {
            repoPath = PropertyUtils.getSystemProperty("user.home") + File.separatorChar + ".m2" + File.separatorChar + "repository";
        }
        return Paths.get(repoPath, new String[0]);
    }

    public void addRemoteRepository(MavenRemoteRepository repo) throws XMLStreamException, IOException, ProvisioningException {
        this.repositories.put(repo.getName(), repo);
        this.advertise();
    }

    private void advertise() throws XMLStreamException, IOException {
        for (MavenChangeListener listener : this.listeners) {
            listener.configurationChanged(this);
        }
    }

    public Collection<MavenRemoteRepository> getRemoteRepositories() {
        return Collections.unmodifiableCollection(this.repositories.values());
    }

    public Set<String> getRemoteRepositoryNames() {
        return Collections.unmodifiableSet(this.repositories.keySet());
    }

    public void removeRemoteRepository(String name) throws XMLStreamException, IOException, ProvisioningException {
        MavenRemoteRepository rep = this.repositories.remove(name);
        if (rep == null) {
            throw new ProvisioningException("Repository " + name + " doesn't exist");
        }
        this.advertise();
    }

    public void write(FormattingXmlStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("maven");
        if (this.localRepository != null) {
            writer.writeStartElement("local-repository");
            writer.writeCharacters(this.localRepository.toAbsolutePath().toString());
            writer.writeEndElement();
        }
        if (this.settings != null) {
            writer.writeStartElement("settings");
            writer.writeCharacters(this.settings.toAbsolutePath().toString());
            writer.writeEndElement();
        }
        if (this.repositories.isEmpty()) {
            writer.writeEmptyElement("repositories");
        } else {
            writer.writeStartElement("repositories");
            for (MavenRemoteRepository repo : this.repositories.values()) {
                writer.writeStartElement("repository");
                writer.writeAttribute("name", repo.getName());
                writer.writeAttribute("type", repo.getType());
                writer.writeCharacters(repo.getUrl());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public Path getLocalRepository() {
        return this.localRepository == null ? MavenConfig.getDefaultMavenRepositoryPath() : this.localRepository;
    }

    public void setLocalRepository(Path path) throws XMLStreamException, IOException {
        this.localRepository = path == null ? null : path.normalize();
        this.advertise();
    }

    public void setSettings(Path path) throws XMLStreamException, IOException {
        this.settings = path == null ? null : path.normalize();
        this.advertise();
    }

    private boolean reuseMavenSettings() {
        return this.getSettings() != null;
    }

    public MavenSettings buildSettings(RepositorySystem repoSystem, RepositoryListener listener) throws ArtifactException {
        if (this.reuseMavenSettings()) {
            return new MavenMvnSettings(this, repoSystem, listener);
        }
        return new MavenCliSettings(this, repoSystem, listener);
    }

    public static interface MavenChangeListener {
        public void configurationChanged(MavenConfig var1) throws XMLStreamException, IOException;
    }
}

