/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.config.mvn;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.jboss.galleon.ArtifactException;
import org.jboss.galleon.cli.Util;
import org.jboss.galleon.cli.config.mvn.MavenConfig;
import org.jboss.galleon.cli.config.mvn.MavenProxySelector;
import org.jboss.galleon.cli.config.mvn.MavenSettings;

class MavenMvnSettings
implements MavenSettings {
    private static final String EXTERNAL = "external:";
    private final List<RemoteRepository> repositories;
    private final RepositorySystemSession session;

    MavenMvnSettings(MavenConfig config, RepositorySystem repoSystem, RepositoryListener listener) throws ArtifactException {
        Settings settings = MavenMvnSettings.buildMavenSettings(config.getSettings());
        this.repositories = Collections.unmodifiableList(MavenMvnSettings.buildRemoteRepositories(settings));
        Proxy proxy = settings.getActiveProxy();
        MavenProxySelector proxySelector = null;
        if (proxy != null) {
            MavenProxySelector.Builder builder = new MavenProxySelector.Builder(proxy.getHost(), proxy.getPort(), proxy.getProtocol());
            builder.setPassword(proxy.getPassword());
            builder.setUserName(proxy.getUsername());
            if (proxy.getNonProxyHosts() != null) {
                String[] hosts = proxy.getNonProxyHosts().split("|");
                builder.addNonProxyHosts(Arrays.asList(hosts));
            }
            proxySelector = builder.build();
        }
        this.session = Util.newRepositorySession(repoSystem, settings.getLocalRepository() == null ? config.getLocalRepository() : Paths.get(settings.getLocalRepository(), new String[0]), listener, proxySelector, settings.isOffline());
    }

    @Override
    public List<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    @Override
    public RepositorySystemSession getSession() {
        return this.session;
    }

    private static Settings buildMavenSettings(Path settingsPath) throws ArtifactException {
        SettingsBuildingResult settingsBuildingResult;
        DefaultSettingsBuildingRequest settingsBuildingRequest = new DefaultSettingsBuildingRequest();
        settingsBuildingRequest.setSystemProperties(System.getProperties());
        settingsBuildingRequest.setUserSettingsFile(settingsPath.toFile());
        DefaultSettingsBuilderFactory mvnSettingBuilderFactory = new DefaultSettingsBuilderFactory();
        DefaultSettingsBuilder settingsBuilder = mvnSettingBuilderFactory.newInstance();
        try {
            settingsBuildingResult = settingsBuilder.build(settingsBuildingRequest);
        }
        catch (SettingsBuildingException ex) {
            throw new ArtifactException(ex.getLocalizedMessage());
        }
        return settingsBuildingResult.getEffectiveSettings();
    }

    private static List<RemoteRepository> buildRemoteRepositories(Settings settings) throws ArtifactException {
        Map<String, Profile> profiles = settings.getProfilesAsMap();
        LinkedHashMap<String, RemoteRepository> repos = new LinkedHashMap<String, RemoteRepository>();
        ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>();
        for (String profileName : settings.getActiveProfiles()) {
            Profile profile = profiles.get(profileName);
            if (profile == null) {
                throw new ArtifactException("Unknown profile " + profileName);
            }
            List<Repository> mavenRepositories = profile.getRepositories();
            for (Repository repository : mavenRepositories) {
                repos.put(repository.getId(), MavenMvnSettings.buildRepository(repository.getId(), repository.getLayout(), repository.getUrl(), settings, repository.getReleases(), repository.getSnapshots(), null));
            }
            for (Mirror mirror : settings.getMirrors()) {
                String[] patterns = mirror.getMirrorOf().split(",");
                ArrayList<RemoteRepository> mirrored = new ArrayList<RemoteRepository>();
                for (String p : patterns) {
                    if (p.startsWith(EXTERNAL)) {
                        throw new ArtifactException("external: is not supported in mirrorOf");
                    }
                    RemoteRepository m = (RemoteRepository)repos.get(p);
                    if (m == null) continue;
                    mirrored.add((RemoteRepository)repos.remove(p));
                }
                if (mirrored.isEmpty()) continue;
                repositories.add(MavenMvnSettings.buildRepository(mirror.getId(), mirror.getLayout(), mirror.getUrl(), settings, null, null, mirrored));
            }
            for (Map.Entry entry : repos.entrySet()) {
                repositories.add((RemoteRepository)entry.getValue());
            }
        }
        return repositories;
    }

    private static RemoteRepository buildRepository(String id, String type, String url, Settings settings, org.apache.maven.settings.RepositoryPolicy rp, org.apache.maven.settings.RepositoryPolicy sp, List<RemoteRepository> mirrored) {
        RemoteRepository.Builder builder = new RemoteRepository.Builder(id, type == null ? "default" : type, url);
        if (rp != null) {
            RepositoryPolicy releases = new RepositoryPolicy(rp.isEnabled(), rp.getUpdatePolicy(), rp.getChecksumPolicy());
            builder.setReleasePolicy(releases);
        }
        if (sp != null) {
            RepositoryPolicy snapshots = new RepositoryPolicy(sp.isEnabled(), sp.getUpdatePolicy(), sp.getChecksumPolicy());
            builder.setReleasePolicy(snapshots);
        }
        for (Server server : settings.getServers()) {
            AuthenticationBuilder authBuilder;
            if (!server.getId().equals(id)) continue;
            if (server.getUsername() != null) {
                authBuilder = new AuthenticationBuilder();
                authBuilder.addPassword(server.getPassword());
                authBuilder.addUsername(server.getUsername());
                builder.setAuthentication(authBuilder.build());
                continue;
            }
            if (server.getPrivateKey() == null) continue;
            authBuilder = new AuthenticationBuilder();
            authBuilder.addPrivateKey(server.getPrivateKey(), server.getPassphrase());
            builder.setAuthentication(authBuilder.build());
        }
        if (mirrored != null) {
            builder.setMirroredRepositories(mirrored);
        }
        return builder.build();
    }
}

