/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.model;

import java.util.Objects;
import org.jboss.galleon.ArtifactCoords;

public class Identity
implements Comparable<Identity> {
    public static final String EMPTY = "";
    private final String origin;
    private final String name;

    private Identity(String origin, String name) {
        this.origin = origin;
        this.name = name;
    }

    public static Identity fromGav(ArtifactCoords.Gav origin, String name) {
        return new Identity(origin.getGroupId() + ":" + origin.getArtifactId(), name);
    }

    public static Identity fromString(String origin, String name) {
        return new Identity(origin, name);
    }

    public static Identity fromString(String name) {
        return new Identity(EMPTY, name);
    }

    public static String buildOrigin(ArtifactCoords.Gav gav) {
        return gav.getGroupId() + ":" + gav.getArtifactId();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Identity)) {
            return false;
        }
        Identity gi = (Identity)obj;
        return this.getName().equals(gi.getName()) && this.getOrigin().equals(gi.getOrigin());
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.getOrigin());
        hash = 79 * hash + Objects.hashCode(this.getName());
        return hash;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(Identity o) {
        return this.toString().compareTo(o.toString());
    }

    public String toString() {
        return this.origin + '/' + this.name;
    }
}

