/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.model.state;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.model.ConfigInfo;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.cli.model.FeatureContainers;
import org.jboss.galleon.cli.model.FeatureInfo;
import org.jboss.galleon.cli.model.FeatureSpecInfo;
import org.jboss.galleon.cli.model.Identity;
import org.jboss.galleon.cli.model.state.ConfigProvisioning;
import org.jboss.galleon.cli.model.state.FeaturePackProvisioning;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.xml.ProvisioningXmlWriter;

public class State {
    private ProvisioningConfig config;
    private FeatureContainer container;
    private String path;
    private ProvisioningConfig.Builder builder;
    private final FeaturePackProvisioning fpProvisioning = new FeaturePackProvisioning();
    private final ConfigProvisioning configProvisioning = new ConfigProvisioning();
    private final Deque<Action> stack = new ArrayDeque<Action>();
    private ProvisioningRuntime runtime;

    public State(PmSession pmSession) throws ProvisioningException, IOException {
        this.builder = ProvisioningConfig.builder();
        ProvisioningManager manager = ProvisioningManager.builder().setArtifactResolver(pmSession.getArtifactResolver()).build();
        this.init(pmSession, manager);
    }

    public State(PmSession pmSession, Path installation) throws ProvisioningException, IOException {
        ProvisioningConfig conf;
        ProvisioningManager manager;
        if (Files.isRegularFile(installation, new LinkOption[0])) {
            manager = ProvisioningManager.builder().setArtifactResolver(pmSession.getArtifactResolver()).build();
            conf = manager.readProvisioningConfig(installation);
            this.builder = conf.getBuilder();
        } else {
            manager = ProvisioningManager.builder().setArtifactResolver(pmSession.getArtifactResolver()).setInstallationHome(installation).build();
            if (manager.getProvisionedState() == null) {
                throw new ProvisioningException(installation + " is not an installation dir");
            }
            conf = manager.getProvisioningConfig();
            this.builder = conf.getBuilder();
        }
        HashSet<ArtifactCoords.Gav> dependencies = new HashSet<ArtifactCoords.Gav>();
        for (FeaturePackConfig cf : conf.getFeaturePackDeps()) {
            dependencies.add(cf.getGav());
        }
        this.init(pmSession, manager);
        HashMap<String, FeatureContainer> fullDependencies = new HashMap<String, FeatureContainer>();
        this.buildDependencies(pmSession, dependencies, fullDependencies);
        this.container.setFullDependencies(fullDependencies);
    }

    public ProvisioningRuntime getRuntime() {
        return this.runtime;
    }

    private void init(PmSession pmSession, ProvisioningManager manager) throws ProvisioningException, IOException {
        this.config = this.builder.build();
        this.runtime = manager.getRuntime(this.config, null, Collections.emptyMap());
        this.container = FeatureContainers.fromProvisioningRuntime(pmSession, manager, this.runtime);
        this.container.setEdit(true);
        this.path = "/";
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean hasActions() {
        return !this.stack.isEmpty();
    }

    public ProvisioningConfig getConfig() {
        return this.config;
    }

    public FeatureContainer getContainer() {
        return this.container;
    }

    public void addDependency(PmSession pmSession, String name, ArtifactCoords.Gav gav, boolean inheritConfigs, boolean inheritPackages) throws ProvisioningException, IOException {
        Action action = this.fpProvisioning.addDependency(pmSession, name, gav, inheritConfigs, inheritPackages);
        this.config = this.pushState(action, pmSession);
    }

    public void removeDependency(PmSession pmSession, ArtifactCoords.Gav gav) throws ProvisioningException, IOException {
        Action action = this.fpProvisioning.removeDependency(gav);
        this.config = this.pushState(action, pmSession);
    }

    public void includeConfiguration(PmSession pmSession, Map<FeaturePackConfig, ConfigId> cf) throws ProvisioningException, IOException {
        Action action = this.fpProvisioning.includeConfiguration(cf);
        this.config = this.pushState(action, pmSession);
    }

    public void removeIncludedConfiguration(PmSession pmSession, Map<FeaturePackConfig, ConfigId> cf) throws ProvisioningException, IOException {
        Action action = this.fpProvisioning.removeIncludedConfiguration(cf);
        this.config = this.pushState(action, pmSession);
    }

    public void excludeConfiguration(PmSession pmSession, Map<FeaturePackConfig, ConfigId> cf) throws ProvisioningException, IOException {
        Action action = this.fpProvisioning.excludeConfiguration(cf);
        this.config = this.pushState(action, pmSession);
    }

    public void removeExcludedConfiguration(PmSession pmSession, Map<FeaturePackConfig, ConfigId> cf) throws ProvisioningException, IOException {
        Action action = this.fpProvisioning.removeExcludedConfiguration(cf);
        this.config = this.pushState(action, pmSession);
    }

    public void resetConfiguration(PmSession pmSession, ConfigInfo configuration) throws ProvisioningException, IOException {
        ConfigId id = new ConfigId(configuration.getModel(), configuration.getName());
        Action action = this.configProvisioning.resetConfiguration(id);
        this.config = this.pushState(action, pmSession);
    }

    public void includePackage(PmSession pmSession, String pkg, FeaturePackConfig cf) throws ProvisioningException, IOException {
        Action action = this.fpProvisioning.includePackage(pkg, cf);
        this.config = this.pushState(action, pmSession);
    }

    public void removeIncludedPackage(PmSession pmSession, Map<FeaturePackConfig, String> cf) throws ProvisioningException, IOException {
        Action action = this.fpProvisioning.removeIncludedPackage(cf);
        this.config = this.pushState(action, pmSession);
    }

    public void excludePackage(PmSession pmSession, String pkg, FeaturePackConfig cf) throws ProvisioningException, IOException {
        Action action = this.fpProvisioning.excludePackage(pkg, cf);
        this.config = this.pushState(action, pmSession);
    }

    public void removeExcludedPackage(PmSession pmSession, Map<FeaturePackConfig, String> cf) throws ProvisioningException, IOException {
        Action action = this.fpProvisioning.removeExcludedPackage(cf);
        this.config = this.pushState(action, pmSession);
    }

    public void addFeature(PmSession pmSession, FeatureSpecInfo spec, ConfigInfo configuration, Map<String, String> options) throws ProvisioningException, IOException {
        ConfigId id = new ConfigId(configuration.getModel(), configuration.getName());
        Action action = this.configProvisioning.addFeature(id, spec, options);
        this.config = this.pushState(action, pmSession);
    }

    public void removeFeature(PmSession pmSession, ConfigInfo ci, FeatureInfo fi) throws ProvisioningException, IOException {
        ConfigId id = new ConfigId(ci.getModel(), ci.getName());
        Action action = this.configProvisioning.removeFeature(id, fi);
        this.config = this.pushState(action, pmSession);
    }

    public void export(Path file) throws Exception {
        ProvisioningXmlWriter.getInstance().write(this.config, file);
    }

    public void pop(PmSession pmSession) throws IOException, ProvisioningException {
        Action action = this.stack.peek();
        if (action != null) {
            this.config = this.popState(action, pmSession);
        }
    }

    private ProvisioningConfig pushState(Action action, PmSession pmSession) throws IOException, ProvisioningException {
        action.doAction(this.config, this.builder);
        try {
            ProvisioningConfig newConfig = this.buildNewConfig(pmSession);
            this.stack.push(action);
            return newConfig;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                action.undoAction(this.builder);
            }
            catch (Exception ex2) {
                ex.addSuppressed(ex2);
            }
            throw ex;
        }
    }

    private ProvisioningConfig popState(Action action, PmSession pmSession) throws IOException, ProvisioningException {
        action.undoAction(this.builder);
        try {
            ProvisioningConfig newConfig = this.buildNewConfig(pmSession);
            this.stack.remove();
            return newConfig;
        }
        catch (IOException | ProvisioningException ex) {
            action.doAction(this.config, this.builder);
            throw ex;
        }
    }

    private ProvisioningConfig buildNewConfig(PmSession pmSession) throws ProvisioningException, IOException {
        ProvisioningConfig tmp = this.builder.build();
        ProvisioningManager manager = ProvisioningManager.builder().setArtifactResolver(pmSession.getArtifactResolver()).build();
        this.runtime = manager.getRuntime(tmp, null, Collections.emptyMap());
        HashSet<ArtifactCoords.Gav> dependencies = new HashSet<ArtifactCoords.Gav>();
        for (FeaturePackConfig cf : tmp.getFeaturePackDeps()) {
            dependencies.add(cf.getGav());
        }
        FeatureContainer tmpContainer = FeatureContainers.fromProvisioningRuntime(pmSession, manager, this.runtime);
        HashSet<ArtifactCoords.Gav> newDeps = new HashSet<ArtifactCoords.Gav>();
        for (FeaturePackConfig cf : tmp.getFeaturePackDeps()) {
            newDeps.add(cf.getGav());
        }
        HashMap<String, FeatureContainer> tmpDeps = new HashMap<String, FeatureContainer>();
        tmpDeps.putAll(this.container.getFullDependencies());
        this.buildDependencies(pmSession, dependencies, tmpDeps);
        this.container = tmpContainer;
        this.container.setEdit(true);
        this.container.setFullDependencies(tmpDeps);
        return tmp;
    }

    private void buildDependencies(PmSession session, Set<ArtifactCoords.Gav> dependencies, Map<String, FeatureContainer> deps) throws ProvisioningException, IOException {
        ProvisioningManager manager = ProvisioningManager.builder().setArtifactResolver(session.getArtifactResolver()).build();
        for (ArtifactCoords.Gav gav : dependencies) {
            String orig = Identity.buildOrigin(gav);
            if (deps.containsKey(orig)) continue;
            deps.put(orig, FeatureContainers.fromFeaturePackGav(session, manager, gav, null));
        }
        Iterator<FeatureContainer> it = deps.values().iterator();
        while (it.hasNext()) {
            FeatureContainer fc = it.next();
            if (dependencies.contains(fc.getGav())) continue;
            it.remove();
        }
    }

    static interface Action {
        public void doAction(ProvisioningConfig var1, ProvisioningConfig.Builder var2) throws ProvisioningException;

        public void undoAction(ProvisioningConfig.Builder var1) throws ProvisioningException;
    }
}

