/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.spec;

import java.util.Collections;
import java.util.Set;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.FeaturePackDepsConfig;
import org.jboss.galleon.config.FeaturePackDepsConfigBuilder;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.StringUtils;

public class FeaturePackSpec
extends FeaturePackDepsConfig {
    private final ArtifactCoords.Gav gav;
    private final Set<String> defPackages;

    public static Builder builder() {
        return FeaturePackSpec.builder(null);
    }

    public static Builder builder(ArtifactCoords.Gav gav) {
        return new Builder(gav);
    }

    protected FeaturePackSpec(Builder builder) {
        super(builder);
        this.gav = builder.gav;
        this.defPackages = CollectionUtils.unmodifiable(builder.defPackages);
    }

    public ArtifactCoords.Gav getGav() {
        return this.gav;
    }

    public boolean hasDefaultPackages() {
        return !this.defPackages.isEmpty();
    }

    public Set<String> getDefaultPackageNames() {
        return this.defPackages;
    }

    public boolean isDefaultPackage(String name) {
        return this.defPackages.contains(name);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.defPackages == null ? 0 : this.defPackages.hashCode());
        result = 31 * result + (this.gav == null ? 0 : this.gav.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeaturePackSpec other = (FeaturePackSpec)obj;
        if (this.defPackages == null ? other.defPackages != null : !this.defPackages.equals(other.defPackages)) {
            return false;
        }
        return !(this.gav == null ? other.gav != null : !this.gav.equals(other.gav));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[gav=").append(this.gav);
        if (!this.fpDeps.isEmpty()) {
            buf.append("; dependencies: ");
            StringUtils.append(buf, this.fpDeps.keySet());
        }
        if (!this.definedConfigs.isEmpty()) {
            buf.append("; defaultConfigs: ");
            StringUtils.append(buf, this.definedConfigs);
        }
        if (!this.defPackages.isEmpty()) {
            buf.append("; defaultPackages: ");
            StringUtils.append(buf, this.defPackages);
        }
        return buf.append("]").toString();
    }

    public static class Builder
    extends FeaturePackDepsConfigBuilder<Builder> {
        private ArtifactCoords.Gav gav;
        private Set<String> defPackages = Collections.emptySet();

        protected Builder() {
            this(null);
        }

        protected Builder(ArtifactCoords.Gav gav) {
            this.gav = gav;
        }

        public Builder setGav(ArtifactCoords.Gav gav) {
            this.gav = gav;
            return this;
        }

        public ArtifactCoords.Gav getGav() {
            return this.gav;
        }

        public Builder addDefaultPackage(String packageName) {
            assert (packageName != null) : "packageName is null";
            this.defPackages = CollectionUtils.addLinked(this.defPackages, packageName);
            return this;
        }

        public FeaturePackSpec build() throws ProvisioningDescriptionException {
            return new FeaturePackSpec(this);
        }
    }
}

