/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.state;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.state.FeaturePackSet;
import org.jboss.galleon.state.ProvisionedConfig;
import org.jboss.galleon.state.ProvisionedFeaturePack;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.StringUtils;

public class ProvisionedState
implements FeaturePackSet<ProvisionedFeaturePack> {
    private final Map<ArtifactCoords.Ga, ProvisionedFeaturePack> featurePacks;
    private final List<ProvisionedConfig> configs;

    public static Builder builder() {
        return new Builder();
    }

    ProvisionedState(Builder builder) {
        this.featurePacks = CollectionUtils.unmodifiable(builder.featurePacks);
        this.configs = CollectionUtils.unmodifiable(builder.configs);
    }

    @Override
    public boolean hasFeaturePacks() {
        return !this.featurePacks.isEmpty();
    }

    @Override
    public boolean hasFeaturePack(ArtifactCoords.Ga ga) {
        return this.featurePacks.containsKey(ga);
    }

    @Override
    public Collection<ProvisionedFeaturePack> getFeaturePacks() {
        return this.featurePacks.values();
    }

    @Override
    public ProvisionedFeaturePack getFeaturePack(ArtifactCoords.Ga ga) {
        return this.featurePacks.get(ga);
    }

    @Override
    public boolean hasConfigs() {
        return !this.configs.isEmpty();
    }

    @Override
    public List<ProvisionedConfig> getConfigs() {
        return this.configs;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.configs == null ? 0 : this.configs.hashCode());
        result = 31 * result + (this.featurePacks == null ? 0 : this.featurePacks.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProvisionedState other = (ProvisionedState)obj;
        if (this.configs == null ? other.configs != null : this.configs.size() != other.configs.size() || !this.configs.containsAll(other.configs)) {
            return false;
        }
        return !(this.featurePacks == null ? other.featurePacks != null : !this.featurePacks.equals(other.featurePacks));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[state");
        if (!this.featurePacks.isEmpty()) {
            buf.append(" feature-packs=[");
            StringUtils.append(buf, this.featurePacks.values());
            buf.append(']');
        }
        if (!this.configs.isEmpty()) {
            buf.append(" configs=[");
            StringUtils.append(buf, this.configs);
            buf.append(']');
        }
        return buf.append(']').toString();
    }

    public static class Builder {
        private Map<ArtifactCoords.Ga, ProvisionedFeaturePack> featurePacks = Collections.emptyMap();
        private List<ProvisionedConfig> configs = Collections.emptyList();

        private Builder() {
        }

        public Builder addFeaturePack(ProvisionedFeaturePack fp) {
            this.featurePacks = CollectionUtils.putLinked(this.featurePacks, fp.getGav().toGa(), fp);
            return this;
        }

        public Builder addConfig(ProvisionedConfig config) {
            this.configs = CollectionUtils.add(this.configs, config);
            return this;
        }

        public ProvisionedState build() {
            return new ProvisionedState(this);
        }
    }
}

