/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Arrays;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.xml.BaseXmlWriter;
import org.jboss.galleon.xml.FeaturePackXmlParser10;
import org.jboss.galleon.xml.ProvisioningXmlWriter;
import org.jboss.galleon.xml.util.ElementNode;

public class FeaturePackXmlWriter
extends BaseXmlWriter<FeaturePackSpec> {
    private static final FeaturePackXmlWriter INSTANCE = new FeaturePackXmlWriter();

    public static FeaturePackXmlWriter getInstance() {
        return INSTANCE;
    }

    private FeaturePackXmlWriter() {
    }

    @Override
    protected ElementNode toElement(FeaturePackSpec fpSpec) {
        ElementNode fp = FeaturePackXmlWriter.addElement(null, FeaturePackXmlParser10.Element.FEATURE_PACK);
        ArtifactCoords.Gav fpGav = fpSpec.getGav();
        ProvisioningXmlWriter.addGav(fp, fpGav);
        if (fpSpec.hasFeaturePackDeps()) {
            ElementNode deps = FeaturePackXmlWriter.addElement(fp, FeaturePackXmlParser10.Element.DEPENDENCIES);
            for (FeaturePackConfig dep : fpSpec.getFeaturePackDeps()) {
                ElementNode depElement = FeaturePackXmlWriter.addElement(deps, FeaturePackXmlParser10.Element.DEPENDENCY);
                ProvisioningXmlWriter.writeFeaturePackConfig(depElement, depElement.getNamespace(), dep, fpSpec.originOf(dep.getGav().toGa()));
            }
        }
        ProvisioningXmlWriter.writeConfigCustomizations(fp, FeaturePackXmlParser10.Element.FEATURE_PACK.getNamespace(), fpSpec);
        if (fpSpec.hasDefaultPackages()) {
            ElementNode pkgs = FeaturePackXmlWriter.addElement(fp, FeaturePackXmlParser10.Element.DEFAULT_PACKAGES);
            Object[] pkgNames = fpSpec.getDefaultPackageNames().toArray(new String[0]);
            Arrays.sort(pkgNames);
            for (Object name : pkgNames) {
                FeaturePackXmlWriter.addAttribute(FeaturePackXmlWriter.addElement(pkgs, FeaturePackXmlParser10.Element.PACKAGE), FeaturePackXmlParser10.Attribute.NAME, (String)name);
            }
        }
        return fp;
    }
}

