/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.plugin;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.impl.internal.OptionType;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.internal.ProcessedOptionBuilder;
import org.aesh.command.parser.OptionParserException;
import org.aesh.readline.AeshContext;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandActivator;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.plugin.AbstractPluginsCommand;
import org.jboss.galleon.cli.cmd.state.NoStateCommandActivator;
import org.jboss.galleon.cli.resolver.PluginResolver;
import org.jboss.galleon.plugin.PluginOption;
import org.jboss.galleon.universe.FeaturePackLocation;

public class InstallCommand
extends AbstractPluginsCommand {
    public InstallCommand(PmSession pmSession) {
        super(pmSession);
    }

    @Override
    protected void runCommand(PmCommandInvocation session, Map<String, String> options, FeaturePackLocation loc) throws CommandExecutionException {
        try {
            ProvisioningManager manager = this.getManager(session);
            manager.install(loc, options);
        }
        catch (Exception ex) {
            throw new CommandExecutionException(ex);
        }
    }

    @Override
    protected Set<PluginOption> getPluginOptions(FeaturePackLocation loc) throws ProvisioningException {
        try {
            return this.pmSession.getResolver().get(loc.toString(), PluginResolver.newResolver(this.pmSession, loc), "Resolving options").getInstall();
        }
        catch (InterruptedException ex) {
            Thread.interrupted();
            throw new ProvisioningException(ex);
        }
    }

    @Override
    protected String getName() {
        return "install";
    }

    @Override
    protected String getDescription() {
        return "Installs specified feature-pack";
    }

    @Override
    protected List<ProcessedOption> getOtherOptions() throws OptionParserException {
        ArrayList<ProcessedOption> options = new ArrayList<ProcessedOption>();
        ProcessedOption dir = ProcessedOptionBuilder.builder().name("dir").hasValue(true).type(String.class).optionType(OptionType.NORMAL).description("Target installation directory.").completer(FileOptionCompleter.class).build();
        options.add(dir);
        return options;
    }

    @Override
    protected Path getInstallationHome(AeshContext context) {
        String targetDirArg = (String)this.getValue("dir");
        Path workDir = PmSession.getWorkDir(context);
        return targetDirArg == null ? PmSession.getWorkDir(context) : workDir.resolve(targetDirArg);
    }

    @Override
    protected PmCommandActivator getActivator() {
        return new NoStateCommandActivator();
    }
}

