/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.plugin;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.impl.internal.OptionType;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.internal.ProcessedOptionBuilder;
import org.aesh.command.parser.OptionParserException;
import org.aesh.readline.AeshContext;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandActivator;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmOptionActivator;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.AbstractDynamicCommand;
import org.jboss.galleon.cli.cmd.state.StateNoExplorationActivator;
import org.jboss.galleon.cli.model.state.State;
import org.jboss.galleon.cli.resolver.PluginResolver;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackPluginVisitor;
import org.jboss.galleon.plugin.InstallPlugin;
import org.jboss.galleon.plugin.PluginOption;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.xml.ProvisioningXmlParser;

public class StateProvisionCommand
extends AbstractDynamicCommand {
    private AeshContext ctx;

    public StateProvisionCommand(PmSession pmSession) {
        super(pmSession, true, false);
    }

    public void setAeshContext(AeshContext ctx) {
        this.ctx = ctx;
    }

    @Override
    protected String getId(PmSession session) throws CommandExecutionException {
        return null;
    }

    @Override
    protected String getName() {
        return "provision";
    }

    @Override
    protected String getDescription() {
        return "Install from a provisioning file or the current state";
    }

    @Override
    protected List<AbstractDynamicCommand.DynamicOption> getDynamicOptions(State state, String id) throws Exception {
        Set<PluginOption> opts;
        ArrayList<AbstractDynamicCommand.DynamicOption> options = new ArrayList<AbstractDynamicCommand.DynamicOption>();
        if (state != null) {
            ProvisioningRuntime rt = state.getRuntime();
            opts = this.getPluginOptions(rt);
        } else {
            String file = this.getFile();
            if (file == null) {
                return Collections.emptyList();
            }
            ProvisioningConfig config = ProvisioningXmlParser.parse(this.getAbsolutePath(file, this.ctx));
            opts = this.pmSession.getResolver().get(id, PluginResolver.newResolver(this.pmSession, config), "Resolving options").getInstall();
        }
        for (PluginOption opt : opts) {
            AbstractDynamicCommand.DynamicOption dynOption = new AbstractDynamicCommand.DynamicOption(this, opt.getName(), opt.isRequired(), opt.isAcceptsValue());
            options.add(dynOption);
        }
        return options;
    }

    private Set<PluginOption> getPluginOptions(ProvisioningRuntime runtime) throws ProvisioningException {
        final HashSet<PluginOption> pluginOptions = new HashSet<PluginOption>();
        FeaturePackPluginVisitor<InstallPlugin> visitor = new FeaturePackPluginVisitor<InstallPlugin>(){

            @Override
            public void visitPlugin(InstallPlugin plugin) throws ProvisioningException {
                pluginOptions.addAll(plugin.getOptions().values());
            }
        };
        runtime.visitPlugins(visitor, InstallPlugin.class);
        return pluginOptions;
    }

    @Override
    protected List<ProcessedOption> getStaticOptions() throws OptionParserException {
        ArrayList<ProcessedOption> options = new ArrayList<ProcessedOption>();
        options.add(ProcessedOptionBuilder.builder().name("org.jboss.pm.tool.arg").hasValue(true).description("File describing the desired provisioned state.").type(String.class).optionType(OptionType.ARGUMENT).completer(FileOptionCompleter.class).activator(FileActivator.class).build());
        options.add(ProcessedOptionBuilder.builder().name("dir").hasValue(true).type(String.class).optionType(OptionType.NORMAL).description("Target installation directory.").completer(FileOptionCompleter.class).build());
        options.add(ProcessedOptionBuilder.builder().name("verbose").hasValue(false).type(Boolean.class).description("Whether or not the output should be verbose").optionType(OptionType.BOOLEAN).build());
        return options;
    }

    @Override
    protected PmCommandActivator getActivator() {
        return new StateNoExplorationActivator();
    }

    @Override
    protected void doValidateOptions() throws CommandExecutionException {
        String filePath = this.getFile();
        if (filePath != null && !Files.exists(Paths.get(filePath, new String[0]), new LinkOption[0])) {
            throw new CommandExecutionException(filePath + " doesn't exist");
        }
    }

    private boolean isVerbose() {
        return this.contains("verbose");
    }

    private String getFile() {
        String file = (String)this.getValue("org.jboss.pm.tool.arg");
        if (file == null) {
            file = this.getArgumentValue();
        }
        return file;
    }

    private String getDir() {
        return (String)this.getValue("dir");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runCommand(PmCommandInvocation invoc, Map<String, String> options) throws CommandExecutionException {
        block16: {
            if (this.isVerbose()) {
                invoc.getPmSession().enableMavenTrace(true);
            }
            try {
                if (invoc.getPmSession().getState() != null) {
                    State state = invoc.getPmSession().getState();
                    try {
                        this.getManager(invoc).provision(state.getConfig(), options);
                        break block16;
                    }
                    catch (ProvisioningException ex) {
                        throw new CommandExecutionException(ex);
                    }
                }
                String file = this.getFile();
                if (file == null) {
                    throw new CommandExecutionException("No provisioning file provided.");
                }
                Path provisioningFile = this.getAbsolutePath(file, invoc.getAeshContext());
                if (!Files.exists(provisioningFile, new LinkOption[0])) {
                    throw new CommandExecutionException("Failed to locate provisioning file " + provisioningFile.toAbsolutePath());
                }
                try {
                    this.getManager(invoc).provision(provisioningFile, options);
                }
                catch (ProvisioningException e) {
                    throw new CommandExecutionException("Provisioning failed", e);
                }
            }
            finally {
                invoc.getPmSession().enableMavenTrace(false);
            }
        }
        Path home = this.getInstallationHome(invoc.getAeshContext());
        if (Files.exists(home, new LinkOption[0]) && invoc.getPmSession().getState() != null) {
            try {
                invoc.println("Installation done in " + home.toFile().getCanonicalPath());
            }
            catch (IOException ex) {
                throw new CommandExecutionException(ex);
            }
        } else if (invoc.getPmSession().getState() != null) {
            invoc.println("Nothing to install");
        }
    }

    private ProvisioningManager getManager(PmCommandInvocation session) throws ProvisioningException {
        return session.getPmSession().newProvisioningManager(this.getInstallationHome(session.getAeshContext()), this.isVerbose());
    }

    private Path getInstallationHome(AeshContext context) {
        return this.getDir() == null ? PmSession.getWorkDir(context) : this.getAbsolutePath(this.getDir(), context);
    }

    private Path getAbsolutePath(String path, AeshContext context) {
        Path workDir = PmSession.getWorkDir(context);
        return path == null ? PmSession.getWorkDir(context) : workDir.resolve(path);
    }

    public static class FileActivator
    extends PmOptionActivator {
        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            return this.getPmSession().getState() == null;
        }
    }
}

