/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state;

import java.util.List;
import java.util.Map;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Option;
import org.jboss.galleon.cli.AbstractFeaturePackCommand;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.cmd.state.InfoTypeCompleter;
import org.jboss.galleon.cli.model.ConfigInfo;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.cli.model.FeaturePackInfo;
import org.jboss.galleon.universe.FeaturePackLocation;

@CommandDefinition(name="info", description="Display information for a feature-pack or installation directory or editing state")
public class StateInfoCommand
extends AbstractFeaturePackCommand {
    @Option(completer=InfoTypeCompleter.class)
    private String type;

    @Override
    protected void runCommand(PmCommandInvocation invoc) throws CommandExecutionException {
        try {
            FeatureContainer container = this.getFeatureContainer(invoc.getPmSession(), invoc.getAeshContext());
            if (this.type == null) {
                this.displayDependencies(invoc, container);
                this.displayConfigs(invoc, container);
            } else {
                switch (this.type) {
                    case "configs": {
                        this.displayConfigs(invoc, container);
                        break;
                    }
                    case "dependencies": {
                        this.displayDependencies(invoc, container);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new CommandExecutionException(ex);
        }
    }

    private void displayConfigs(PmCommandInvocation invoc, FeatureContainer container) {
        invoc.println("configurations");
        if (container.getFinalConfigs().isEmpty()) {
            invoc.println("  NONE");
        } else {
            for (Map.Entry<String, List<ConfigInfo>> entry : container.getFinalConfigs().entrySet()) {
                invoc.println("  " + entry.getKey());
                for (ConfigInfo info : entry.getValue()) {
                    invoc.println("    " + info.getName());
                }
            }
        }
    }

    private void displayDependencies(PmCommandInvocation invoc, FeatureContainer container) {
        block5: {
            block3: {
                block4: {
                    if (container instanceof FeaturePackInfo) {
                        invoc.println("feature-pack " + container.getFPID());
                    }
                    invoc.println("dependencies");
                    if (!container.getFullDependencies().isEmpty()) break block3;
                    if (!container.getDependencies().isEmpty()) break block4;
                    invoc.println("  NONE");
                    break block5;
                }
                boolean found = false;
                for (FeaturePackLocation.FPID g : container.getDependencies()) {
                    if (container instanceof FeaturePackInfo && ((FeaturePackInfo)container).getFPID().equals(g)) continue;
                    found = true;
                    invoc.println("  " + g.toString());
                }
                if (found) break block5;
                invoc.println("  NONE");
                break block5;
            }
            for (FeatureContainer c : container.getFullDependencies().values()) {
                invoc.println("  " + c.getFPID().toString());
            }
        }
    }
}

