/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.universe;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.AbstractCompleter;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmCompleterInvocation;

@CommandDefinition(name="remove", description="remove a universe, without --name, removes the default universe")
public class UniverseRemoveCommand
implements Command<PmCommandInvocation> {
    @Option(completer=UniverseCompleter.class, required=false)
    private String name;

    @Override
    public CommandResult execute(PmCommandInvocation commandInvocation) throws CommandException, InterruptedException {
        try {
            commandInvocation.getPmSession().getUniverse().removeUniverse(this.name);
        }
        catch (IOException | ProvisioningException ex) {
            throw new CommandException(ex);
        }
        return CommandResult.SUCCESS;
    }

    public static class UniverseCompleter
    extends AbstractCompleter {
        @Override
        protected List<String> getItems(PmCompleterInvocation completerInvocation) {
            ArrayList<String> names = new ArrayList<String>();
            names.addAll(completerInvocation.getPmSession().getUniverse().getUniverseNames());
            return names;
        }
    }
}

