/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.resolver;

import java.util.Collections;
import java.util.HashSet;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.resolver.ResolutionException;
import org.jboss.galleon.cli.resolver.ResolvedPlugins;
import org.jboss.galleon.cli.resolver.ResourceResolver;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackPluginVisitor;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.plugin.DiffPlugin;
import org.jboss.galleon.plugin.InstallPlugin;
import org.jboss.galleon.plugin.PluginOption;
import org.jboss.galleon.universe.FeaturePackLocation;

public class PluginResolver
implements ResourceResolver.Resolver<ResolvedPlugins> {
    private final ProvisioningConfig config;
    private final PmSession session;

    private PluginResolver(PmSession session, ProvisioningConfig config) {
        this.session = session;
        this.config = config;
    }

    public static PluginResolver newResolver(PmSession session, ProvisioningConfig config) {
        return new PluginResolver(session, config);
    }

    public static PluginResolver newResolver(PmSession session, FeaturePackLocation loc) throws ProvisioningDescriptionException {
        ProvisioningConfig config = ((ProvisioningConfig.Builder)ProvisioningConfig.builder().addFeaturePackDep(loc)).build();
        return new PluginResolver(session, config);
    }

    @Override
    public ResolvedPlugins resolve() throws ResolutionException {
        ResolvedPlugins plugins = null;
        try (ProvisioningLayout<ProvisioningLayout.FeaturePackLayout> layout = this.session.getLayoutFactory().newConfigLayout(this.config);){
            if (layout.hasPlugins()) {
                final HashSet<PluginOption> installOptions = new HashSet<PluginOption>();
                FeaturePackPluginVisitor<InstallPlugin> visitor = new FeaturePackPluginVisitor<InstallPlugin>(){

                    @Override
                    public void visitPlugin(InstallPlugin plugin) throws ProvisioningException {
                        installOptions.addAll(plugin.getOptions().values());
                    }
                };
                layout.visitPlugins(visitor, InstallPlugin.class);
                final HashSet<PluginOption> diffOptions = new HashSet<PluginOption>();
                FeaturePackPluginVisitor<DiffPlugin> diffVisitor = new FeaturePackPluginVisitor<DiffPlugin>(){

                    @Override
                    public void visitPlugin(DiffPlugin plugin) throws ProvisioningException {
                        diffOptions.addAll(plugin.getOptions().values());
                    }
                };
                layout.visitPlugins(diffVisitor, DiffPlugin.class);
                plugins = new ResolvedPlugins(installOptions, diffOptions);
            }
        }
        catch (Exception ex) {
            throw new ResolutionException(ex.getLocalizedMessage(), ex);
        }
        return plugins == null ? new ResolvedPlugins(Collections.emptySet(), Collections.emptySet()) : plugins;
    }
}

