/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.config;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigCustomizations;
import org.jboss.galleon.config.ConfigCustomizationsBuilder;
import org.jboss.galleon.config.PackageConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.galleon1.LegacyGalleon1Universe;
import org.jboss.galleon.util.CollectionUtils;

public class FeaturePackConfig
extends ConfigCustomizations {
    private final FeaturePackLocation fpl;
    protected final boolean inheritPackages;
    protected final Set<String> excludedPackages;
    protected final Map<String, PackageConfig> includedPackages;
    private final Builder builder;
    private ArtifactCoords.Gav legacyGav;

    public static Builder builder(ArtifactCoords.Gav gav) {
        return new Builder(LegacyGalleon1Universe.toFpl(gav));
    }

    public static Builder builder(FeaturePackLocation fpl) {
        return new Builder(fpl);
    }

    public static Builder builder(FeaturePackLocation fpl, boolean inheritPackageSet) {
        return new Builder(fpl, inheritPackageSet);
    }

    public static FeaturePackConfig forLocation(FeaturePackLocation fpl) {
        return new Builder(fpl).build();
    }

    public static String getDefaultOriginName(FeaturePackLocation fpl) {
        return fpl.getChannel().toString();
    }

    protected FeaturePackConfig(Builder builder) {
        super(builder);
        assert (builder.fpl != null) : "location is null";
        this.fpl = builder.fpl;
        this.inheritPackages = builder.inheritPackages;
        this.excludedPackages = CollectionUtils.unmodifiable(builder.excludedPackages);
        this.includedPackages = CollectionUtils.unmodifiable(builder.includedPackages);
        this.builder = builder;
    }

    public Builder getBuilder() {
        return this.builder;
    }

    public ArtifactCoords.Gav getGav() {
        if (this.legacyGav == null) {
            try {
                this.legacyGav = LegacyGalleon1Universe.toArtifactCoords(this.fpl).toGav();
            }
            catch (ProvisioningException e) {
                throw new IllegalStateException("Failed to translate fpl to gav", e);
            }
        }
        return this.legacyGav;
    }

    public FeaturePackLocation getLocation() {
        return this.fpl;
    }

    public boolean isInheritPackages() {
        return this.inheritPackages;
    }

    public boolean hasIncludedPackages() {
        return !this.includedPackages.isEmpty();
    }

    public boolean isPackageIncluded(String packageName) {
        return this.includedPackages.containsKey(packageName);
    }

    public Collection<PackageConfig> getIncludedPackages() {
        return this.includedPackages.values();
    }

    public boolean hasExcludedPackages() {
        return !this.excludedPackages.isEmpty();
    }

    public boolean isPackageExcluded(String packageName) {
        return this.excludedPackages.contains(packageName);
    }

    public Set<String> getExcludedPackages() {
        return this.excludedPackages;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.excludedPackages == null ? 0 : this.excludedPackages.hashCode());
        result = 31 * result + (this.fpl == null ? 0 : this.fpl.hashCode());
        result = 31 * result + (this.includedPackages == null ? 0 : this.includedPackages.hashCode());
        result = 31 * result + (this.inheritPackages ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeaturePackConfig other = (FeaturePackConfig)obj;
        if (this.excludedPackages == null ? other.excludedPackages != null : !this.excludedPackages.equals(other.excludedPackages)) {
            return false;
        }
        if (this.fpl == null ? other.fpl != null : !this.fpl.equals(other.fpl)) {
            return false;
        }
        if (this.includedPackages == null ? other.includedPackages != null : !this.includedPackages.equals(other.includedPackages)) {
            return false;
        }
        return this.inheritPackages == other.inheritPackages;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[").append(this.fpl.toString());
        this.append(builder);
        return builder.append("]").toString();
    }

    public static class Builder
    extends ConfigCustomizationsBuilder<Builder> {
        protected final FeaturePackLocation fpl;
        protected boolean inheritPackages = true;
        protected Set<String> excludedPackages = Collections.emptySet();
        protected Map<String, PackageConfig> includedPackages = Collections.emptyMap();

        protected Builder(FeaturePackLocation fps) {
            this(fps, true);
        }

        protected Builder(FeaturePackLocation fps, boolean inheritPackages) {
            this.fpl = fps;
            this.inheritPackages = inheritPackages;
        }

        public Builder init(FeaturePackConfig fpConfig) {
            super.initConfigs(fpConfig);
            this.inheritPackages = fpConfig.inheritPackages;
            this.excludedPackages = CollectionUtils.clone(fpConfig.excludedPackages);
            this.includedPackages = CollectionUtils.clone(fpConfig.includedPackages);
            return this;
        }

        public Builder setInheritPackages(boolean inheritSelectedPackages) {
            this.inheritPackages = inheritSelectedPackages;
            return this;
        }

        public Builder excludePackage(String packageName) throws ProvisioningDescriptionException {
            if (this.includedPackages.containsKey(packageName)) {
                throw new ProvisioningDescriptionException(Errors.packageExcludeInclude(packageName));
            }
            this.excludedPackages = CollectionUtils.add(this.excludedPackages, packageName);
            return this;
        }

        public Builder removeExcludedPackage(String pkg) throws ProvisioningDescriptionException {
            if (!this.excludedPackages.contains(pkg)) {
                throw new ProvisioningDescriptionException("Package " + pkg + " is not excluded from the configuration");
            }
            this.excludedPackages = CollectionUtils.remove(this.excludedPackages, pkg);
            return this;
        }

        public Builder excludeAllPackages(Collection<String> packageNames) throws ProvisioningDescriptionException {
            for (String packageName : packageNames) {
                this.excludePackage(packageName);
            }
            return this;
        }

        public boolean isPackageExcluded(String packageName) {
            return this.excludedPackages.contains(packageName);
        }

        public Builder includeAllPackages(Collection<PackageConfig> packageConfigs) throws ProvisioningDescriptionException {
            for (PackageConfig packageConfig : packageConfigs) {
                this.includePackage(packageConfig);
            }
            return this;
        }

        public Builder includePackage(String packageName) throws ProvisioningDescriptionException {
            return this.includePackage(PackageConfig.forName(packageName));
        }

        public Builder removeIncludedPackage(String pkg) throws ProvisioningDescriptionException {
            if (!this.includedPackages.containsKey(pkg)) {
                throw new ProvisioningDescriptionException("Package " + pkg + " is not included into the configuration");
            }
            this.includedPackages = CollectionUtils.remove(this.includedPackages, pkg);
            return this;
        }

        private Builder includePackage(PackageConfig packageConfig) throws ProvisioningDescriptionException {
            if (this.excludedPackages.contains(packageConfig.getName())) {
                throw new ProvisioningDescriptionException(Errors.packageExcludeInclude(packageConfig.getName()));
            }
            this.includedPackages = CollectionUtils.put(this.includedPackages, packageConfig.getName(), packageConfig);
            return this;
        }

        public boolean isPackageIncluded(String packageName) {
            return this.includedPackages.containsKey(packageName);
        }

        public FeaturePackConfig build() {
            return new FeaturePackConfig(this);
        }
    }
}

